(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1281616,      26542]
NotebookOptionsPosition[   1273795,      26423]
NotebookOutlinePosition[   1274233,      26440]
CellTagsIndexPosition[   1274190,      26437]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Sample playground", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 
  3.860139755017807*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell[TextData[{
 "This notebook is used for the processing and fitting of one sample. It \
requires the functions in ",
 StyleBox["Polydisp fitting functions all data.nb",
  FontSlant->"Italic"],
 ".\nIntensity units are arbitrary as the patterns are rescaled for merging."
}], "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 
  3.861942913146066*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Select and plot the data to be analyzed", "Subsubsection",
 CellChangeTimes->{{3.854421099868669*^9, 3.854421101948415*^9}, {
  3.8601398442554398`*^9, 
  3.8601398549474306`*^9}},ExpressionUUID->"44c23e06-c6ba-4d87-ae3e-\
52595994b93e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Join", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<E27_*\>\""}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<MilliQ_*\>\""}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testsamples", "=", "%"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"testsamples", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<171_1.4002\>\"", ",", "\"\<171_30.9999\>\"", ",", 
       "\"\<171_9.99982\>\"", ",", "\"\<171_9.99999\>\""}], "}"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.843296948142498*^9, 3.843296958212912*^9}, {
   3.8432972784145517`*^9, 3.8432973057271643`*^9}, {3.8432977131560783`*^9, 
   3.843297716018899*^9}, {3.843298309901671*^9, 3.84329834918407*^9}, 
   3.843298997733918*^9, {3.8432990321174*^9, 3.843299072004407*^9}, {
   3.843299122424327*^9, 3.843299133661518*^9}, {3.843299265884342*^9, 
   3.84329926858108*^9}, {3.843300103749148*^9, 3.843300112466827*^9}, {
   3.8527849855621357`*^9, 3.852784994200242*^9}, {3.852787417047249*^9, 
   3.852787424091958*^9}, {3.8527874789702*^9, 3.8527874801375923`*^9}, {
   3.852787728214538*^9, 3.852787778738393*^9}, {3.8527968489630823`*^9, 
   3.8527968515622187`*^9}, {3.8527969362639837`*^9, 3.852796936383173*^9}, {
   3.8527970088774014`*^9, 3.8527970089163847`*^9}, {3.853836617160633*^9, 
   3.853836617592147*^9}, {3.854421141973649*^9, 3.854421142035899*^9}, {
   3.8544211928939333`*^9, 3.854421193010366*^9}, {3.860120705408345*^9, 
   3.860120705446088*^9}, {3.8617632879814606`*^9, 3.861763304765732*^9}, {
   3.8617673092767124`*^9, 3.8617673185406885`*^9}, {3.8859734491964083`*^9, 
   3.885973455500765*^9}, {3.8859747794365234`*^9, 3.8859748137649736`*^9}, {
   3.8859750181935196`*^9, 3.885975018432844*^9}, {3.8859763176629515`*^9, 
   3.8859763198468237`*^9}, {3.8859770271978893`*^9, 
   3.8859770297569485`*^9}, {3.8859774963407874`*^9, 3.885977500029621*^9}, {
   3.8859790256696296`*^9, 3.8859790880678005`*^9}, {3.8859792862203617`*^9, 
   3.885979303353922*^9}, {3.885979636059869*^9, 3.885979636325242*^9}, {
   3.8859798673963566`*^9, 3.885979867979951*^9}, {3.8859802087472224`*^9, 
   3.8859802091063414`*^9}, 3.8859802670443172`*^9, {3.8859805336112413`*^9, 
   3.8859805370509305`*^9}, {3.885980676883481*^9, 3.8859806770585265`*^9}, {
   3.8860615694895253`*^9, 3.8860615965610476`*^9}, {3.8902035063775234`*^9, 
   3.8902035070815973`*^9}, {3.8914972133528996`*^9, 
   3.8914972138838634`*^9}, {3.9023888059468164`*^9, 
   3.9023888069662485`*^9}, {3.9023888909848557`*^9, 3.902388892984962*^9}, {
   3.9023901562745895`*^9, 3.902390156360857*^9}, {3.902480566592359*^9, 
   3.9024805673601418`*^9}},
 CellLabel->
  "In[1362]:=",ExpressionUUID->"288b6ba3-0e36-41d8-949e-a2c664f880eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"E27_30.9849\"\>", ",", "\<\"E27_10.0001\"\>", 
   ",", "\<\"E27_1.5\"\>", ",", "\<\"MilliQ_30.9849\"\>", 
   ",", "\<\"MilliQ_10.0001\"\>", ",", "\<\"MilliQ_1.5\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.85278774182577*^9, 3.8527877823161783`*^9}, 
   3.852796852362589*^9, 3.852796937189692*^9, 3.852797010008708*^9, 
   3.8528624946560097`*^9, 3.853381366643115*^9, 3.853381473062273*^9, 
   3.8534022376061707`*^9, 3.85346909236896*^9, 3.8534962759553757`*^9, 
   3.8534996218158073`*^9, 3.853817842919454*^9, 3.853818242802884*^9, 
   3.853824682294836*^9, 3.853824869851644*^9, 3.853833074084684*^9, 
   3.853836452539434*^9, 3.8538366226871643`*^9, 3.8538385385329847`*^9, 
   3.854072553810278*^9, 3.85409167434895*^9, 3.854098459654634*^9, 
   3.854420757546021*^9, 3.854421148417843*^9, 3.8544211935109262`*^9, 
   3.8544236425084476`*^9, 3.860120714271991*^9, {3.8601208146323557`*^9, 
   3.860120817823097*^9}, 3.8601209904370317`*^9, {3.8601401966367846`*^9, 
   3.8601402016808*^9}, {3.8601411929801598`*^9, 3.860141197066132*^9}, 
   3.8617633119613857`*^9, 3.8617673196071157`*^9, 3.861941017862147*^9, 
   3.8619433170388165`*^9, 3.861950007077615*^9, 3.861950097594084*^9, 
   3.861950313053934*^9, 3.8859734561647086`*^9, 3.8859735723144336`*^9, {
   3.8859747343360167`*^9, 3.8859747430702314`*^9}, 3.8859747970713787`*^9, 
   3.8859750198706293`*^9, 3.885976323503401*^9, 3.8859770304553003`*^9, 
   3.885977536755321*^9, {3.885979057328891*^9, 3.885979092434539*^9}, {
   3.8859792905705223`*^9, 3.885979306593282*^9}, 3.8859796400840683`*^9, 
   3.885979871667265*^9, 3.8859802113912177`*^9, 3.8859802706713324`*^9, 
   3.885980540538966*^9, 3.8859806802452884`*^9, 3.886061601230296*^9, 
   3.8861522211573744`*^9, 3.8883109765610237`*^9, 3.8890022652170677`*^9, 
   3.8890603226490602`*^9, 3.88906456673145*^9, 3.889081912662714*^9, 
   3.88908274923429*^9, 3.889084479032218*^9, {3.8895035587135143`*^9, 
   3.8895035763897266`*^9}, 3.8895042359682283`*^9, 3.889668723612721*^9, 
   3.890203509837488*^9, 3.89020358352724*^9, 3.8909804837292213`*^9, 
   3.89098153769302*^9, 3.890982738443742*^9, 3.8914160072605443`*^9, 
   3.8914972154035673`*^9, 3.8914975432719035`*^9, 3.891498587225662*^9, 
   3.892613775368435*^9, 3.8926144482288322`*^9, 3.892695999633297*^9, 
   3.9020371032316065`*^9, 3.9020419939951*^9, 3.902293358308179*^9, 
   3.9022934769339275`*^9, 3.902296666667019*^9, 3.9022975254696093`*^9, 
   3.9022975853820953`*^9, 3.9022983612995796`*^9, 3.902388894211306*^9, 
   3.902390157614946*^9, 3.902480570830711*^9, 3.9035810181163144`*^9, 
   3.9040176674498005`*^9, 3.9041112772074165`*^9, 3.90470411883255*^9, 
   3.9077450805600424`*^9, 3.913800842868396*^9, 3.915272663185849*^9, 
   3.9155254681886196`*^9, 3.918727361756708*^9, 3.9187274179507217`*^9},
 CellLabel->
  "Out[1362]=",ExpressionUUID->"b50cf346-be9f-4a88-81ec-5c58dd074e4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataToPlot", "=", 
   RowBox[{"scatteringDataSampleAveraged", "/@", "testsamples"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotDataRaw", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{"dataToPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "testsamples"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", 
         RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.01", ",", " ", "0.1", ",", " ", "1"}], "}"}], ",", 
        RowBox[{"{", "Automatic", "}"}], ",", " ", "None", ",", " ", "None"}],
        "}"}], ",", " ", 
      RowBox[{"FrameTicks", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
        "LogTicks", ",", "LinTicks", ",", " ", "None", ",", " ", "None"}], 
        "}"}]}]}], " ", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<DataRaw.pdf\>\""}], "}"}], "]"}], ",", "plotDataRaw"}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.84329809635746*^9, 3.843298105573452*^9}, {
   3.84329815837682*^9, 3.843298163080853*^9}, {3.843298211914578*^9, 
   3.8432982378108053`*^9}, {3.843298288845417*^9, 3.843298291452414*^9}, 
   3.843298361191868*^9, {3.84329871517915*^9, 3.843298719649724*^9}, {
   3.843299850907208*^9, 3.843299962957724*^9}, {3.843300008752656*^9, 
   3.8433000099440603`*^9}, {3.8433000666678867`*^9, 3.843300081842258*^9}, 
   3.8433001270605783`*^9, 3.852785029476323*^9, {3.8527875156086903`*^9, 
   3.852787529623748*^9}, {3.852787908039447*^9, 3.852787908637274*^9}, {
   3.88951548143122*^9, 3.88951548156557*^9}, {3.8896687353498526`*^9, 
   3.8896687417207317`*^9}, {3.8896725688232393`*^9, 3.889672590126113*^9}, {
   3.889672623190502*^9, 3.8896726983115826`*^9}, {3.889672740640524*^9, 
   3.889672758876796*^9}, {3.8896729834503565`*^9, 3.889673069010479*^9}, {
   3.889673142722207*^9, 3.8896731964734883`*^9}, {3.889676349237294*^9, 
   3.8896763709122796`*^9}, {3.889692253576544*^9, 3.889692254563936*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"6ebf2b6c-fd73-4115-90fc-264fde664a3f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k4lG8Xnn2fMYttiNJiSVkihHKUtBEqSVJUSJZEIrK2adFCi1RKFBWl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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81d8bv/bemyI0ZCWkgc6pUEiplNFQkYxQEoqyZRRFEiUkEqIyCtXz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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwc2Xc8lt//B3B7j/u+JZqaRkuoVOitIhVSyipJQ4qyP6KsKIWGVSmRSGWV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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWXk4lV8XvfM8G0MihSISSUX3ipSQKZGhSUgkYyRlSDSJJJWkVH6pKBVR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         "]], 
        LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAVJuUuqUW+b9TnJQbejEVwEMyhbx6
Fvm/J2D2KhcTFcDNoU05jhP5v6W1jUu4zxTAZSTvUaIQ+b8M/waFg+kSwBgg
4t+2Dfm/i8lzT5sCFMCjiUMJzAr5v8ZIz4C3ghPAf/iZp+EH+b8kTUvHpKIS
wOqh9OD3BPm/oWenMp+NEsBJROiODgL5v9X/x1vQpxHAOV921yX/+L8FttZr
8osRwJjNQZQ9/Pi/SUYxfTVNEcAtYz7rVfn4vwDtWmp4jhHA7gwdtm72+L/3
jO5LhyAUwKqavQeI8/i/Zb4fzYZmFMDEJvLyofD4vy1GAwA9mRHA/KWAUbzt
+L+HFKN0gUMRwBrpOknX6vi/SvL6qXaoE8Aj3fSz8uf4v+MMl4sA2hLAEMly
tw7l+L/aDjekAkgUwO6Hli0r4vi/9ZaVBHMsEcCG4BY8SN/4v7oZxeZi6xLA
upHjvGXc+L8hwyCmNn8TwLrrpdWD2fi/lF6S7iFWEsAUh1tgotb4v0ab8XUU
VBLA70aggsHT+L9CEy8QL1QSwAUzekm90fi/U5yUG3oxFcCqs+Dx
         "]], 
        LineBox[{{-1.5507840121071017`, -5.298317366548036}, \
{-1.5502941665461147`, -4.5921832849995985`}, {-1.5495928444796965`, \
-4.547153930041596}, {-1.5488920840498683`, -4.697348801576042}, \
{-1.5481917442618196`, -5.233753760444834}, {-1.547491964636865, \
-5.200163232875682}, {-1.546792604379457, -5.2388203150413135`}, \
{-1.5460938028176863`, -5.043085823279447}, {-1.545395419354704, \
-4.692603409258288}, {-1.544697593125908, -4.956153854252358}, \
{-1.544000183732585, -4.555434783236512}, {-1.54330333011797, \
-4.293750065914779}, {-1.5427953501221112`, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAT6eL5kKt+L9TnJQbejEVwMbfpOCq
q/i//JrSHmJNE8DpzACg0aj4vyplNcm+9xLATLvG8/il+L9y4iu61XMQwJwo
b7Ygo/i/fxpG0BAXEcDnyR4NSaD4v17gvMAC4BDATpNb0nGd+L9UCbTJoOwR
wDEqPSubmvi/XDER5DN3E8B671byxJf4vx+TNxlCmBTA+4GzTO+U+L9eX1Ys
aOkSwL2l8xQakvi/VFNWfpvGEsAb/BRwRY/4v2so+LwSWRLApaLFOHGM+L/K
3UBz/PsSwExG9pOdifi/McgZvoo9E8CTVGJcyob4vwR4xmjcChTACI/ttveD
+L+RVmGW/lISwJqpYH4lgfi/exhMejR5E8Brg5LXU374v+az1sZ4bRHAXQ1Z
nYJ7+L/iZNCsbbQRwNtGpIfqePi/U5yUG3oxFcCP36/j
         "]], 
        LineBox[{{-1.527657696807036, -5.298317366548036}, \
{-1.5274074548082694`, -5.116739367703919}, {-1.5267220645678763`, \
-4.707969339984921}, {-1.526037075221509, -4.606028635557705}, \
{-1.5253526232615031`, -4.835433229283427}, {-1.525015699551366, \
-5.298317366548036}}], 
        LineBox[{{-1.5238297641995628`, -5.298317366548036}, \
{-1.5233019370337033`, -4.678147730884797}, {-1.5226193539486337`, \
-4.779313694174438}, {-1.5219371682018612`, -4.364742048698959}, \
{-1.5212555157322984`, -5.190171354426918}, {-1.5205742594257254`, \
-4.936554603781768}, {-1.5199108241558215`, -5.298317366548036}}], 
        LineBox[{{-1.5198854854430557`, -5.298317366548036}, \
{-1.5192132056420231`, -4.51095580478532}, {-1.518533406811518, \
-4.990891304235465}, {-1.517854001808127, -4.95234953497288}, \
{-1.5171751260217892`, -4.551712829010574}, {-1.5164966429019437`, \
-4.714431840315899}, {-1.5158186876565174`, -4.6900231971052735`}, \
{-1.515141123921803, -4.908711414561605}, {-1.5144640867242012`, \
-4.784751307742976}, {-1.5142368453741228`, -5.298317366548036}}], 
        LineBox[{{-1.5132522723918485`, -5.298317366548036}, \
{-1.5131113182535962`, -5.030810195782161}, {-1.512435585834416, \
-4.092387892637755}, {-1.511760377293606, -4.276554556520233}, \
{-1.511149070204582, -5.298317366548036}}], 
        LineBox[{{-1.5110233633777153`, -5.298317366548036}, \
{-1.5104112589131724`, -4.253508619955745}, {-1.5097373479368708`, \
-4.950442667771747}, {-1.509063958201169, -4.722518902266075}, \
{-1.5083909542689755`, -4.624378188334795}, {-1.5077184702662918`, \
-4.524228426428004}, {-1.5070463709398338`, -5.083463867320748}, \
{-1.5063747902369549`, -4.589900153781429}, {-1.5057035930876783`, \
-4.713982167573609}, {-1.5050329132611828`, -4.699871823138731}, \
{-1.504362615870301, -4.064302931903678}, {-1.5036928345065073`, \
-4.588989208341382}, {-1.5030234344649467`, -4.161724734392498}, \
{-1.5023545491598602`, -4.4004387405303405`}, {-1.501686044068211, \
-4.079959404780386}, {-1.5010180524274725`, -4.935041413981877}, \
{-1.5003504398959346`, -4.581608666964016}, {-1.4997861083977115`, \
-5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAgXxmtmT+979TnJQbejEVwEZkL9n4
+/e/QRtWEwwcEcC/rmhGPvn3v7C2XJOM3A/A0FPPGIT2978RedhCs8YSwMoV
A3TK8/e/gIk+zo48EsB0Phk0EfH3vz1+a6m6XxHA+oqlfFju978Z/FNnVxAT
wMeYySmg6/e/QDLfuoo0E8DyJw1f6Oj3vz8x5x6IMhLADCGe+DDm978t/Iur
G8IQwCFP+Bl64/e/TRQSSgmFEsBz3VWfw+D3v3VZxZ2qMBDABKomrA3e978N
/Zvck+sSwF0asRxY2/e/xR0WkWtAE8BtJ1kUo9j3vzIGKVt8URPAoWhxb+7V
97+2WmGHhVMRwMb5UVE60/e/lNzf949DEsDXm1mWhtD3v3exHU10CRPASyGW
/dXO979TnJQbejEVwBxDoQE=
         "]], 
        LineBox[{{-1.4866920886593822`, -5.298317366548036}, \
{-1.4864332849055473`, -4.3918179115924225`}, {-1.4858045682954013`, \
-5.298317366548036}}], 
        LineBox[{{-1.4857516724374533`, -5.298317366548036}, \
{-1.4851178845161175`, -4.169416645040039}, {-1.4844607997309092`, \
-4.87702247400595}, {-1.4838041464226144`, -4.22130603999675}, \
{-1.483147989691325, -4.039931797929089}, {-1.4824921975960532`, \
-4.356365828018767}, {-1.4818369008625651`, -4.109413488067897}, \
{-1.481181967724281, -5.028691992653523}, {-1.480527528737217, \
-4.863275791882381}, {-1.4800243232795398`, -5.298317366548036}}], 
        LineBox[{{-1.4783772978222731`, -5.298317366548036}, \
{-1.4779139166554274`, -4.06100099447116}, {-1.4772615469401982`, \
-4.7870782417446165`}, {-1.4768453148135954`, -5.298317366548036}}], 
        LineBox[{{-1.4745639936351498`, -5.298317366548036}, \
{-1.4740062621348442`, -4.673739932584508}, {-1.4733564358543128`, \
-4.4089279142673865`}, {-1.4727070965580973`, -4.436101775942695}, \
{-1.4720581136876305`, -4.448686905631951}, {-1.4714096166228556`, \
-4.652351057481545}, {-1.4712095625160921`, -5.298317366548036}}], 
        LineBox[{{-1.4703488292944646`, -5.298317366548036}, \
{-1.470113817960614, -4.4742992363593315`}, {-1.4698702826940921`, \
-5.298317366548036}}], 
        LineBox[{{-1.4680967715761266`, -5.298317366548036}, \
{-1.4675272470658223`, -4.774004413713747}, {-1.4668816160554343`, \
-4.34418097050364}, {-1.4662364661807126`, -4.937991012721922}, \
{-1.465591667732429, -4.6197197757908715`}, {-1.464947349263309, \
-5.291270906871537}, {-1.464942369632365, -5.298317366548036}}], 
        LineBox[{{-1.463207795446612, -5.298317366548036}, \
{-1.4630167522798372`, -4.7631462538620815`}, {-1.4623740902098459`, \
-4.1214939872597505`}, {-1.4617317766141338`, -4.49778673757723}, \
{-1.461347073847317, -5.298317366548036}}], 
        LineBox[{{-1.4608424845778605`, -5.298317366548036}, \
{-1.4604484499921375`, -4.446295392879959}, {-1.4598074358266464`, \
-4.19635992360772}, {-1.4593934287254204`, -5.298317366548036}}], 
        LineBox[{{-1.4589457635026102`, -5.298317366548036}, \
{-1.4585265748084162`, -4.154014380736109}, {-1.4578867269870992`, \
-4.159351872824576}, {-1.4572473522966587`, -4.004606702398984}, \
{-1.4566083221984727`, -4.631969906558996}, {-1.4559697641046996`, \
-5.217820571156017}, {-1.455331549642218, -4.6423320478767796`}, \
{-1.454693806061891, -4.934153709426701}, {-1.4540564051556697`, \
-4.701284012402912}, {-1.453419474013529, -4.941133689384942}, \
{-1.4527828845920665`, -5.245224678301499}, {-1.452146763820773, \
-4.668999336793717}, {-1.4515109838204694`, -5.016033956895118}, \
{-1.450875671360565, -4.604789018227504}, {-1.450240698725682, \
-5.066292174657704}, {-1.44960619252555, -4.867855223306465}, \
{-1.4489720252081706`, -4.3424908048139965`}, {-1.44836756025333, \
-5.298317366548036}}], 
        LineBox[{{-1.4483096030706462`, -5.298317366548036}, \
{-1.4477049591839843`, -4.325000781703364}, {-1.4475026054861992`, \
-5.298317366548036}}], 
        LineBox[{{-1.4447216046243911`, -5.298317366548036}, \
{-1.4445443318354423`, -4.388152461132473}, {-1.4439133654639633`, \
-4.843372601766611}, {-1.4432828600600944`, -4.242749857022241}, \
{-1.442652688882483, -4.358979397714473}, {-1.442022977591132, \
-4.217666553446065}, {-1.4413935996055782`, -3.59983078347606}, \
{-1.4407646804289143`, -3.808928764220794}, {-1.4401360936411576`, \
-4.443740408897002}, {-1.4395079645888802`, -4.308736075475107}, \
{-1.4388801670121718`, -4.227885274502009}, {-1.4386821892322432`, \
-5.298317366548036}}], 
        LineBox[{{-1.4377587694791105`, -5.298317366548036}, \
{-1.4376258157565367`, -4.673589042106624}, {-1.4369992610120605`, \
-3.569012752744541}, {-1.4363730359270597`, -4.576794422987429}, \
{-1.4359510751815578`, -5.298317366548036}}], 
        LineBox[{{-1.4355737861083837`, -5.298317366548036}, \
{-1.4351218235913639`, -4.390375619373803}, {-1.4344968352829026`, \
-5.247413968331848}, {-1.4344390840549062`, -5.298317366548036}}], 
        LineBox[{{-1.4336763395247736`, -5.298317366548036}, \
{-1.4332479668078684`, -4.2052928963942735`}, {-1.4327392302783033`, \
-5.298317366548036}}], 
        LineBox[{{-1.4321366048448723`, -5.298317366548036}, \
{-1.4320006560601077`, -5.22932548184958}, {-1.4319539020781844`, \
-5.298317366548036}}], 
        LineBox[{{-1.4308457863702009`, -5.298317366548036}, \
{-1.4307548991585208`, -5.152956474284965}, {-1.4306753845814615`, \
-5.298317366548036}}], 
        LineBox[{{-1.428292624396038, -5.298317366548036}, \
{-1.4282680314418295`, -5.004515793841199}, {-1.428034456890112, \
-5.298317366548036}}], 
        LineBox[{{-1.4272353854037358`, -5.298317366548036}, \
{-1.4270269129366706`, -5.051787807372178}, {-1.426406899825161, \
-4.277916817665166}, {-1.4257873328974344`, -4.298107198403217}, \
{-1.4251680876278896`, -4.117921917704975}, {-1.4245492875147385`, \
-4.996745675320322}, {-1.4241695362152778`, -5.298317366548036}}], 
        LineBox[{{-1.423858650792635, -5.298317366548036}, \
{-1.4233127729933317`, -3.8641187524902656`}, {-1.4226950577163084`, \
-4.578182938306545}, {-1.422307611220961, -5.298317366548036}}], 
        LineBox[{{-1.4216384608539723`, -5.298317366548036}, \
{-1.4214608324396025`, -5.125603506685006}, {-1.4214159237699004`, \
-5.298317366548036}}], 
        LineBox[{{-1.4204445274583402`, -5.298317366548036}, \
{-1.4202281285973302`, -4.108419355434461}, {-1.4198836084002615`, \
-5.298317366548036}}], 
        LineBox[{{-1.4177672702445512`, -4.42451757998899}, \
{-1.4171530314522605`, -3.7007830017060748`}, {-1.4166190730528825`, \
-5.298317366548036}}], 
        LineBox[{{-1.4156586186515971`, -5.298317366548036}, \
{-1.4153124528526964`, -3.2669096227498806`}, {-1.4146997195939561`, \
-4.004628231392718}, {-1.4140873002628984`, -4.348435719040792}, \
{-1.413475317006711, -4.417030960796162}, {-1.4129355184007053`, \
-5.298317366548036}}], 
        LineBox[{{-1.4111497226331773`, -5.298317366548036}, \
{-1.4110309390627105`, -4.530198262322827}, {-1.4108320439977735`, \
-5.298317366548036}}], 
        LineBox[{{-1.4099919077746101`, -5.298317366548036}, \
{-1.4098110175758594`, -4.628550312895307}, {-1.4092016449499942`, \
-4.994552443614887}, {-1.408592582484341, -4.399918752601123}, \
{-1.407983951661553, -4.647926518537731}, {-1.4075528388521383`, \
-5.298317366548036}}], 
        LineBox[{{-1.4072023621087235`, -5.298317366548036}, \
{-1.4067677393468678`, -4.627719079937941}, {-1.4061601570295124`, \
-4.540392490081494}, {-1.40575930451822, -5.298317366548036}}], 
        LineBox[{{-1.4039910402729814`, -5.298317366548036}, \
{-1.4037336339141793`, -4.292470002563744}, {-1.403127952330942, \
-4.544327336325885}, {-1.4025225767960212`, -3.848468552688865}}], 
        LineBox[{{-1.4013129845633252`, -4.463341699545218}, \
{-1.4007087669074316`, -3.798031303944849}, {-1.400577617009055, \
-5.298317366548036}}], 
        LineBox[{{-1.397090926860967, -4.534369996282874}, \
{-1.3964891938880408`, -3.790332725479682}, {-1.3958878829591637`, \
-4.821278745002173}}], 
        LineBox[{{-1.3944731682072966`, -5.298317366548036}, \
{-1.39408599644067, -3.866784774349068}, {-1.3938881328929287`, \
-5.298317366548036}}], 
        LineBox[{{-1.3904919944895109`, -4.008764117333086}, \
{-1.3898942778759669`, -4.4185632288682175`}}], 
        LineBox[{{-1.388699855629594, -3.63144773955341}, \
{-1.3881031492161637`, -4.836412464546969}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81d8bv/Ze936kiIhKZkYaiISMhJBQyWhRlJWSyF6FrJSRnV2kQXlO
2SlJqK+Vkb2uvfmd31+9Pq/POOc8z/t5jysRW+czl2lJJJI0A4n0/3+V9Qy4
lVgIpBabqHM8g1dd4kXI2vdqCuIYtHyk3URRt/Lk7CkKoKDP6xG0ykpkdaOa
u2fNdSjI5KPsoOIAt3qdo9srKy4K2vuGoazkMZd6afM1OZv/yCgxQa5933UO
9Zd+OV/4s8moWsjncIcHm7qeQuZ1bXcyUqkbrEkuYlEPMUTb8rXJqIMxlLR9
O7P6tFyRNh8/GYlLBVEeZDKq/3oY/cR6mgf9OV3/0EmfQf1obl7vhVoe1HZ+
0/LlOJ269GCcEzWFB5HW1fatRdOqR1/4orziyYO41VJ/tB2hUe8R2vb4gikP
CgDf9viRLbWlBM8LDHI8aHQ/I+dOnU21Q+QegU5OHvTlwItSQ+t1tYLv59Ub
J7nRmBSFpC+4qrb7yHnx6u/cyNKKUpLEtKzGc+cjlBVxoweH4vtzzBbVbm2s
2URHcSP/rNkXbnfn1VT04zJ1XbnRu8jXvz5sm1Ozp1s3bjnLjYbv3ji9cHRG
jU1KaaewMjdS5LFr6zs2rbb3kmKauDA32kY5v+dZ2ISaFqlYs5+BGz1+sPbO
ymNEbTEzzinkDxfSa+TkKzEbUnMt++Uekc2FDmoEMBlu71cr8Eq98NmdC/3e
zPShS+5SE3wku7Bdmwv93bnxul7+t5rxacelQD4udEeH/ztz6E+1N0N/96yP
cqJuBuXXnJoNaifqpMadP3EiY81HxyU3KtSinjB4tUdzoizLH/S1WVlqtDdI
b/dc5UTE58vGLTNP1Ixd/bhNVTlRbhPX9YLSj1CzwlNyjuBEfhczpely6+HY
jwf7JCc40DynKGv6xR+QGk0TWFXNgcK4Ja2sDNrgw5vQk/wpHOhH79E+lZUO
4FGZcxP35EBB31ryOJ/0wv0j42eHz3CgAMXcHDqTPvjuv5VkJMOB5EVVMuVU
BkD0dLf+RVYOZAibWRE1g9C4JFXEOsyOhL/WfNW9OwQ73zu6GVWzo7WKILsB
GIbgo2N3JNLZkSWdj97Q/Bh0rLR0xviyI3vDnHHZE5PQYTa8GGzNjgobXn71
C5qC6BFfF1o1diSucXUpToYKooGx5C0hdmSSUJrOqEMFyt9HbXe32JB4/onK
TK0Z2BK7P+LUy4ZMuJkHlC3nYP6nelLHZzb0JUFv7rTsHGjKH/H/kMGGorh2
vrN5MgeHHj9UYg5iQyyO3Qs2d+dAwePw86prbOiujjJDasQ8LJ1/7Teiz4b+
+xXM0Mq5CKK9t3e6ybKhv3Zvx+vyF2Fd7OA9OwobGkg03+J7uQQvZOWXS5dY
UYSlrgqN9AoIOXpy2HWxorIv4y46JasguEIn7PSZFaVRWUwmONagyHTHSEs2
K6KPZH/OuGMdjDP+rD+OYEXBvSeXfxuuA+t3itILF1ZkMME6XhW3CRW2+3zp
LVhRdCnQ3qbfhFUf7tIPaqxIM2liv03aJqRGDkx/2suKnnZ1mryo2ILgmhpF
Lk5W5OpQuCJWuAXqTvQf8hdYkPcPq+qlXSTEHzJYFd3NgjYzMlvEVEnI8pFx
ENSwoG1t3mf1HpNQlzGdq0IRC4puPucpI0+DBGdW/ozHs6CRhurg4040KMbC
8eiwDwtSuZ3jIV1Ii/QS9+wVu86CjC0PvNtVT4tYNjwoaWdYkFW31GMWPTrE
93M497wKC2JJWEn/R0eHjmhtPDfby4JKIvgFfTXo0Uu7cwFh3CyIrd6CT9+C
Hl2UC1NaXWVGJM1o+6kj9CjzmZVtxiAzur+WllmjR4+cfz8ZCGhmRgJHvRM+
sDGgd8GNKckVzOhEzVri5Ct69Dv3xqWJbGZ0ZF/at592DEjwl/v+W0+Y0VP2
VK4MNQYUEx72e98DZmR86ck/hUl6VH2j4RbZgRlZty53GFgxopsHH9DKnmVG
ealfZqPiGJFZ7ceH9zWYkba0IydHIiMqzgwiVmWYEXMZX1J9HSOSlBWuzBZg
RluH/hwcHmNEWSVmOQ+ZmZELPVnqbQMT6ia3b4YuMKEao5583j4mtGtUp7Oy
nwkxFT/5t0+ZGam573q4q5kJ3djRSDOBmNGDv43k/E9MiN7WvcbLmxmFtlW3
XcpnQuefZMBXHWY0vs2aUE9kQuyp15QGcd1XdivT6AQzoQ7+p/QJuI+iZTnU
O+5MSDhbOmLlKwt6lmao/MOOCY0cf9RixsWKbN9e2W1whgk9fu906CKFFfGF
lHPPqDMh3vJlLn1GNuQn5WhULsuEphn8TZsjWZFutY7+SyEmVGeonqt5kRV5
vG1wKudgQlUpTnyJC/h9nUs81HVGdDdSlnV3CBtybOl/pTPBiH4VX4q232BF
0vlm+VWdjGhtxmHJtp4VPWEqun+pkRF5nM84pXCBDZnemM8QqmBE/h0yBjfa
2BBbcl7oRh4j4q85rBrtxo5ecaKK9WeM6Nxfp6ZOGjZktEcmVyAcvx/3+9mJ
J+yoqtKk28KLEf09PMHaTMuBrI9LDr11ZEReRj2sgcc5kKhfvrL8eUZk4fYg
520jG/rnfudu4ylGVFNwP5Y6yoZKtXgF/VQZUc7es4kuvhyIrMANZjKM6Lxp
nF/JOw7Ekqg8q7WLESW2f4sNEONErgExVme48fO5ul+NAjhQVtyayz0aRhSk
WLvt1FkOxLNdpP/TLAPqqqh6/VaeA73a3NLc+Y8BBXvfTirYxonu7Sw7EtfG
gF4S6/wzJVxorTjLWbyOAU2NSF2qHeNEb9rvOrS9Z0BUxTpF+hxONOGS2/08
jwHtS/5+88wWJ7oSo+7slcSAhH//+uqewYlOh4vVuT5mQPQhF30PvOZEv7iZ
IgN8GVAipz3PyUmsK/pzvoUuDEjcWs4i6yEnCvz6RWrKngE1v+di8b2H96O2
aKhtzoByFQqchNI4EPXx8rMyXQZUnZFeFQBY977WgrIKA2pcV/hyYx6vd43B
948M/r4Ag5jDEicK/WjtFi7CgGSj6XXdBrlQFo+/jSnBgPiFWyurSNyowcJw
S56JAT0hxboHF3Eh1msMTPtW6ZGilsX2/ANcqCB3XP0AnsMInbUqeQ4uNDjk
aXC6lx79lKg4azXNhWhXU5d8f9Gj7aOyheuK3MjpRdNGXS09Gg4Ze0JO40Je
vrm7RMvp0cfbazPyzNzo/baTkk8K6ZEP/y7Sm1EuRHObpZ5Io8d+ZHTfp1Pc
KCTQvjYvlh6NF1waSqzhQiXxj8dMQuhRb54Q708lbpQ21LzCdZ8eLblYFveV
cyPZtYt1Pc70SPayWoTfR270ObqGhOzw93aaNdmJcKO/f429Ss3pUVY46yG+
WG50OsqC9EGfHt244/vvCvYZB5z2Wjar0aOOZeOwYuxTAl84X1pRwOu9T9i8
J8CN/php1yqI06Mr165FbfvLjXzH1S/77KRHKJ7qeYCbB3H81GDr4qZHvhes
7nLL86CcSeZgXQZ6tC14tG9PDzd6vqX7pm6FDv234HfhrR0P6vJm0z87RYfm
371W0d3Gg3zevBJf6KdDl1+PHhdj40Exf6V2Zf6mQ0sSai+OBvCgvNiDNHbf
6NBwpof9bAw3cmPlKpL7TIcupjuAZhc3Ou92sJ/rLR3yqWx++W2KG/kF3nyw
kUeHFPzGrA2v8yBqz6lzq6l0aKKeS7BJH/s+Kz5txjg6lOeeJycuwIPEM5Ql
RMLokCOdvrv0HDfq7TlWo+dDh8I0psp9X/Agqfejq35udGgrftYxpJcH2bYQ
mQ3X6VAXc3FBQQIPYnQ7+EzImg6pBxR721TwoKSTlu8emtIhK+WBTQZrHjSY
ZdA3q0uHSpenG7f/5kY/+aa6bqvRoZrofXzGB3hQ5eah6E1FOqQns+vwsac8
6Ab4djyVoEMPhuX0R2x5kLzAyzh1YTqkOZO2fnQXD6oxm8tb4KVD/IHb0iMj
eNCu4YD+d2x0SH4+MeAS9sUyMu/2BNPQodm5CXtZKTJqUfE0sVuiRfOOJf0V
AWS0qqWgf2oS66L4Dv0+IzJ6wX1t6fgALfoVU3pmCvtszs8Kopr/0aKHHTqW
P1p4kE4RT/mZH7SoaEOa9UsGD1JI0k2+WUOLpE5GV88LkFEpxBbFVtCi9xe/
HT21m4ziStw66l7TohmrgjsP7ckoQQ1NMb6kRc+1H5oOWpCRPrX7j3EKLTK6
XZ0QcYEHfQ85dP9lLC3iakpiqsXXfgPJH1nDadHnpdTCuhNkdMHGNsTzIS1C
xYbR3ks8yDmys3jmDi3ay3rsqMgOMrqTKbnbw4kW/Y55nVAmR0bHtwqqGS7T
om/ucf4BuH+1fXzeL6xokd1em7Cebh60ucdGWfsMLQp/T3OkyIOM7l6XbFnU
oUV51Gvuc1pkdMJVQr5EjRZJHyPxvmrnQQkG3hqeSrRIVe8Y1amaB1WUPh3T
kaZFvQnwrS6NjMIyJwXExGhR4Insx9ZWZGTkr5LPIkCLPpQ/kNq6jvejkhW2
wkOLDO6b8cfY4dxz9l/6HDMtkjwUkm02h8/7nr57aYsGnZHJ4K7cRkY5gc2S
jEs0SG1bUErEYzIin12/LDRFgzY8nt+WJ5GR09DsA/VBGlS1EN1eFUFGZfLj
l2500SDNJg39ohtklMFkv5j2iwZRbP4098zzIG03G4W+rzQowXLnK48oMpr9
7wp1/xcaVLuvuUzkJxnR0bHvvv+BBl0eH1NrfUtGiyv9pb9f0SC/1M+8XHFk
9OYdRKu8pEGXhHpS3hwiIz6Wdzl5qTRoPSZKfBsrGZntEBkXSaBB6rfXAr/h
ftic81VKf0yDGniOWyXhfjwZL/GRDKJBzXtPq6TYYnxY1JZ+8qZB/hdq7agE
BXV+p0Pn3GlQbKPbnbN/yejRp6pn6zdo0I3DgYP59WSkfZpHONeeBpXqgIdk
C74uRdoXz+P7D8aZTuHvVe8ibQiY0qAfz7K2bPeQUValoly/Pv5eTvQHKzcy
2mOY1vHqBA06qFbHeesaGTk+rGwPVqZBTo0GkdL5ZKQefVzwqgINinaVn/5M
pqDnI7bJpyVp0BVprZY90mTEW/xI+5goDVoSzTu7kENG73d1cisJ0KCA644m
bxkpKOvL9s6DFHxe1qXb8QVkxDrRkKzKRoO4gkqE21+TkeH4Tl0DOhpUZyM+
rXuKgrxWnL7br5GQldUPU4kKCpqdThYNmCOh6gNfGO81k9GR4jLJ/HESkj74
sDWqnIx+hC/2/DdAQuU998z5Wslov5GLDHcXCX1/f6LFfD8FMRy6wna6lYQE
uB6MpgtT0M4Ye+eYbyTUqHjLsXEa94vIUO6tJqEvfTt633/G9UnkclD8REJk
n3NS2SEUxPbq8URkGQktcR+5tSxCQZckpctmC0mouH/Q226OjLiOilaezyah
WkkBlmx9CjLw+Nz3PYWEHLZoYRsrBVHo4yS0E0joT6FkvjJg/KXvjKmJJCE3
2vnzuni/cja2U/ohJCR+sSti3yUKSmk5rvafLwkdpLdiNdhNQXRZPz1v3iWh
Nc+Me1+5KCjB5NRjZhcSYh7JOXq8ioIa0rlc8xxI6EpwfMfXJjL6KJTEb2JH
Qtyyk7LdchRETor1pD1PQoKeC9dNwiloqfyT73tTEvJ5JBtpJUpBN25s7HU3
ICGDHsHX1bgeREaW02FtEtKIQYMa3WS04npEmlaNhA5kXes3aiAj0sa5Ky2H
SOhDuvdmyAkKevLTgTP3AAlt7/o2On6OgsYj53cE7SehN+nhB63cKei1yzPv
67tJqNJ5w84umYIe/hOSMREgoXc+Xs3n2snoNK+t8AmChD5fmLj9lZ+C0qJt
dI9wkJCtRqRbeR4FJXceSjnISEIFt1krDQwpaOhRldatzS3wWyuuM9giI24X
xYsPqVugd43KXTZARh3tWo9T+rdgavHqQD83BT3LZv9c17oFsuKCl1lXyej6
v19967VbIOjmlWB2mIKOzgp0qX7YAo4bY0c+tVAQZ0fi87D8LXg5qZnyWIRA
is+U2AeSt0D4JNB/vUFBgW6c/CejtmCS+1+CiQ8FRarfev3Wbwu2WXiKub6n
IFZm50459y2wOK8+u+0/Ctqj7Kv//uoWKFLUNvgPUNDNmQNsepZbcNbiUVa/
IwXR1MUwDZ/aAqE+DXRMnYJcS8akI9W2wEEt94iENAWduZrtqCG/BY86nA2p
uyhIu+JyEWnPFmTyhtDx4XpnciwMNPBtwWm5NdFrbri+rw1Wk1m3QK730cFR
BwoSsYz7e39jEx5/KikpVyZQfaig3xXqJthnmXQyP6OgqtsL45YDm3Bxqu/1
5goF2emFtlq0b4L46pX9+ZEUFJ5lom3XsAmt2+tTVabIqO2L4YE7Hzdhz+Bd
i2ecFPR+Pe1hXPEmsD2IoIZeoKAYzYT9lembcH+cT8MWz3PDi0y+GZyDlzrY
xL2FMJ8VXFGWCd2E94GD2aW4fo8E0gLc72+CVNG7OQP8/vTRYwO1zpvwXINn
2jEb1/cSk+1uu03osL3WHx1FQT9/5VcEn92Etu7y3HsSFNQxbrq2qLsJ3bGG
2pIYP6QSP55bqptguODgzlZKRvJe/03NHtgEyXhnrb9HMB/cEQnwEduEU6Wi
poYeFHRdXfsL7/ZNKGoL6qP6EmjHrbPPytg2gSr8+1j6cQp6ecB/4+LWBli8
Thjvr6cghdZd3TxzG+DKX8D1lZ9A5MZHmk1DG0AvaPfO9yoF/Vj0mInp2ICb
X7ffbfOjoOqlJ9O2TRtgtMtKfs2AgpTefjig/GUDDHVfSQZiPJVqDWTvfLsB
wh8Ur5ng+g/479NkysPrnXzI7p1EwTz2aXU1eQNKPygdPIXXv3t4/eNS9AYY
5Nw/FfaNglYYznlvBOLvS9b8VTWnoOY79jLs9zZAUTH0kNBPCpKP3+wUddqA
t3//Xa9QJBDdkXBtTVv8/KkI4h3GXzzl4L2bZzegf/F7PQXzJZ8Rg0Oq3gaQ
JKIrOxewHpeJsHQc2wDrjKm8HVYUtNv0m56gwgbcklLJDvyA9ytnt/v6vg0I
bBETibKhoJwVa/9PAhvgT5UQjsPP2+eZ2/Bzb4Dz49eNPNaYf06uFvvQb0Ba
rH6i0E6MZ+8Qr8nldSjQNt56600gY+pokN3kOngbMrLsmKcgnbCsnr6+dfjL
lLXjXzkFFVi3elxrXwc5fZebsE5Bgxy5J5a+rgOpO8dCTw/zmYvzkcewDuxq
F0yuYH5ato04Jf1mHTh2ypFqcD2yrnjfbn25DhkXnF3fmxFI8NafJP/kdWjo
uShRhetd8lS/6uiTdXg6YBmr8Anjoyvpv5WgdXg74tRgaUJBtaftJpDXOpAj
r68J1lHQ8BXuz5G31uHuvn1g/gDP8/l79lcur4P4zYXkA3cpqHBXdaOm5Tr0
7HVQrzpGoP3q+yYkDNeBU6vlZgHWt6rcufLtmutw/nvaJyV8vu3XI6U5j6zD
ae0iI5WdBJJy8jjCJrMOL4OTcz98pSATo6OtXKLrQHtx+lxNDl6f7DcnsB3v
J+Bn+5XvFOSRJpIpy7EOb8zlr2zi5y2Z8gv1aNch3F7keHIMBW0USwreXFqD
IebqfaUYnxYcKSPxE2tgunK8VFiHgqJ7uRnr+9bgTvLY9lZjClKhy3Ek/V4D
4dLxwd9OFHRBLoFL/dsa2IXFRH4JpaAdrZIjQZ/XgOP2cw9lzH/E9y/jrW/X
wP6p8cMLT/F8a3znlihYg3o3Dq0czDd7aw3sg9LWwEJ10jrCgoLKf/0oHo1f
A/nTJzm/Y/3z8wsjmUbg/b0U71psoKBN7qMGNQ/X4PbBmHd3BAj0iLkwQvXO
GlBr3xx+jft5haO67OONNaAZfP1G1pZA4sW3QcN2DRQlP21/hvWD62j5ix/m
a3DM4+b+2N8U9C6k1MjOYA0e+R7eUbhBQT7tAbUbGmtwVudJr1wRBV01NuFK
PbwG1TE0xrexHnxu8F3UllkDLkkDzvpLBLocZhu6ILoGjFEGQSs8BCqOtYO8
HWtglPjQVAr3k+y8FXmFaw10Js/uY3tNQY2rn2fFGdaA7+bvlsEOChLWO/l3
ZnUVjmYn5qbvJZDIHWWDz9RVaNQ69DHNmkDD9ywVE4bwtdsxuuVJCrJmuBXh
2rUKA8/8/LUzCBRmZm5wtmUVEuMn45ZPE6hnwjBArX4V7j48JyxcSkFyCUmb
MpX4eaWTBzdUKehe7ssGsTerUHs6y+4f5hdtgYhu4bxVMI96EZffSEGo9Ka8
6ItVYGde9jo7SkE1//yQZPwqZESyXy9rJ5BbNpfv0YhVUK/ZFhR2gkASJleu
G/qtguD25q9p5gQa9R92c/BchcXJ7AdndxHo8CTN83CnVXhPS6SNsBKIskw3
WmK/Cvb1YxdN2AiUNFEn3Wu5Cp6jQ7nfsR/48KTag2K8CppbsozceD+lZakf
T51cBZYjg3d7flBQ0xP25XDVVbh3r/mUfC8FPX7fKPJTYRV68qtU9dIp2O/n
ye+UWIWDzx2o8/h8oxMBojeFV2GzqeFIBV5v9tHxyaptq3D50b//CmIpqPJC
W4gwxyqYyDCcZMJ82nMlns6fbhWG3JnKV7wpSOpXl/T4ygrcavS9VYjx/Gxe
lNeCugKkXVUph17i/d15UvJtaAX8VFVfzJgQ6JOm1ZZW9wpUc6esNksQKN32
03z1rxXopIthy8LzrtxBF6H7dQWuDclyeGP/NZgYWPkLrcDR431nLVhwfS2y
Au3ercDb5PN7NE4RyOnBz47lwhXIeN3GsVRPoIoAm8aYzBXwMLxWN8JNoAMK
xH7F5yvgPLlb7eownp8gO5qO6BWIcD3itQfP1/WIcYPAkBVIDamoE6ZS0Kqn
CbOSzwqEMWe/Dq3BfP3YQGLCfQUEPsSZmuP6V9EnFObcWAHskyOSyiiIcWIp
/JrdCnguCpHvFOLn+U6AjOUKZP+Nql9LpaA4+rPHV41WYKH5leEC9keZVgG7
Gk+uwCULEZojzAS6fapHKu3YChAeVEPaL9hf+f32uH9wBYrZxbc4XTE+Je8s
nZdagaTtivZbmD/+ZTe91BBdgZdJF97fo8F4cV4JkObH+78i0XcQz/N3kmCQ
IM8K6Hw+tMdLAV/XXMsmM6/Arv3jbTpN2M9v8vayby3DzyF30V5NAv3LvSrN
vrgMZVcHPdl3EyjWNS+Ee3IZFjOOiTa6E4ihQHxrx79lEBeyy4lvx/NxzvCy
eOcyGFvUhmVhPDCZBtUrtyyDh9ycz7YSPL8C6qKmDcvAyZz8RAnzj9LNZefb
aBkyZOkTqzDeHsgp5sa8Wwa5yjHJUawHF64/bCgvWoaxpLQw+U4K2tp+p3Eo
axlW5sRtU/dh/lMsy+VLXgYO+jMtp/F6IWH/LhrELsM9o7Gn79Mw/tY0loPD
l0Gm6JX9G0kCnRG9pl/ntwxax6Ke2/Rhf3a18DLbvWXI5kqwDPpMQanaPcdN
by+DbBzLxynM92KfmjrSri3D/VYP65pXFBQsZyU5b70M3ez17ne1CJRge01G
3xzvR0KjYlstBZ0zG+jJPr0MBwe7C7nxvEmd+HyISXsZHC69HHl/EutPyJbC
DdVl2C8RMJbeivF15Vtvm+IyRIYfd3XC+Pca+4/QlFqG4Af/hh4nYv/GeKv7
regysDSXtq1hP9q6kH9QRmAZpjYqWHf/wvxaWbI9j7wMwvK3js6zE8hf7PVD
CdZlKN6bnZU/i/HytNOxmGYZzHlPt5bM4byzx6nl8MoSVAbfTrPC+3tsX/Cq
lroER3beEbLC9dl+vY/GYmQJht7eTL+sRKAYif2/pv8uwXL4qd/G8QQ6oXV8
Pez3ErQ/rqTSY/xlvr0QJvFjCWy9LWM08Hl6h4Y8m2qX4OrfUK42jF+2m6eq
PCqXoMJl3ssU668MieGy6NslWNL/7d0VS6B71x5btBYuQbbYE5olfD/71s2k
0KwliLRq0MzZwvX5Lb3/RPISLNw4EbiKv7f7uO0aKW4JplzsCo9gfk7bn8lZ
FbEETE0fvrznwPPzc9k5NGAJXDVFkl/KEej8OcVlk/tLcHIlOVv8HwXxWrm8
2e22BE+pdbxpfymIXfzqiwXHJUircO6ewPpEevH93Te7JaBdEtbtXaSgOvGr
izlWS6Al8ftnbSDW5xdr5sEmS/DaTSNjGfOH42mLPw76S7Be5LpdBvPP0n+m
rmdOLAHl+y1rXly/ziMNYseUl8BTPNbS0ZRAhTxZK9IKeD27hQWhaQqScSlo
FJFcglmJhcUZPH9v1/pzdoguwfXdD3WZSATqd1AJ4xVYgh+DQznrQ1hPHpc4
8VKW4N6UrIZ7CvanKlrGO9iWQMXzmaos1ucfmqvSInRL0PkR4nvxvNNf7iZJ
ry0Cy1aGQZY8geyOkWpV5hahKUWxZF4H643OvbtG44tQ6vpR3RTXa3RDRPza
wCLIe1V/ekLG/PMutcC/cxEMWVpZzZ8SKCS3m5LxaxHmX7W0rgYSaPIgq2Vt
4yJovT7Btus2gerOW3hNVi2CqVFcxmgSgXJe07tt/7gIs8IG4QcFeNELI331
k28W4bpu4iQNft/71+2uuwWLoBTKNffOgkDcJ79ovspchCQYGffmJVCycIT7
WNIiRH5rp+fB+u1+JcJLPG4RBviT7oViPjo/pinv8GgRVM9Gt8txEmhCKzC7
OHARyv5Kn2jBeqkkXtK67L0IfvL7OzhwvtB1P/hBy2MRZOafCorjeu1XeWAU
77QInBn8e1X24fcLSAljVxYxH++W3IX9xSCnUqiG9SKMXVaLuYb7MfU2STTF
fBH+ku7t+XiGQLDxznbDcBESrTnc+MVxfrkuYXJJZxGC4h3FL73Bfl1B62et
+iIUmu7qfZGJ88OVj6MHjixC5uTO8gdSBNrJti8xRW4RzML4m/9gv+6osOcb
l8Qi6It508ThfnTM6BUH7F4EXkfuQ/mHCXSF59CuDf5F6D7o9evGEs4zBxuW
PSmLMC3cXAMXCZRva+q5zIbrf3Vs+SjW99ZqBisvetzv2P+MX+H6HOPd7KLZ
WIDclgHL9zi/8pOLK8IXFmAPZ5H9Gey3LDyYFHZMLcC/VjZTGV0C/SZ9IuUN
LcBinvUDjSO4/+URl479XYC3pifCTXF/iFZn7vbfC2Cn5Xlzrg3Xa3pG/3bz
AmjaCA4OYz6aPxRM5WpYAMatP+PptASSXujrfP15ASo4eKyl9AgUp6Kpa16+
AKN8SjtWcJ5KdjdY2ipZAKYX0guuWO/7mLlECvIX4OJEyUADXv/G6PVAq8wF
0L5eyU2H+aBvp5o1Z/IC0ObviRbC52t/9upmddwC7CLR5Tjh/Xecdh73frwA
cap9VXnS2D+Yx789GrwA96RtJj4dJ9B6+/3CVZ8FmKMfiNK1JJAsfwRrpecC
eMsXQ+NNPC/WQY8CbuPzJ2koDFsRyCIi69ZphwV4p1h+IwH7NaPt464Cdgug
fDglLP0PzlMNNj/HrRbAYdvvVvMRCgpq1tUF0wUY4B09NI/902l+H954gwWI
EPOKkcXz/5rHd9FZewH0z1L9jhMEouVZ3WOgtgAGyceMYrEfaItp9JM+vACx
4ocsDLgI5FHIPsEttwAsX3Ud1fD96At7ni/tX4BIvcvqmfj7N/ykjft2L8DT
AvJTa+xXBhWtTzYJLAAzm4W2Ee532l9OtUoCf9+paG4giIKKlnVuv+ZYAMmx
Lw77MT6vbSWn5jDiettI0QdgvAWzTtKmbc0DJ1/zYDX2C3yfC+8lL8/D23+S
/oKYT6oeRg4lzczDfEjsXVF8/89PaZ/UsXnwKPtlzONEoCGbQsasgXmIlvi6
8QPri8nm/bLCrnnQVk+3+xJCoPDWNYMPbfNQVii0XWkN89+RG8z1TfOQR9Pl
34rnL/3K1Zz/6uZhacAjp4yC8X+Pzm4KzUPoYAozgwGBtnQomwzl80AWdODk
fUQg0XXfV8Kl8yD2dth5RzqBWJruWB4rmIcDwbymLoYEsg8813Uxax6KgyOi
RbYRSKG18aZfyjxUHXVoDhjE81Qs3/IyYR5kHbsD5q8T6Kwb6/GWKHx/T/Tk
QBf2jwoT3puh83Cfj673DcavkoIEkvafhxbBxmMnhQlUqxTXaH1/HswqCrlf
4jyilG/6O9Z9HtYdGD78wfN6PPlWzjeneWC7stB54hCBNP4OujBdm4ehdynO
vNg/HLgUzq9lMw+qIowH5vF+nkY5+gRazkOEp+oK9QrOK00n/tSbzIOIGatV
MM7zFgmZo5wG83A4nsbxIsZP9EmRMXPtebhg+7qix4hAXaq+KRlq81Bb3KUd
hfGTyCOpOnt4HnQ5nXfV4XnKSxEMPyE/Dz3DEdr/ZHGenkuoTJCcBxaawooZ
zP9v15feT4nNQ2LhmyEGnPcmYr9b6QjNA/2d2t91dBiP4/zdmXzz8I/ndPYK
zluKQ9a09Dzz8OaoLk0h5h9dcKe5wjoP+RG1F0rweiv+3C++0s1D2NVpvVdA
QbKlvRT5jTlo1nBdfIv9uvHupt1Ji3PQq14mq4WvZ5ou0bJQ52C9wZT2Gs7z
55ZLPT1H50D0k7mRFs6D0qb7Ksb650ByK9Z75T6Byn3e5Vt3zUEGy/HxDsz3
9dLRUr/b5sDZOoveCvMDLeWPi/GPOdCMP2ZwDOvNC5u9Wk31c2Ax9Nj4F+4X
F+H5x+DLHDg1d0cZYr54FJA496NiDpZf3PWqw/5WSdK60bRsDixFjZse4Pl9
dKBub1fRHNynVlwyksH58fODo1de4vuW++lPYT3Z4132fTZtDnpSaWVpcN6b
8Zoh/J7j87roeowdJFC3f90sJW4O9kISmU4b803pqu7Lx3Mw4JDObobPT5ps
P60WgvfrcdLACPvhtgWGhj8P52DtRNGWAJ6PQLHCCTevOQja7/dyQYNAhwKy
H1Lc5+ANsRKchvtpxTtT8cZpDp4mn3nZgvHs0hpvd+7aHEwlK8smYH5beHGr
YNNmDm6UdzzuFcLnlQy/m2M1ByJPzj2SssH4ERUuOmM2B6wSWxN7YwjE+vyH
N8lwDqQbpzpU9hNIfH3H61c6c3D0c/a/AxjfX8rvetlpzMGWRHOAXSXeL09K
1naVOYjV/6c0jf24LFuXbfPBObDR+bD+2Y1A1Es898Nk52AsLOXPRdyP9KGb
Yif3z8Gc70DYW+yXnwRuiDGK4n5wHLa8i/2PAGfjq7qdc7B/p4TeENZj7vu3
8sO3zUEojVyJH56/8UOly8bcc5Drrs52Gb9vOXGlkZ91DvKzWVQiMF/SvGCZ
HKSbgzTVLzv0jTFfeupFlW7Mwr6RCdGQfgpaSmx94L80C78SphM9sZ/91S4/
bjYzCwX9AiaimO8/iKmmSozPgl2RhXl5KIEGFSy/0wzOQu3e2u8kzC+0ATEW
nT2zIDQoy/cN+7+eup3i7/7Mgo9vht4sxj/82esY1zILlUqEx2HsVyOclifc
v82C85p+4w6cf7zLU/6eq52F6rSgakusrzHqERzH0Cyg3SfPn8R42VGe93JP
+SxYR1wKu4/znZzMUy+uN7OgWt6rWIj5jMQp8H6tcBa6fbP2tGJ/Evh8XXws
ZxY8+TpY5NKwvsn2bnWkzUJCbEPYKZzvDnWeEWl6Pgs6MSmq188ROI+zulTF
zQJDMB1bAgOBDLg9RCsiZ+G/hh3oMdaDx18aSGWhs/D1SkpMEeYjt0Vj5df+
s5ClPibTh/HHyXEzpdh7FugWalQWsT6MLGtavbozC0f3vIzjPYr93g5b1dLb
szBcctjUDc9r7Y5v7u8dZ0Fc4Un41DXMl5SDzXB5FtZSvj70xHpbFe/n3WA9
Cyay0txtYQRyvohs2yxwPU5Ifcnox/wZKXJ5wGQWPvsV6TrswvwyfK5szmAW
FqtIgr7Yz+Tn++xi1JmF2xdm5kJwPR5M723l15iFoSzHV6WqBBKojUqVU5kF
112qr6OwPrnXSZXoKc0Clw1zk+coBWnGXv5z+cAsxFv2fbLZg/XfNVTDX2IW
nv3dzz2A59NVh7k9XQz342DmvWHsZ6+aeHpWC+H67jNmcrzxfz+3aDGyfRbU
w9qahplwXvxpdJKTMgvNQsqnwrH//jbif0uJYxZmjaLLqXZYX7iC0i8x4Xpn
KZNF///71Ul5jkc0s2Cz+zyNSQmBWuKzvSvWZuBWRYA/7TyBTjkni04szEC1
oqeP3AMCeTKd/yZEnYGXl238o7cTqOnm/RyTsRmgu/ZUQBLPh8HUv2dh/2Yg
jOrsWiuB89L8i4iqnhlIi3R2A8xf2Sf5Czb/zEBl+6POb7jfGaxLtcq/ZmDt
8mB4ID7vS+aH7F7fZ8D0P236RQ+MXxSg97FuBgL8f713x+/3Ski92vo8Ax0l
G57eON9fHrrOpvVxBsLJtNCE66GgoRMe8XYGmJbjc5i/4byux7at/dUMsFzm
U/6Ug+uhIPBEJH8GbuSrNS/iPHVMwETGOWsGFKhXbUsxH7NM0X2oTMX3nddk
abDflg0cvcT9bAY8Vbx71fE8OYjcm7eLnYHMNMGcP/i8933OpH94PANWzBxc
Hng/91c5jvCEzkBxpoytFx8+n6XEsIP/DNzc09p1A/P/+66rXrXeM2Cb8ife
fhb7R689YmKeMxCSx33kDdZT+8Pb6v1dZmDuuX6WC9Zfmx3cpwdv4HqnVJvv
w/P9Xlbzn85VfB7v7YpLuQQqW/puUWQzA9b7Su0z8Lw92Ia6eM/j+sVbGbW5
Yr3aZ6nic3YG9FoVXbkwn2iHR2WPGc1Ar1cFw8YwBVXW1I6Z689AXnOmWhLW
3xG+X0p1WjPwzaqTfBDrxdUPKpaH1WdAkkecz8Lp/3mhwi//6Awcpi28aI3z
WtCoU4LwwRk4kXzyb/s4Bd2oiPNJkJ2BK1cfHK54jP076eM1bokZ8PMzk/TX
J9Avrc+7w8VmYJpGPNQe++fiUEon064ZYG1L6TE9j/XRtMwmaMcMmIv1pV/C
edZLcmmAkcD7uZeo04jrnXZxUy6UcwY+qPcl1tzDeWv3picHywx8PJi1NYH9
PfXZ9RcxdDNw50+SclwUgXyZ2iIFNqkQ2HlOlDuaQPFDJ92ylqlwpXAP7XOc
h37EqwrJzVFhb4b3YR7stxpSX5RXTlLhhOq/y0m+OO+4cfKfHsHXxZcSkTvW
swbT63/7qbA2ERPAE4vxuSB/16WbCi9ZzNz3Y/65tY4Tzh8qSD+QPJ6E9zM+
mCeX0kKFzv3md3NmKOiPRPlvpe9UcOO30SnFfrqm0NroZx0VqvfO87uJ/P/v
BzH+N79QocdEUksf591kU0hm+0QF3xP8xBb2G0+b+G7lv6PCnsyroXsxnoYj
x/YalFDhun3XVck7BKLjfBRDLaDCyccmXoI+BLo7dqA/LocKYbpnL83vJJCm
66l/KulUUPjXcP4Q3v+axULNYBIVdibbCg19wet5mThHJeD9Xtjyz8sn0F62
onqVJ1S40yW9JIf1ey95ZmMsggqIOWtC6hMFFcv8630WTIVnEwfWBjH+uX+Y
J5/yo8Luf4ajebjff2sVGEjeVEjt2RwGfP4cVmnNsjtUeMhadj4J+8Uf7vpS
N1yo0LHLTPgOPt+lTPFRsZtUaK9xPbAdn0/n1MSpv1epcJOWS2VdjEA8LYT/
c1sqfO8/Eyy9RUFvlsXdLC5QITlKYyYez3/l9HfmHeeo0B+as88e458zyOJG
xxkqJMbsmevGfM9ipHE72YAKaqnELBciUI5SlYatDhXOnHiyXJBMIDUOl1Lx
E1RwVppdUGgmkNiS0xRVlQrdf9p0zD/iPNfhVFt+mAqqfsTctmKML6U7V4IU
qLDa1tP8ygHP7x+rNBMZ3F8vaMrC+H76nil9934qTFwk97hjPeB/eMF4ThTX
c/9l2gI8z2rXLzytEaKC49TpW8aimL87v6Yl7qCCWEmDu9NDrG+yterOBBXW
L5NK7/0i0PPE5VRtLtxvScW3cy8JNFD14skuVvx+l0hmAPZTlK8GJ1bp8f3K
X6aT2L8cof3AWrg1Df2rFkfqsd9Q2RbAeH1hGqyu2YVsw/55u5bpKfHxaUju
EdAzx3nOEMqLxnqnYWBeSVUD+684I1O/V+3TICZ2KIodn4+G7ZbT3W/TQLx1
+e5zAevzpTt1Wl+mQS3jG8Uf513Gp/OKvO+nwfzxb+396gTazijENlI4DVlZ
/WJmrAS63v5+5lPGNFTUHelsFMT496pXSUichk+F+auel7AffHsq1jVyGorf
Oqu04nm4YbrtlEngNLj336/wwfmf10HikJLXNOz37l0l43l1k6oV33l7Gpbe
6SmbYX2T63FyY7g6DQ9vOIj+dsb9sSr7MnN+Gjyj2+qTsN4ItE5c6TszDY/B
WGLVDOM55y9Lq8409PlGPVvG8/NUsniz4dg01M6kdOjFEShl8eLUF8VpOPvn
TRgv1rOjqEcSJKbh1q2TdWCP/R+T46VK4Wmo27hR74jx5S70pQdtmwaBsLt2
/f7Yv/lE36tlnwad3uNOW30U9PzIJ6YftNOQeC1D0MeEQHXUD386lqcgNDL+
6iDm8/e7jRNGp6bgQWZf4jHsf1aSauPW/k2B2YvFRYbTBDqHBB5wd06BxSdV
8mvs1/6U26WL/5wCGb/i38G4/uLBvwtO1E3B/AJRt9aC+XncYtrm0xQECWa5
5jFj/+YsdMy/dArScgcs5Vwwn88/upmTOwU/OpDxZcy/z7hO/GhKxd+nr34q
gPOj4H0S50ocvm9Y0DKP16dOHfDaGzEFWwc0Aw5hfs/9/P3zWb8piPrBsxYZ
TCBrGrJCmOcUJBuyPojDecTggvQ95DQFcUeDF3sxnynflhxZsZ8CXbEXyfE4
3wWt3RZXspqCd89Ge+c+U5DL+e5wd+MpaCfbcxTi81fHqg+/OzkFqo8eMN/G
fDb9JJ1rQ3UKUlkrtg1jftXVSDTTUpwCE5dHEgZzFNRgxn05SmIKdP48Z87D
eDlB6/y4R3gKWPd/rJ/A+znE1+4tyzcFJWJapZz4/HEnH/j7c0xBV27pWx28
Py3lT/oddFNw/4KNkbYCxoN58l7F1UmwWp4sNsZ++0furdEo6iRc+8DfnY/1
eort43Xq0CR8SjJi3onxd6ZZc+lM9yTQCOm7R+B8wB43cOz9r0lIGpDYTYO/
R/TKRgl/nYRVpdvnHuJrH1Wlp+FoEvIduX2lMF/QP7uUvfJ2EuwVmMYj8f1h
6emrDoWT0KqRlff/39Ou+ghJ9WTg9wsY1BPx/GXI2b4wfTYJkUJWqva2uJ/x
DZSmKLw+ncjR3AOYPzZVz+sFT8Le873jL/E8M8h3GDZ4T4L+t4/1OphfE8gO
qvpuk7Dt1cIHix8UtFXa2/LDYRLkRUNeR0fg/H28+6K5zSTosJ2Uj8Z5xvJc
YGSf+SSUt4OhRgA+T4p+qdPpSWi8OnC5spxAravBnpuak1Cf5E3Zi/ulBb7S
0cqTsL/pcKg+vi77C7575SeBypNf/APP/88Qa1QpPgnfL1NLL2F/d4iz64vF
rklwZMixd8X+6/N838Ul3klwd90fLIf9Oe9j3f4E9kngfraWmI31TLd7+/pR
ukkw5Gwd2q1CoMSQ9ZXelQlQrL6+M1yNQBfqJMNDqROwrh5sqnuMQELV+zYU
hydAmUhgG8b61Fx4bqu/ewL+e7JnLQDzwWtb4m9M6wS4sX/0VMJ5jOnOKdeT
jROwKDp0vBfPt3CRSMzG5wkgbE9qmON+K53KDX/7fgK4TENcX/rh9f9Vs7sU
T4D5AXqr+zjvePy7aHcgewKSzlXf/YP5Z5AhVG0maQJUtIKcaXCecuSgm3oT
MwHaZ5z5Cdx/pTTOXV5hE2CmfHo5HPO5KtvxXZoPJ6DzZU12I/YvDzLYUrk8
J6BcJF6q6zsFKV39b6zbaQLGru1L/7tOQbp5+zqKLk9Am9H5xwexPq5Wpmn6
nZ+AtY/Znq+wvx0NcPU4ZzIBZQb17E5Y/1VjA4Tl9CYg05BO6sErAh2YaX/M
fnwCKtR9F+nHsX4KPnQZOzQBDEuPk2IzCBR804qvUWYCOj6W/HyP+SadyJcp
2jMBulwSuwWxvm0fEqKP3TkBx6LZyg57YT2qzHC+T5kACsM2dV+sH1eDTHSv
sk5A3cV9rlcxv9OLpnaZ0kxA7H9iaBXr97VwtU7N5XH4SyHOmmG8fou8H3Vo
ehz4LuvxtuJ+CG5TLZIaGgdHs3k3H08C+TO+8BHrHoesIdRmg/mibPPDW6HW
cTh5QlnDCPOXuMTDFIHGcdiS3uu6iPVF5OWhUf4v47Bw+r4+ixbOi+T8vp0f
xmEpLcdAEO+nR9fgksircZBRPtCshfFlLvxRVTxnHKpazVpvY3/9OyukWi5l
HND25Dt0OD+5tVzOUY0bh6+dI6Fl+H3JyI8HTkWMQ+wdug4lzE8Vz25QLviP
Q9DnRz90cH660vc28da9cVDIvLCii/0l7Zscj6Db47CrjcbFvYmC2KXOzadc
Gwd/u9u8qRj/x5ZJtR+sx2Hbu5rZ6zifMYTGHPx9dhxu5amXn8f+4bgW3c4l
g3Go930j643n39/V6cwOrXEQMuUT8cPfv2UavvuYyjj02C3bF2G9Mk0lqV9W
GIfRrdu2bNhPzZ65MP9YYhxO7ydNzdJjPml2nSsXGYfnQm+jtuP+7trMDxrd
Pg70XYwKdJgPZN/Q2fJzj4OzV8xo9V8KEhqpaDJgGgdG1tBBMiPWh7uy2f6b
YzDTd9XMYYCCaowGPlcsjIH/mZhUa1wPBq0eh8WJMXjt2a36Cc9z22aomcK/
MaBVedF3F/ud9K+1X106x+ASXVv8BayP2Tv2+7xpGYOBi/zLBSEYX60OFcsN
YxCgb+CVj+uvTKevqPZ5DNYIw/iK65ivz1yQD3k/Bk9f7rWrxnyF5MMdfhWP
AZnjQuoezDddRzT2iOSMgdHcvfNh2K+Wfz+ncjtlDNrHXlSJYD5VsWoKrYob
g4p8zc49sjivpP022/5oDFwct986hPG473idmXPAGHQwq6rf4SVQqGbBz3qv
MShdHXnJjvPwGiudj5jrGPAKH1GXxnngALksy89hDIz5P1p9wfqjoXttrd9m
DP7MMctMb1BQRG1vnZbFGByKnz/RhfnBscB8MM9oDBRt/IXi8f1nFjIyZJ0x
MHDuoz7HfNvPPTPqpTYG/ftt5ksA46uroGlYCe+3RIRVEp//9FK96FmZMewP
B9L4z2K/cs4rtXbPGGw69s6s4n5HnGUMPSI4BoEhvY1N9Xh/ufXxRcQYSFWW
zB7B57ce/cu1l30MdrmdmizGfqHa+ldeKt0Y9LKX1O04Q6B29qQigbVR2L0m
WH4Y86cH7ehC4uwo0ExNMX6XIhA5NcqKf2wUHDlcBltv4Tx+wmxvct8ofGGN
j4vA+LDt2c2x+79RUP4x/FYK86N4bMLZ3OZRUIz++obqRqB3OnUf5OtH4VR9
jJAqzv/TjFLelTAKw/eiIsmYH2550Zw79W4UGtUrfklgfY36mBzVVTQKo1oo
gy4P+y+KfY9T9ii8mr5wdU8r5veaoGC6lFF4fUzodecE1quJfVefxY1C7U54
NIXxXUMXdU7h0SgkxJcGGcUT6FVXRVpTwCi0KEo+Cw4nUCPz7VXH+6NwsP4C
ieYq7n9vyEs2t1E4ahLGno/3X7kybVfoOAqXghtnd+F8LWBx3sXYbhR0aw6O
H2cnUKRzX/iS5Si0G3VlbWJ+381FXkw9MwohdJKW/BhfR87eiNDTG4Wt/sK0
dpw/2rhjJZaOj0L+j8M1KlhPuUKGebOPjEJYSWbVCcynQvEdjOZyo/CLKjfs
hfGlkvtSg3X/KLSyx+eKYPz96R9/CMKjUHidQekyD85zyx9Z7mwfBb3jBq3O
mC+q9nc9OcA9CjvOie3ywv4gME7NdoJpFNxl7fWcsf8rc/5+IG9rBM7tfvdf
KvY7ZDuLEw5LI2BrFXHZlxbn06gf7lLTI9D9M3bbdpyf+8bVM6lDI0D3Iufr
iXcECnttQHnXMwIHHb991MZ6Mqt19L5P+whQBaQmH9HwotmqAFG9phF4b/a0
9OIu7E8W479sqx2B6ImCOodNCnJd/ZY8+GkEEtYcnBs48P7+lDm9LRsBLZl9
v3djfMQ1hd8NLRyB626jy/d1cD7YoPW8mDUC0/x2+77jPKAxqFB0MHkEaDaG
RVrlCRTA6rHMGTcC5jWMrN54vqhzmgpjESNw9MGKod0SBZ2pCkqvCxiB0Pb2
BWlc723Z+qSc+yOw7+7ejYwRrI9nzkWFuI3AjldNh2kwvnv8+thv3BiBqwz3
Kgew/rimh30wth+BqQyPw2ewvxH4VWB05PwItPF2V2XE4PqYfOUVNR2BwK/i
asoWBKrPjBrkPDUC1pYXBSVwPnmc1py0fmIELGlv1pcTBNqk63wwoTwCpJN8
J2KxXsrr2Gn3KIxAaSLrrxTsX+b1E5VaJEfgmufdSAbM59w3TVnrRUeAQ77g
zcX3BPr+LYMeCYxAXHpX7DLWSyLQr/cDZQRqP7RN/8Z5Zn7H394ythFQdn7m
Y5VNIFGVP6iUbgQeCPaLv8b7iZ9RripdG4aWD1F/EwxwPZ8K1ZTNDUOMtoXc
PjxfRmLvMj6MDwOHB9v9dIyXku0ZaTAwDJ6l8lVC2K+Kelvcq+scBrUzZdw/
cX8jM8xv/fw1DLxGm+H1+DypuYfUuhuHQSRLVikY16u66ez+8aphGP1P5652
EM77u13GViuGYW7XoqeT1f9/T62tZn8zDK/TresfYP5kWquIEy4YhiGbI5Ec
WC+GaTuOKmUOA60PkzMJ88tWksyiQdIwtPLwu+ljPyaY8N3/auwwBHarxJY5
EehwT+Ye/4hhsFBJahf4//9HfDOW8CJgGBK5O17tvobzotfNnej+MMQ3FxYR
mL9iagOd+9yGwf7Ws5JlnLe2Qvtb6G8OA5+1fMp/2O/kBG3SSlweBqYxizu3
8HpTl64fN74wDI7V+8KzMV/oPZhwvGc2DGH/Lu7YxHk80t/lUpbBMBRyDf4p
xvlB1vT8pRatYVj39+EzvEggw/C74jTHhkGGNcNk5C6BbBjYV+WUhiHTKbTm
O9Y7cTLDE3uZYfD51K+aUU1BjJnBcol7h0Fe8m4d6wgFySVnx/0QGoZfz0ff
5eD9ot1Xtpj4hqF7qtalH+fvy8Grkhpcw/DAQAl6pykoVE33/AMmfJ6HqWUV
vRR0d8d9p49bQ/ClXOItqZJAX5261deXhqBYeWN5Gs+HWa8YcYw6BIssPKxm
kxSUWvtf1sORIfjqZpDQiPW89FycUl3vEBiNdi5O4/qcHtvy5/xvCPx/3WHs
MsV+3j62yfznEIip6p5lx/mDuiDQmt6AvzdYPByJ9e2K2Vzr9OchODci2dPz
mkCdidHFx8qHwMq1bEELz9vh9kcakSVDcOzjrsumZAI9yudr6ssbgobnrJHv
ZnC+/k+XWyljCOw/6wn//++LA4SSbsTzIdjDcDp5jp9AOwL5Dv2LGQIikKH+
Be7PU47+HccihmCsuDftF86jXYIzxYkBQ3BVoWqfIfZf1gP8R5bu4+9H3jK8
h/OFzUKH61n3IUC8o5zMCdgvDY2mvrs5BN0HK0tnsR6WXxRI4r8yBIW5N6/V
4fP6mdue9Lk4BL9IV40/3ySQiYx+3+DZIbhidjv3Guaj8TNp4qcNh4CDcZaZ
Fuf/3Y2/zr8/OQR2pQysFZJY/+C7ipj6EGwjSUwkp+G8s9rL9OTwEBQ87jM3
L8V5QXW7N43cEASvXmJQw98zkn3Z6bJ/CNbbk4c9cT3zOSv6B0WGgJVC2+aI
88BigumMJT/up9fhv2dwPgrO6gn6SR6Ce+2v7KP+YD1zdejXZRsC99bAHwmY
78TDd9NV0w0Bc17oEide79uZpn3q64PA8nUbc24K1le6M82f5gdBLiCn5zr2
y9Tdgcqqk4NQ91C7Vg7jlSsy9lrl4CAsGH7LHRfgRQk+nPHHewaBQ+LGzX9Y
P5kzjDRr2wdhhNaEzv4fBR2SWXl96scgtKcFJLzAfkvyvaNgW90g7CsqX9nE
eu3rfInJGg2CwMGQ+nu4P6+b9YrG3g9CicHzyiSMj96PVjyerwehu+H5twv3
MN8aVDox5Q2CdNnLu8HYD/PFpZ98mj4Id82t10Zx/6xdTnRIPMfrnzEucfiI
/RFD6x6IGYTlu/WcnzsJFGJ48ppZxCC0mQGn7BPsD2w1RScDBuFV9X098Sqs
d0PfY4O8B8Fdmf5UFfYrLayFqyIeg+DIWH7gINZH4ci+9kqnQUg6E6K2Devj
U3nNqxeuDsI465NcPErowDRb/oY1Xp8n8t4FdwJJh379m3puEGJ+nPfpx378
/dGF4BPGg3A6UF1QAs/f0GHpvhHdQfDX8xUQLyQQa3b+WKTGICTf6Pn14yWB
0lQa+w4rD8LWP0rsXrz//9rcdQcUBoHqQfvC7C+BPj7gtY6Uws+3W2sbYH3m
Huu0Vt0zCBXfKZ+rXTA//MfyY0JwEOa/98ENzM/PlHtHk7cNQpw5z/8qNPN4
qvI3jqcshZB7Zd9qkrVfaCglkkSEUkiRpSGlEtlKgySVGCVRyhKJ5DKyTcVz
FEWyZElF7tmM0hhGZZff05/n9T3nvJ7zLJ/n/bmvm/pqhkM0/51R4ig5AFZy
amdpB6yH7np3ocUDQIq1vvsWhvkfOxz6ZMEAeAWrW3ORF78Url8fPMVC0iKX
Jn3Ut1q503zdMRZOlZie34n1ffHNaHRwiIXWGKmOqoKf87jrfh7Dwts8fenD
uN8ruhcL+vSxMJyrod2IfjjDdcZiZTcLTet2nJjB+xfjlmZbWDDfMWLagTw4
8BdPv+AFC6kr6qocxznEXyIeyseAhakn79r1kb/+TJH/ZFjNwlHKGhse9SGv
ZflsKQuZEZo6NtjfhlWjAw2FLNRqlsdOY77Z4mdXr95l4bK6Hfcl+v2to7FZ
HhksfL+ZNK6M+3hcIdZW7zreL5Fu8VNPMlSFU+eu4Pcosr++wXnd9ItcdVsc
C5ujMr3ssZ5ai/1Ncn9nwcrkQFA6vo+XJO0aHsZCSrzp6/+hP3qccUDKIZCF
Cd5I4T7krU9jylmr/VkooWq3/YH6UqoWclnAm4U3Yuom2uhnVY5sl/joxsI/
Ou+IaRW8Pm/p+9iJBUFhUfecSC4xGf5R7qYdC+eHN4d4tXEJnyPtXhHbWDiR
INwSg7xRn3LYfP9mFm5M8D7lYTx7WfXRzcYsXOS40j/5taLiw8TKtRjPxHdR
+X85RKa1coqoFgsK0SHdP/9/JVxtVDemzkKj07WEwFccoiXuRE2fAgtiLoE9
e7Den1OlJRs5LFQ8VJk4gv60Pjv0v3JxFuqeCtktPIrz2VaTlSvEQnRQZPpR
5Ofgf2NzUn4wIOsjeqIav6/Meko/boKBX5aQDZ5YP3rtccfwUQb0BIYEPHFf
35x5Y3zsMwNPY6/Nn8HryQc6gT40A6Yb8mz+u8sl8jLC1+3vZWDw/uD0d+TJ
+8Oi5/d0MeDtfEhoyxLsx9Csmw4tDDyuLBbZWsQl3Ervz9m+YCDS8saaxdi/
Kz3+HbIBBgR/5VN7/sX68ERv21Tj+bbeAJOf/y8Mr7m5408GSgfV1szj916u
L1LZ+YCBaIvgd4fQH9Y1a2vvymVglXRxaRfyt1dH1rjzbQYMb+TFlvRxCLm+
dUs9UhnIL5lQ/Yr1/TF8oMA3CeNv/P4k9BaXyOa4LjwZz4CMg1l9EfoT1+rM
vMhoBk5dXt4yh3z7e+rvTZciGJCy6qx1Q/0XH3IITA9iwMWotDtqG5dY5a/e
WXCUAXcp+718fP8xv84zjw8xoMtr7D+Efjpf91xeizue/827EYx6NV4Yb0c7
M7Bi4+GD17H/vK/UFU86MFCVmFdqibzluD9st5QNA69jko9ftEe+Nrt+SsuC
AaUPU8m5z1DvXd7stNzIwHyCp6Mfxn9V7vlhz3UMuJYM2bdjf+0XWzt/Vo+B
vit8NVVf1F/REKk7GgxMkcPvM/JwPp8ovK1Rxfji4+sqcH+1Jir28uUYUGua
mvhdQoa4G7Z03yJpBtqyH8vVPOES4eP2DppiDOin5Qy2JiFfXVw/YS/IQI9z
qKdf408/pNUXOkfDZwG/V1PIlxZPLxpnj9PgOzXW8Bz78bfCSxbNIzTI7C4S
5KajnpE9Fyc+0eBl1uPGwfoPK1VsXUXT4DOjUrb/O4d4+uBc0J5eGlrXSt+q
xHyrxWyzj+ui4UbG7vwH2G8Ph8R9qlpoiJk7l87D88zhoc9DL2igkt6WeSEP
7PC3oFUJGkrHM9LWYz0ThD6fd/6LBvJDu6ckzn/bqV0eSWU0GPlnN13C+brk
7HH/ZRENYSJDeZ8wH5NLnqUvvEeDyTOVtXHIm8sOboDNmTToHCgubUdeNs+I
dYpMo+F74NLVibhP23YL732STMP6yhNWAhJcIkZp2+zMJRoGXbfanrXgEhHC
B9+axtKw/C0/zxfzkRfKKsZE0hBkOJ0sNMUhNC5set0QQsPUqVUzFOqFs8NT
VfETNIzNBwZKyaN/DmVznQ7TUM1wvrQj/+u3Lb9624uGFr/U/7GYz/Uv41QH
3WiYkFbuK7TC+F9M9xnswXjrQh+14/svseUC0TtpyJkRdp/4yiFcu5UTW61o
sNTQlbrhzCUEJE2qVMxpEAibHJVDP37huKFE4AbMn7xhQ3sZ8te0wqtnBjQI
Lpw3bcN+mOzvWCGrS0N5Z+pCty9c4i37Oj9gFQ2R9cqKMvVcwrN6IvG5CvZD
WefJ8ytw396GHkU5Gj4aqejb2KF+Wr5/ErIM88dj9D0I3F9vZJraRWmojJr2
rxrjEkKHjIz1BGnYLCt+Ngv5PLuoQChhjoJFikHxHcgHzXrfjg6NU5DYpVqb
hfnYXm89tWOUAtH32qfbMH+z1iYDDz9ToFGeb2Snj/2XuMZPiqFgX1SEjMgs
h+gQvy0R0kfBS+9MN0VJLnHq4zfp3m4K8k/4DAiLcAnQKAy2aKPAoDejZsNK
1IMlY35FjRR4rzh5WxD93Yvc3CiZZxSIPfwkO9KN/s9q0Vj0Ewp8lxRwbHG/
n4s4VztcToGfY6zh7ldcYvqbntIBHgX/mHUqL8X3a/UbZTTfx/fXVB5XQb9t
IVwZtCmHgr1FDblLkO82LEp7z7tFgUeYa1hRAJc44uboueI6BWyv0TpH9I/e
D9+bpiVSYCMyqNiKelxJ559cGk+BcYpcUL05lwjLCzOIi6ag9YrWhih8/lGg
yrIfERRcif6f+E183oX1tQwPpqArrfrkgkrk080vmr8GUBCcra7T7YT8Etn+
MdCXgpXDb7R3Iz90RD0SGzlIQZJzcr3CX8grGpJXju+jIEsncnQr1vNan3Pq
yG68fyRCdQDnb6RgtvqkHQXKAUIRoXpcYltTlN73bRTckR+ulkV/vqzRZSzC
jIIOa6OJtH70e/2vTRdsoMAq+JP1e+y3hsCinHgDCkBT7HHIXjw/tX2PlC4F
3QFeFfkb8Rrk995aRcFs/nhNz8/fd+6YfVilSoHSD+NbtpjPKSN+SJkcBW/P
Cb92CcbvP6fuYS5NwS6T0flO3CfbGxY1tYlRoCBx1vgZ8pedyoi1pxDWg4xd
J4n90HzsH87YDxK2Hx4sd0Q92A+hWnGTJHCGurw01LjE6X5PkB8j4YK/Zl33
Nw4xUBZwuOQLCVN+3/p8cH8X/hHuZjVAgszix1+TKzjE99oFqf39JBiBwb74
Q1yis6t4Z/g7EkoiDExT8Frpv5uynA4SVj36r3eJJZdYoBShWdJMQkCBhqSD
EPL+ka4KuwYSpO3u9aj91KcmEacvtSTwVDJSr2G/WJTf/zWhmoSI1i2hmZiv
JekG7rplJKSraXaJoz/d0iAy31pEwiGFLzYqlRzCyu8DL+geCSp9+516rmB+
1GTuymbh81K5VapKMsSfspNLa9NJJDp/cy7OU8PlsAu/XSPBLFVzEwf5Ppnt
N5e4QgIdF9VwGv3CxSLepuo4fL7CJz6DI0MklM7xfKJIYGKrktoxvprI5bpS
ESSYrjQ64HiXQ1RKK36uCSKhzfBBwRn015oaiQMBASS0rOy99xX33+RJN2dl
XxLKz589e+9v5DOzle2tB0lIuVq//MVxLiFyhIyP2UdCcl/Ln325uI8Fvcp+
dSJBZHp97T/Ihyb2ceyQHQm2Gstio3H+7x9b7ZRjRcLiBNPC66gnTkrNc67m
JGQZTy56hnoX3LBcXtqEhKted5K2N+P8njEzeW2I9dD11Kob4BBvC8ZT4/Xw
nFel/RL93D3tOh3L1SR0FJ8Seo77PFhAee1CdczHB+OAX1y4xImElPV1Chh/
xDfTx0boPyqLI2K4GL/JHaO9U7j/3JpXb5UgIdVeA/JxnxZXlb8TWkyCelZ8
coMyl1h9oYtoEiDhi/fkSfkeDnF+rQ8oT/DBIcfh4Cb0M/xEkc4HQ3wofKSd
9LAJ59+/5dOGfj5cmyXtW5DPS5aZ+De/4YP3OcJNA/kv193d6WADH44nii3Y
3s4hfgt3kRyv5sOhNeq2GagP7/yEXiU95IPBB9m4q8iv/m23v2hl80HihqOC
tQnmK3Zh38sUPpTqbgmZRf76uuaPRr94Phj/3bpiHfL9pKCpvOgZPuRvfWQ6
g/sgOl+1hXecD0VpaQIhyINO+i22zt58uDSnMSmMfmO/ncXz+b188HJ+uuU4
6uvGXdoZRTZ8SPJetHEOeeaNQEbHPlM+vNRf+lysAud7Y1+7qD4fZOJmLwV+
4BI7sxPra37hg/t4zen0M6jHq8VlguX4YD5vrPIc9w3H9jctHXE+8E6U3tiI
fOC+tWztwHw/OFknZUrjfjK+LHMt52s/nJo12aOD57oJBXaeg/3wo8nonVQt
l1A0VUsP78X7b19XPK0vQ/wfH9+lXw==
         "]], 
        LineBox[CompressedData["
1:eJwBkQJu/SFib1JlAgAAACgAAAACAAAAy0odFrra3r9TnJQbejEVwB1EWDHl
zt6/GrM45nHRFMBqWgTyqsLev2pGXSCuehTA7sW1b3O23r95XekOQPIUwMFP
n9o9qt6/6DRg+RdvFMCs9VuZCp7ev8VmSyi+XBTAb7kIq9mR3r+DiGoDUgwU
wAUn33Wrhd6/5PU6/WZOFMAZl7Eqf3nev2FV1K24ThTA7jnOL1Vt3r/dBtCJ
6xwVwHAVVIQtYd6/vq74zK3CFMB9ejCOCFXevwTvgSJHyhTABlzUfuVI3r9N
mJMx8m4UwGSOQbzEPN6/ymSZt2r1E8AMgCyspjDev1s3yRgBnxPAp3d8gIok
3r9KTi1cE8cUwL9O+p5wGN6/K6rnsJghFMDqg8gGWQzevzzhZtn6rBTAbw5Q
HUQA3r+v9TLOppIUwEInFRUx9N2/ONk44Z3sE8B5EJVTIOjdv8WLHafbyBPA
Rjz01xHc3b+y38zPSBwUwGyZUAcG0N2/b7iPnlwAFcDfY8oU/MPdv6DQErGU
iBTANLWTZfS33b/bK37ggEIUwPt9kl7vq92/It7EH8v9E8BZYFsz7J/dv12C
jqbliBTA6V/oSOuT3b+YAJinYcQTwCtLYZ7sh92/rXfuo255E8CIyWGY8Hvd
v7eNlranARXAiuIYa/Zv3b8QzHdYIfMUwDMxNnv+Y92/8nnWbr0LFMC8Z+PH
CFjdv2lj5bn9GRTAgVBytRVM3b9kERBhZBQUwPpuq3gkQN2/cNRqOg1WFMDx
YfR1NTTdv/jxN25UfxTAhtRnEUko3b+FrX0BwbEUwNfOQIBeHN2/9mciwLzS
E8BDua0mdhDdv/Lh88PvXxTAqVIWYa8F3b9TnJQbejEVwOkNUxU=
         "]], 
        LineBox[CompressedData["
1:eJw9U2lQlHUcXi6FFcJ6/8SCgi3RSFpy5YAsLKwJSFwFQg4uiIIgh6uxcohx
jE44yU1xLKJDEcaxgoBgI+z8fpjBxFG0EAzv+y4CEwWooDC7KjDQ9qUPzzxf
n5N/+nzIGV0OhyPU4j++diNor7meCkJrvt2V6WiGot4bl+WvWOjv/CbcsJJg
6PHenweesvA1Ey/esiI4J3X0ejLNwu7LNW58EzPsYCyfm/zJwomiNd1yD4LH
ore5OP/KQnac9Um9IYLdmkj/CAUL7gdm04qjCHYtK0qutrEQ87fBgJGIYMp4
RmJrPQtS07kIyQ6C9UEJpioZCxnlK4MP7xK0CFTPGhexwGsrsynIJBiLQX8J
r7BgsflVVO13BNWOuWnSNBY8b86+qGgmuBtfjzQmsnBBuS8vHghuek6Gz0ax
UGspdo3YoLAhazXRKpSFqRRrATeAoAHfzjvClwWRQlbyrIbC6v0nj8oELFRV
ehi/95TC7u+HpbQ9C8U+7V31Wv29+jr7rG1Z2JJN8o/5EQx7nlwXw2Ph5ZYf
j8s1Q3a97XCzMQuNfoHrL2mCkoVt29UcbZ4dZQb6UoLJwe0hIjUDHyoC5Kv6
BA/NP4gqXmCgr+CdguH7Wr/emYWPVQyodDTOfl4EJ3bqipyUDIw4VLz4+CGF
vYN97Xl9DAxNbh2fGyM4bvDsiOoBA5lrVeOyZQqjc1o0B1sZuH9quvqOlMID
zePvl9YxELEc7CUeJFjdlMRbqmRAflCaXhNDofonf9vAAgZWJm+JXTUUFnm3
B7TkMqC8UKi+t0jh7SXb1TdTGZh+wyk3Lo2gstYtJD2BAQuF4ZmNc9o+bucP
TkUyYHytpetiKEFeTgIeDWHAzr2lwlzbp8R2IumeDwMp5RXCjgqC3Duu9jYC
Bsxsftw1sN0MacmQUZk9AwL/pLOLeQTf7r0l1rdlQLcp9rxTOMFOjSgmg8eA
b3jxK7cjBCdnxrKXjBnQqGb0uVcIumdWtsTpaPPLWOSE9RAcDP4sdEZNAz46
IYnzJ8gXvtsYuUjD75es1vvlBD//6J+d7BQNpYp4iUGjdt/Jjk/EozSYXnd+
5ENTuLyn8OLjfhr2Kn87LOFTWDVaaxLbQ0PIQh62f0DhSlBr5+JdGqZKu3NM
lRQq5YbD0noadD7N99xvSrDU55eSTRkNDtd7nDbqKHSJ8z2VX0SDwvoPc7mA
YNbZUQ/LqzTkJ/VdUs9T6NCQmtecTsOXe1pjDnEIuiiVGcJkGr74YYJ7uonC
nDCj1NFoGt4qeZ2Vy1DIrq3QiWE0eDuUnRMGExywuzmv9wkNY+mCHUMNBKns
keF1T/r/P/8LgG4MNw==
         "]], 
        LineBox[{{-0.41001972214396826`, -5.298317366548036}, \
{-0.40937712252184, -5.075838103589565}, {-0.4086827310440603, \
-5.1734550864786}, {-0.4079887317783496, -4.991432056280774}, \
{-0.40729521381361655`, -5.113718232322157}, {-0.40660226599143273`, \
-5.259203191291901}, {-0.40590970856671504`, -5.053850667346841}, \
{-0.4052176304458575, -5.056243312873504}, {-0.40452603096588763`, \
-5.212435804803112}, {-0.403834998726546, -5.131899424730552}, \
{-0.4031443544833012, -5.054201678891958}, {-0.4024541869003435, \
-5.14411194215134}, {-0.4017644953201755, -5.242247262713513}, \
{-0.4010753681020095, -5.000635048586455}, {-0.400386626499076, \
-5.127267571632647}, {-0.40016652944996167`, -5.298317366548036}}], 
        LineBox[{{-0.39915302881032083`, -5.298317366548036}, \
{-0.39901065358844834`, -5.203325303085166}, {-0.39832333208515147`, \
-5.025371518845597}, {-0.397636482668247, -5.036633074576259}, \
{-0.3969501046896754, -5.136880955563814}, {-0.39626428609082914`, \
-4.889052833661695}, {-0.3955788489893746, -5.010818417650474}, \
{-0.3948938813901442, -5.17756856313207}, {-0.39420938265039057`, \
-4.9481851544913455`}, {-0.39352544047450655`, -5.159303115604214}, \
{-0.3928418774703672, -5.140712675761626}, {-0.3921587814054443, \
-5.031097371974163}, {-0.39147623980721286`, -4.984839898574876}, \
{-0.3907940756494252, -5.1382310797038455`}, {-0.3902730485454581, \
-5.298317366548036}}], 
        LineBox[{{-0.3900037578533958, -5.298317366548036}, \
{-0.3894311417924463, -5.038065935624581}, {-0.38875045875234576`, \
-5.273496560337357}, {-0.3880701508613091, -4.817757358833875}, \
{-0.3873903054744716, -4.973381661989222}, {-0.3868132999153259, \
-5.298317366548036}}], 
        LineBox[{{-0.38658548991096664`, -5.298317366548036}, \
{-0.3860320873872211, -5.043952877018935}, {-0.38535362568801296`, \
-5.201120833517003}, {-0.38467562398700855`, -5.255381588116801}, \
{-0.3839981691689949, -5.0190105291487495`}, {-0.38332108553642424`, \
-5.012751310511403}, {-0.3826444600359229, -5.036746700016793}, \
{-0.38196829204794225`, -4.87924313679494}, {-0.38129266822587987`, \
-4.952804269428501}, {-0.38061741335040467`, -4.991125636969703}, \
{-0.3799426141364059, -4.917727626601616}, {-0.3792682699693383, \
-4.967509806245181}, {-0.37859446727243, -5.276974100242555}, \
{-0.37855025897836864`, -5.298317366548036}}], 
        LineBox[{{-0.3773653847733505, -5.298317366548036}, \
{-0.37724804854230726`, -5.234167098969413}, {-0.37657560524486594`, \
-5.189294528369744}, {-0.3759035270209255, -4.928369709188706}, \
{-0.37523190018277464`, -4.943473878615325}, {-0.37456072412449454`, \
-5.03046477783649}, {-0.37389008486942527`, -5.254396081652607}, \
{-0.37321980849995895`, -4.957112531564155}, {-0.37254998109998727`, \
-4.94786237552386}, {-0.3718806885225928, -5.007995949708665}, \
{-0.3713327467566615, -5.298317366548036}}], 
        LineBox[{{-0.37096181488194035`, -5.298317366548036}, \
{-0.37054327305104834`, -5.190969943898945}, {-0.36987523547282714`, \
-5.206893986139676}, {-0.369207730094264, -5.062288923574545}, \
{-0.3685405838160627, -5.071562115272871}, {-0.3678738823252961, \
-5.280519358965054}, {-0.36720762502927845`, -4.842685923038159}, \
{-0.36654189733032133`, -4.856151604555818}, {-0.3658765265932777, \
-5.235922689969312}, {-0.3652115982800922, -5.264784508084646}, \
{-0.36488529084179916`, -5.298317366548036}}], 
        LineBox[{{-0.36443653976959745`, -5.298317366548036}, \
{-0.363883152340071, -5.124566452129568}, {-0.3632195477184303, \
-5.245735104842828}, {-0.36255638317586103`, -5.250310794639897}, \
{-0.36189374372408906`, -5.268044595142003}, {-0.36123145753424346`, \
-5.23305811459104}, {-0.3605696096771094, -5.090345503992386}, \
{-0.35990819957285153`, -5.105103873189998}, {-0.3595088036284875, \
-5.298317366548036}}], 
        LineBox[{{-0.35880541990016035`, -5.298317366548036}, \
{-0.3585867756218045, -5.235726143064527}, {-0.357926675252349, \
-5.192310537061682}, {-0.35726709552789476`, -5.105392751534707}, \
{-0.3570232447336291, -5.298317366548036}}], 
        LineBox[{{-0.3555214585564236, -5.298317366548036}, \
{-0.35529070752149156`, -5.286060705206449}, {-0.3552048213947868, \
-5.298317366548036}}], 
        LineBox[{{-0.353678845995094, -5.298317366548036}, \
{-0.35331830278529547`, -5.204758070059427}, {-0.3526616698530934, \
-5.140355739239991}, {-0.3520055525576013, -4.988692421370363}, \
{-0.35134978077249707`, -5.022235170826393}, {-0.3506944387422213, \
-5.241737447395773}, {-0.35036795415431843`, -5.298317366548036}}], 
        LineBox[{{-0.3498966433728553, -5.298317366548036}, \
{-0.34938512622666607`, -5.094729302109323}, {-0.3487310700326, \
-5.135010674774931}, {-0.34807744134843865`, -5.203930560187747}, \
{-0.347424323981117, -5.151698686111942}, {-0.34677154858730375`, \
-5.219341189050169}, {-0.34611919903124394`, -5.223885540048615}, \
{-0.3454672747577096, -5.262386033973706}, {-0.344815859358216, \
-4.890211359920159}, {-0.3441647839336194, -4.681333876620705}, \
{-0.3435141321324354, -5.196505405423853}, {-0.34286398738533647`, \
-4.720279419276539}, {-0.34221418112478497`, -5.124765542215123}, \
{-0.3419283038581687, -5.298317366548036}}], 
        LineBox[{{-0.34135409492566055`, -5.298317366548036}, \
{-0.3409158339779603, -4.839302596632534}, {-0.3402673757611629, \
-4.884222122462565}, {-0.3396192540604129, -5.203886728541666}, \
{-0.33897155214934177`, -4.979573121696786}, {-0.33832435308569936`, \
-5.216881514744276}, {-0.3376774890706439, -5.181383939973773}, \
{-0.33703104321816263`, -5.022754172191943}, {-0.33638501498796586`, \
-5.2434120932945385`}, {-0.33621631042832184`, -5.298317366548036}}], 
        LineBox[{{-0.335274065029528, -5.298317366548036}, \
{-0.33509429257009055`, -5.238376821871993}, {-0.33444951392174715`, \
-4.9857812660601075`}, {-0.33380515074503625`, -5.047117500311255}, \
{-0.3335420956217123, -5.298317366548036}}], 
        LineBox[{{-0.33249706896587167`, -5.298317366548036}, \
{-0.331874631762742, -5.003211191879992}, {-0.33156685299097827`, \
-5.298317366548036}}], 
        LineBox[{{-0.33033168703121707`, -5.298317366548036}, \
{-0.3299478325041446, -4.870135747820809}, {-0.3293063625978334, \
-4.836619051094616}, {-0.3286653867089731, -4.980299056497535}, \
{-0.3282845942217019, -5.298317366548036}}], 
        LineBox[{{-0.32730340021751403`, -5.298317366548036}, \
{-0.32674467254610184`, -4.632479991069215}, {-0.3261053360133644, \
-4.785191605654108}, {-0.32546632543754356`, -4.872495851593134}, \
{-0.32482772293548917`, -5.263975621798021}, {-0.3241896104141659, \
-5.218723631720301}, {-0.32398102997599965`, -5.298317366548036}}], 
        LineBox[{{-0.32327534560922144`, -5.298317366548036}, \
{-0.32291444099107586`, -5.084518041587813}, {-0.3222774655330069, \
-4.805054694198378}, {-0.3216409777724205, -4.946619905398182}, \
{-0.32100481270509507`, -5.004979902089017}, {-0.32036905208648003`, \
-5.1603250873207145`}, {-0.3197336954026369, -5.061694314124709}, \
{-0.3191547858044055, -5.298317366548036}}], 
        LineBox[{{-0.319025769267899, -5.298317366548036}, \
{-0.31846427374565256`, -5.122511281809796}, {-0.31783012574031566`, \
-4.854478695068605}, {-0.3174310225263395, -5.298317366548036}}], 
        LineBox[{{-0.31698269419347935`, -5.298317366548036}, \
{-0.3165631166887025, -4.786321132372309}, {-0.31606746010635556`, \
-5.298317366548036}}], 
        LineBox[{{-0.31574474220394927`, -5.298317366548036}, \
{-0.3152976292197342, -4.956375470877533}, {-0.31475837621201863`, \
-5.298317366548036}}], 
        LineBox[{{-0.3143948120563273, -5.298317366548036}, \
{-0.31403382278039155`, -5.219853872141553}, {-0.3134993530506005, \
-5.298317366548036}}], 
        LineBox[{{-0.3133630959492316, -5.298317366548036}, \
{-0.31277153003994673`, -5.084682017138471}, {-0.31214106212659154`, \
-4.959186709376533}, {-0.31151091006324055`, -5.160321569526073}, \
{-0.3108811548414551, -5.089425411574614}, {-0.31025187724866177`, \
-5.099280241931444}, {-0.3099577340092635, -5.298317366548036}}], 
        LineBox[{{-0.30940684104230937`, -5.298317366548036}, \
{-0.3089943464198682, -4.865799588663667}, {-0.30836617352766066`, \
-4.766816080905805}, {-0.3077384760718143, -5.071860256090629}, \
{-0.3071110913408765, -5.213186574073794}, {-0.30648409997476106`, \
-5.2796397682889475`}, {-0.3058575824110274, -5.077699108629052}, \
{-0.30523137624592867`, -5.212000988423537}, {-0.3046055619696008, \
-4.958684822318291}, {-0.30398013909185134`, -4.494015755496319}, \
{-0.30335518785166304`, -5.101531711213919}, {-0.30305074028818557`, \
-5.298317366548036}}], 
        LineBox[{{-0.3012150732898539, -5.298317366548036}, \
{-0.3008590396432461, -4.89807853693029}, {-0.30023595481391935`, \
-5.242232071064322}, {-0.2996132579775571, -5.084195546034692}, \
{-0.29899102902796887`, -4.713276247024534}, {-0.29836910667975425`, \
-5.035090205384204}, {-0.2977475708785571, -5.215503979427777}, \
{-0.29712642114417015`, -4.833901569691332}, {-0.29650573717448175`, \
-4.781940767581914}, {-0.29588535808694383`, -4.797123271025233}, \
{-0.29546340653097924`, -5.298317366548036}}], 
        LineBox[{{-0.29491913001259634`, -5.298317366548036}, \
{-0.2946457533300461, -5.112581889772385}, {-0.29402660668696257`, \
-4.705272077869029}, {-0.2934077632200533, -4.801218409448378}, \
{-0.2927893024835426, -4.7590458305239896`}, {-0.2921713038347462, \
-4.692188292991289}, {-0.29172411513795976`, -5.298317366548036}}], 
        LineBox[{{-0.29066933846516735`, -5.298317366548036}, \
{-0.29031935707505135`, -5.022868850415636}, {-0.28970288249581716`, \
-4.892542237671947}, {-0.2890867081387889, -4.932006940657151}, \
{-0.2884709132188115, -5.136005347470265}, {-0.2878554972688618, \
-5.039297219410125}, {-0.2872405392605525, -4.858663969687312}, \
{-0.2866258798042207, -5.298084947448538}, {-0.2860115979220686, \
-4.886262742345604}, {-0.2853977724420307, -5.058458865467702}, \
{-0.28478424426969073`, -5.104963203952636}, {-0.2841710922833801, \
-4.653102924591541}, {-0.283558316022063, -4.902880116520632}, \
{-0.2829459941229075, -5.056056681140317}, {-0.28259268732956166`, \
-5.298317366548036}}], 
        LineBox[{{-0.2808902557872799, -5.298317366548036}, \
{-0.2805002123215746, -5.143665596829374}, {-0.27988968067943837`, \
-4.96195574983992}, {-0.27927952155876357`, -5.052697473251985}, \
{-0.27866981326507706`, -5.176952326021949}, {-0.2780603977772203, \
-4.74648574479142}, {-0.27745135345042055`, -4.484847026841345}, \
{-0.27684267983284594`, -4.896703520392129}, {-0.27623445504175836`, \
-5.139852516452463}, {-0.27608880639966926`, -5.298317366548036}}], 
        LineBox[{{-0.2750257737835902, -5.298317366548036}, \
{-0.2750189572023376, -5.292610328154009}, {-0.2744118402973715, \
-5.194123273125413}, {-0.2738050133820808, -5.12259210946279}, \
{-0.2735378116935827, -5.298317366548036}}], 
        LineBox[{{-0.2721758383754921, -5.298317366548036}, \
{-0.27198681718142625`, -4.862580875826672}, {-0.27138145960779586`, \
-5.220585313533064}, {-0.27077646827026486`, -5.138583422492289}, \
{-0.27017184272596173`, -4.9461812686097835`}, {-0.2695676605790309, \
-4.384214909814881}, {-0.269010922062058, -5.298317366548036}}], 
        LineBox[{{-0.2688379489987124, -5.298317366548036}, \
{-0.2683602343877711, -5.004335971873194}, {-0.2677571454617259, \
-4.410551975158234}, {-0.26715434217462763`, -4.930385070743537}, \
{-0.26655190204043355`, -4.6457626002089425`}, {-0.26594982462185124`, \
-4.924069909985225}, {-0.26534818719997055`, -4.835295952126169}, \
{-0.26474683385716874`, -4.948782375590683}, {-0.2641458419228865, \
-4.890962681231265}, {-0.26354521096297745`, -5.293558416644897}, \
{-0.26294501807512577`, -4.929967754040944}, {-0.26234510771815195`, \
-4.857014899311082}, {-0.2617455570378515, -4.975498490788005}, \
{-0.2611464429949226, -5.027449541254587}, {-0.2609496170284911, \
-5.298317366548036}}], 
        LineBox[{{-0.260155247902088, -5.298317366548036}, \
{-0.2599491360496791, -5.007698454407691}, {-0.25935101972728264`, \
-4.6374515079542125`}, {-0.25887194125011787`, -5.298317366548036}}], 
        LineBox[{{-0.258074852379497, -5.298317366548036}, \
{-0.2575588913425385, -4.423243881192712}, {-0.2569622025313442, \
-4.233443083645494}, {-0.25656682265852787`, -5.298317366548036}}], 
        LineBox[{{-0.25548615136134645`, -5.298317366548036}, \
{-0.2551743462843094, -4.913181426065788}, {-0.2550226219089729, \
-5.298317366548036}}], 
        LineBox[{{-0.2541297341984292, -5.298317366548036}, \
{-0.25398424106146156`, -4.933891573606496}, {-0.2533896807635232, \
-4.049908060176462}, {-0.2527954737574898, -3.6294401048943437`}, \
{-0.25231625861186985`, -5.298317366548036}}], 
        LineBox[{{-0.2511150381143798, -5.298317366548036}, \
{-0.25101504491007626`, -4.273096338792829}, {-0.2506274294166978, \
-5.298317366548036}}]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUXHk8VW0QRkgky00UpShCJVQqy0SkLJElLVSSNtLCl5ItSklKCCG7lCWK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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.465062156062651, -5.298317366548025}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.465062156062651, 
      1.5340848993218748`}, {-5.298317366548036, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"E27_30.9849\"", "\"E27_10.0001\"", "\"E27_1.5\"", 
       "\"MilliQ_30.9849\"", "\"MilliQ_10.0001\"", "\"MilliQ_1.5\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.892613780418276*^9, 
   3.8926144542256045`*^9, 3.892696025955387*^9, 3.90203710877135*^9, 
   3.9020419144279413`*^9, 3.9020420016973553`*^9, 3.902042180923932*^9, 
   3.902293482175687*^9, 3.9022966719387836`*^9, 3.9022975312223053`*^9, 
   3.9022975902341137`*^9, 3.902298365560647*^9, 3.90238890053325*^9, 
   3.9023901655772047`*^9, 3.9024805771538935`*^9, 3.903581021021839*^9, 
   3.904017670552292*^9, 3.915272668803846*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"f801d540-36a3-4a08-b81b-cbe34d329fc4"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\DataRaw.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.892613780418276*^9, 
   3.8926144542256045`*^9, 3.892696025955387*^9, 3.90203710877135*^9, 
   3.9020419144279413`*^9, 3.9020420016973553`*^9, 3.902042180923932*^9, 
   3.902293482175687*^9, 3.9022966719387836`*^9, 3.9022975312223053`*^9, 
   3.9022975902341137`*^9, 3.902298365560647*^9, 3.90238890053325*^9, 
   3.9023901655772047`*^9, 3.9024805771538935`*^9, 3.903581021021839*^9, 
   3.904017670552292*^9, 3.915272670519086*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"fbf4c917-7299-480b-b6a0-ad5247d4ae00"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process data", "Subsubsection",
 CellChangeTimes->{{3.8601399392765074`*^9, 3.8601399407209606`*^9}, {
   3.8859798317515917`*^9, 3.885979836205883*^9}, 
   3.8896895105228753`*^9},ExpressionUUID->"c68dbf72-8a8c-4c44-a3ef-\
9c60b7918969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subtract", " ", "backgrounds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataToAnalyze", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<E27_30.9849\>\"", ",", "\"\<MilliQ_30.9849\>\"", ",", "1.0"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<E27_10.0001\>\"", ",", "\"\<MilliQ_10.0001\>\"", ",", "1.0"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"wat", " ", "doen", " ", "de", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "?", " ", "--"}]}], 
         ">", " ", 
         RowBox[{
         "vermenigvuldig", " ", "alle", " ", "intensity", " ", "waardes", " ",
           "met", " ", "4"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{"\"\<E27_1.5\>\"", ",", "\"\<MilliQ_1.5\>\"", ",", "1.0"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotDataSubtracted", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"dataToAnalyze", ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<31 m\>\"", ",", " ", "\"\<10 m\>\"", ",", " ", "\"\<1.5 m\>\""}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "5"}]}], ",", 
           RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataSubtracted.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataSubtracted"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852787913735702*^9, 3.852788081126293*^9}, {
   3.852788124237091*^9, 3.852788221803185*^9}, {3.85278830511749*^9, 
   3.852788314820683*^9}, 3.852788353883409*^9, {3.8527951901832237`*^9, 
   3.852795266554426*^9}, {3.852795790301991*^9, 3.852795801188776*^9}, {
   3.8534052664208517`*^9, 3.853405359776355*^9}, 3.853405404221602*^9, {
   3.853409748113482*^9, 3.8534097682258587`*^9}, 3.853410243789892*^9, {
   3.853410568646674*^9, 3.853410593142272*^9}, {3.8538366552098618`*^9, 
   3.853836688425962*^9}, {3.8544213058580093`*^9, 3.8544213392155523`*^9}, {
   3.854421399974036*^9, 3.854421487835609*^9}, {3.860120980130918*^9, 
   3.8601209825914593`*^9}, {3.8601399447486825`*^9, 3.860139952932967*^9}, {
   3.861763386455724*^9, 3.8617634066433244`*^9}, {3.8617636721585855`*^9, 
   3.8617636911551275`*^9}, 3.861763753820904*^9, {3.861763829259494*^9, 
   3.8617638295877748`*^9}, {3.8617640171756115`*^9, 
   3.8617640685814066`*^9}, {3.861764108969255*^9, 3.8617641095314784`*^9}, {
   3.8617641469152203`*^9, 3.8617641470504246`*^9}, {3.8617642667147017`*^9, 
   3.861764269211673*^9}, {3.861764301965845*^9, 3.8617643679072943`*^9}, {
   3.861764616394006*^9, 3.861764629873103*^9}, {3.8617647074999027`*^9, 
   3.861764707889408*^9}, {3.861767331688716*^9, 3.8617674531915107`*^9}, {
   3.8619430250008717`*^9, 3.8619430252780623`*^9}, 3.885975125250722*^9, {
   3.885975162956421*^9, 3.8859751687928877`*^9}, {3.885975253564953*^9, 
   3.885975292171652*^9}, {3.8859753684038987`*^9, 3.8859753944654756`*^9}, {
   3.8859764080472107`*^9, 3.885976444462107*^9}, {3.8859766205505714`*^9, 
   3.885976701234559*^9}, {3.885977061431158*^9, 3.885977105613533*^9}, {
   3.8859775666625447`*^9, 3.8859775972455435`*^9}, {3.8859793109661627`*^9, 
   3.8859793451759176`*^9}, {3.8859793845178595`*^9, 
   3.8859794119426813`*^9}, {3.8859794524741387`*^9, 3.885979469919469*^9}, {
   3.8859796644128475`*^9, 3.8859797943053474`*^9}, {3.885979909660304*^9, 
   3.885979925707234*^9}, {3.885980058912956*^9, 3.8859800719340887`*^9}, {
   3.8859802956113253`*^9, 3.885980299515154*^9}, {3.8859803946280155`*^9, 
   3.8859804083447933`*^9}, {3.8859805548112154`*^9, 3.885980558763019*^9}, {
   3.8859806884189878`*^9, 3.8859807559686003`*^9}, {3.886061779883998*^9, 
   3.8860618911826696`*^9}, {3.886062270796764*^9, 3.8860623299442167`*^9}, {
   3.88606290416301*^9, 3.88606290438365*^9}, {3.886152279651626*^9, 
   3.8861523073398314`*^9}, {3.8861523706298904`*^9, 
   3.8861523714286704`*^9}, {3.888311253563958*^9, 3.8883112815379667`*^9}, {
   3.8895154757176466`*^9, 3.889515521326418*^9}, 3.889668778999714*^9, {
   3.8896725208785334`*^9, 3.889672555662263*^9}, {3.8896761687511916`*^9, 
   3.8896761875813046`*^9}, {3.8896762430656424`*^9, 3.8896763228575*^9}, {
   3.890203680281665*^9, 3.8902036879233007`*^9}, {3.890203721626855*^9, 
   3.8902037336503353`*^9}, {3.890203765562109*^9, 3.890203784550714*^9}, {
   3.890216653073305*^9, 3.89021672873991*^9}, {3.8902167682576685`*^9, 
   3.890216804044831*^9}, {3.89021744880861*^9, 3.890217482686234*^9}, {
   3.8902177558058324`*^9, 3.890217761492506*^9}, {3.8909816465407667`*^9, 
   3.890981653810565*^9}, {3.8909826260035453`*^9, 3.89098264917115*^9}, {
   3.890982718701262*^9, 3.890982720715917*^9}, {3.8914972861846867`*^9, 
   3.8914972916516743`*^9}, {3.89149732190543*^9, 3.891497325080738*^9}, {
   3.8914973608592787`*^9, 3.891497387301942*^9}, {3.8914981362303147`*^9, 
   3.8914982511085134`*^9}, {3.891498313222266*^9, 3.8914983218384113`*^9}, {
   3.891498500855095*^9, 3.891498501109005*^9}, {3.902293403750101*^9, 
   3.9022934262445173`*^9}, 3.902293761601369*^9, 3.9022937955237455`*^9, {
   3.9022959828127484`*^9, 3.902295995749625*^9}, {3.9022961816469045`*^9, 
   3.902296183148714*^9}, {3.902296613680443*^9, 3.902296659428668*^9}, {
   3.9022974286181245`*^9, 3.902297523060432*^9}, {3.9022975813047495`*^9, 
   3.9022975816086473`*^9}, {3.902298249355943*^9, 3.9022983180114884`*^9}, {
   3.9022983493393493`*^9, 3.902298349806218*^9}, {3.9023034979806356`*^9, 
   3.902303498185611*^9}, {3.902388924727709*^9, 3.9023890530627127`*^9}, {
   3.902390186183451*^9, 3.9023902079772778`*^9}, {3.9023902461302137`*^9, 
   3.902390300330817*^9}, {3.902480589247505*^9, 3.9024806000084686`*^9}, {
   3.9040185506035194`*^9, 3.904018550843091*^9}},
 CellLabel->
  "In[1364]:=",ExpressionUUID->"5cc1674a-6b09-4f41-a48c-1487561a3f0f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c41f8Xv3u77rAuUqKyx5ekfSptFDKiLZsiSSkZJSlUKklSklIhZYTK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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k4VV8bvdc8z2OalUxJSD9Re1OEIkqGEiKkZCZFkVmSSkIRCWVMiUJ6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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lt8btnf2eL1vkmwNobLdEikjUkalQSoRGsooIxpKhcjIzMjXKqJF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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.465012383332263, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.465012383332263, 
      1.532902668694916}, {-11.512925464970229`, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"31 m\"", "\"10 m\"", "\"1.5 m\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, 3.892613683076393*^9, 3.8926137878875275`*^9, 
   3.892614320742548*^9, 3.8926144631009235`*^9, 3.892696050709646*^9, 
   3.9020371141886473`*^9, 3.9020422033450956`*^9, {3.902293414600558*^9, 
   3.902293439245744*^9}, 3.9022934916413555`*^9, 3.902293767397822*^9, 
   3.9022938022186637`*^9, {3.9022959884699297`*^9, 3.902296000596073*^9}, 
   3.9022961900584164`*^9, 3.9022966191801615`*^9, {3.902296649643454*^9, 
   3.902296681008383*^9}, {3.9022974388816366`*^9, 3.902297539721385*^9}, 
   3.9022976000269976`*^9, {3.9022982677659383`*^9, 3.9022983044354506`*^9}, {
   3.9022983547556195`*^9, 3.902298374198013*^9}, 3.902303513746819*^9, 
   3.902388929531068*^9, {3.9023890355533333`*^9, 3.902389056035737*^9}, {
   3.90239018079618*^9, 3.9023902120740943`*^9}, 3.9023902619701233`*^9, 
   3.902390303654978*^9, 3.9024806035287466`*^9, 3.9035810383874116`*^9, 
   3.904017680131708*^9, 3.904018555135308*^9, 3.9041112829012375`*^9, 
   3.9047041260102067`*^9, 3.907745092225565*^9, 3.913800849255872*^9, 
   3.915272677527233*^9, 3.9155254760459347`*^9, 3.9187273678270454`*^9, 
   3.918727422895357*^9},
 CellLabel->
  "Out[1365]=",ExpressionUUID->"c4ed2da8-f793-4de0-870a-4764da169c53"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\DataSubtracted.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, 3.892613683076393*^9, 3.8926137878875275`*^9, 
   3.892614320742548*^9, 3.8926144631009235`*^9, 3.892696050709646*^9, 
   3.9020371141886473`*^9, 3.9020422033450956`*^9, {3.902293414600558*^9, 
   3.902293439245744*^9}, 3.9022934916413555`*^9, 3.902293767397822*^9, 
   3.9022938022186637`*^9, {3.9022959884699297`*^9, 3.902296000596073*^9}, 
   3.9022961900584164`*^9, 3.9022966191801615`*^9, {3.902296649643454*^9, 
   3.902296681008383*^9}, {3.9022974388816366`*^9, 3.902297539721385*^9}, 
   3.9022976000269976`*^9, {3.9022982677659383`*^9, 3.9022983044354506`*^9}, {
   3.9022983547556195`*^9, 3.902298374198013*^9}, 3.902303513746819*^9, 
   3.902388929531068*^9, {3.9023890355533333`*^9, 3.902389056035737*^9}, {
   3.90239018079618*^9, 3.9023902120740943`*^9}, 3.9023902619701233`*^9, 
   3.902390303654978*^9, 3.9024806035287466`*^9, 3.9035810383874116`*^9, 
   3.904017680131708*^9, 3.904018555135308*^9, 3.9041112829012375`*^9, 
   3.9047041260102067`*^9, 3.907745092225565*^9, 3.913800849255872*^9, 
   3.915272677527233*^9, 3.9155254760459347`*^9, 3.9187273678270454`*^9, 
   3.9187274246744833`*^9},
 CellLabel->
  "Out[1366]=",ExpressionUUID->"4fca83ae-e4ee-48ef-a38e-9212365d6baf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Merge", " ", 
    RowBox[{"(", "relevant", ")"}], " ", "patterns"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Usually", " ", "we", " ", "only", " ", "merge", " ", "pattern", " ", "2",
      " ", "and", " ", "3"}], ",", " ", 
    RowBox[{
    "but", " ", "sometimes", " ", "we", " ", "also", " ", "use", " ", "1", 
     " ", "when", " ", "2", " ", "contains", " ", "a", " ", "weird", " ", 
     "kink", " ", "or", " ", "noise", " ", "etc"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "2", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "1", " ", "and", " ", "2"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.005", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.02", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], "&"}]}], "]"}]}], 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Sequential", " ", "merging", " ", "of", " ", "first", " ", "pattern", 
     " ", "1"}], " ", "+", " ", 
    RowBox[{"2", " ", "and", " ", "then", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}], " ", "+", " ", "3"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamerged1", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.008", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.4"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.005", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.02", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.02", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.8"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"datamerged1", ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.03", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.4"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.03", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", " ", "=", " ", 
     RowBox[{"datamerged", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", "2.0"}]}], "}"}]}], "}"}]}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Normalize", " ", "SAXS", " ", "data", " ", "by", " ", "capillary", " ", 
      "thickness", 
      RowBox[{"(", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"unit", " ", "I", 
          RowBox[{"(", "q", ")"}], " ", "in", " ", "mm"}], "-", "1"}], "]"}], 
       ")"}]}], " ", "-", " ", 
     RowBox[{
     "does", " ", "not", " ", "affect", " ", "fit", " ", "results"}]}], 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{"datamerged1", ",", "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
       " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
       "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataMerged", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamerged", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMerged.pdf\>\""}], "}"}], "]"}], ",", "plotDataMerged"}], 
    " ", "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Bin", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinned", "=", 
     RowBox[{"binData", "[", 
      RowBox[{"datamerged", ",", "0.05"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"default", ":", " ", "0.05"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
         "}"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinned.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataBinned"}], " ", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "merged", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamerged", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "merged", " ", "and", " ", "binned", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged and binned.csv\>\""}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "exportlist"}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.854423668689094*^9, 3.854423681960602*^9}, {
   3.8601210812169123`*^9, 3.8601211773702602`*^9}, {3.860121220142*^9, 
   3.860121220876803*^9}, {3.860121492525386*^9, 3.8601215079101877`*^9}, {
   3.860121718604267*^9, 3.8601217659879427`*^9}, {3.860121814486486*^9, 
   3.860121940090294*^9}, {3.860121990307417*^9, 3.860122029773138*^9}, {
   3.86012227550008*^9, 3.860122412026474*^9}, {3.860123590194846*^9, 
   3.8601236144362907`*^9}, 3.8601236508219957`*^9, {3.860139958454444*^9, 
   3.8601400142502003`*^9}, {3.8601409041122975`*^9, 
   3.8601409737863803`*^9}, {3.860141247131112*^9, 3.8601412486662936`*^9}, 
   3.860141363728487*^9, {3.861764464753133*^9, 3.8617644999883156`*^9}, {
   3.8617650690038815`*^9, 3.861765107161731*^9}, {3.8617654080879517`*^9, 
   3.8617654464808097`*^9}, {3.8617667857822647`*^9, 3.861766817572381*^9}, {
   3.861767478263466*^9, 3.8617674824174633`*^9}, {3.8617675156782837`*^9, 
   3.8617675385223627`*^9}, {3.861767600750394*^9, 3.8617678801582737`*^9}, {
   3.861768004639906*^9, 3.861768004842128*^9}, {3.8617680471976347`*^9, 
   3.8617680542883253`*^9}, 3.8617682512241673`*^9, {3.8619408859545107`*^9, 
   3.8619408879723635`*^9}, 3.8619500601432023`*^9, {3.8859755937637935`*^9, 
   3.8859756289602833`*^9}, {3.8859767824682684`*^9, 
   3.8859768072202587`*^9}, {3.885976912247283*^9, 3.885976915489427*^9}, {
   3.885977184321333*^9, 3.8859771875417037`*^9}, {3.8859772431391516`*^9, 
   3.8859772459190493`*^9}, {3.8859776946505795`*^9, 3.885977697414628*^9}, {
   3.885977754450777*^9, 3.8859777568929634`*^9}, {3.8859804425147095`*^9, 
   3.8859804438235583`*^9}, 3.8859804753994827`*^9, {3.8859807731997614`*^9, 
   3.885980782688805*^9}, 3.8860629984459877`*^9, {3.886063060466019*^9, 
   3.8860631273919067`*^9}, {3.886071125028043*^9, 3.8860711896934166`*^9}, {
   3.8860714254613867`*^9, 3.8860714550837*^9}, {3.8895154616447597`*^9, 
   3.8895154658794193`*^9}, {3.8896724114246473`*^9, 3.889672412507053*^9}, {
   3.889672471225835*^9, 3.8896725071452694`*^9}, {3.889674589350315*^9, 
   3.889674633174043*^9}, {3.889674670910601*^9, 3.889674765787591*^9}, {
   3.8896748131059356`*^9, 3.889674848516157*^9}, {3.8896748918371353`*^9, 
   3.8896749698660383`*^9}, {3.8896759808235216`*^9, 
   3.8896760211101522`*^9}, {3.8896760618397036`*^9, 3.889676134804789*^9}, {
   3.8896766120107994`*^9, 3.8896766124494815`*^9}, {3.889676755304323*^9, 
   3.889676755581999*^9}, {3.8902038545244083`*^9, 3.890203901273981*^9}, {
   3.890205930477414*^9, 3.8902059314228735`*^9}, {3.8902102550185256`*^9, 
   3.890210255342898*^9}, 3.8902167482021494`*^9, {3.8902168284956217`*^9, 
   3.89021682871568*^9}, {3.890216868216955*^9, 3.8902168763206763`*^9}, {
   3.8902172079856234`*^9, 3.8902172082346754`*^9}, {3.890981726002406*^9, 
   3.890981786213588*^9}, {3.8909822356137176`*^9, 3.8909822357713594`*^9}, {
   3.8914985305692663`*^9, 3.8914985803250184`*^9}, {3.892613758123871*^9, 
   3.892613758289031*^9}, {3.892614278506711*^9, 3.892614293126571*^9}, {
   3.892614333217201*^9, 3.892614379152516*^9}, {3.9022938086532*^9, 
   3.902293808923072*^9}, {3.90238918370833*^9, 3.902389183938918*^9}, {
   3.902389396889367*^9, 3.9023894106453295`*^9}, {3.9023903237034793`*^9, 
   3.902390344587886*^9}, {3.902391695800418*^9, 3.90239169591302*^9}, {
   3.902391729268525*^9, 3.902391799324919*^9}, {3.90239183187342*^9, 
   3.9023918514555707`*^9}, {3.9023928347335753`*^9, 
   3.9023928377152085`*^9}, {3.9024806247028327`*^9, 
   3.9024807782051024`*^9}, {3.9024817324574866`*^9, 3.902481752225964*^9}, 
   3.9024821434449773`*^9, {3.902482587982024*^9, 3.902482588359666*^9}, {
   3.903581604453705*^9, 3.9035816046859217`*^9}, {3.9035848683132305`*^9, 
   3.903584868907031*^9}, {3.9040177688615117`*^9, 3.9040177921529236`*^9}, 
   3.904017825093134*^9, {3.9040182560440655`*^9, 3.904018273814806*^9}, {
   3.904018535856817*^9, 3.9040185361135373`*^9}, {3.9040193399836216`*^9, 
   3.9040193401064053`*^9}, {3.904019574801774*^9, 3.9040195774296246`*^9}, {
   3.904019797366924*^9, 3.9040198047981606`*^9}, {3.9040198861379232`*^9, 
   3.904019886521549*^9}, 3.904031593787795*^9, {3.918727396258704*^9, 
   3.918727403308261*^9}},
 CellLabel->
  "In[1367]:=",ExpressionUUID->"5b3c3b75-f6f9-43b4-ae93-bf843c1633be"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.003666666666666667], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwUl3k4lW8Tx8/m7PuxnIOUUIlIIq2mkrQQiUQLKXsiS6VkKWnVL0oqiaQk
pFChMqKUnUhChRJpIUVI3uf961yfa+aeZ+Y73/u+rqO+fff6nRQSiRTKIZH+
/ztzVnBh0zIJykI+hkyVKEN53ecfc2ZL8IMsebWZUBmcHG94f5okQWVl7ixj
jjJY1IzofeFIUGi+ZxaLqwxRx9u2LxkVY+/QmdzvAmV4emmV3fseMbZd71an
Evm7wxp2VzSLUTrjyPyvDGWYvhVsxp+L8YVPZqcuwZXskJSg+2LcZESZjmRl
0FhcqGNwQ4wfLAy2Df6Twd93hU2z4sUY2hlBr5qQwUqQJHkeFaNfOh1VRmWg
PZJ/qTNYjNNOxBezhmTATz05HO8uxvE2l4zQXzIoaJv++4iDGPfojJZv/S2D
E+viP2esEmPqYYOsJQQ/vrHYiLFQjLEa1tEuAzI4c+W1XYKuGOc12Nh7fpXB
sr1B9ZvVxOgxIh/xoVcGTluum9oKxWhwdTTkBsHxEb0QQhGjiCWZfKFbBoYH
U87V/RLh5k9LeN0dMnioNXdow2cRzrIUzdf/IAON4/qG9LcirM+9fzGnRQbT
p37T7KoSYUrb+W8ezTIwf//nzpdiEeYxtmXvJzgsP6JUJVeEjr2PAo41ykAo
fOUQdEOElNzfff0E6wS/3jN0UYS6r971ZtbLILYmcVLSaRGaug3GLa2WQWn+
913eESKsfBprefylDNCtK3xLkAgtzAw3j5TLgFsSeiDAU4QXOrIPvy6TQcWE
1YnMLSIcWN8De0tkoBuxrY2xXoSCVX0nThYT863qzj9iLsJr/nSmxSMZ/FS0
t526UIRub/Xjxgpk8Cdx/t/3+iI0vM+rmndfBuGrp/x7pCnC8A17vJtzZXD7
r1PmQ5kIrRZUD5zPJvY37+m2Br4IV5HaD4bfloHFbb9gFk2EdzlLnxnekoHX
m3O2W0aEuLFAMe8NwdXnjLdVfxcibftCx6brMlCwkaNv+ijElK3+l6lXZaD5
dXrBRIsQRybKnuQnyeD3D/53rBXiJzLD+fcFGdwRr1JLfCbEnFfrd90+JwP/
LCj9r0iIIatXfW+OkQHZ5LBb0l0hVu3039wVK4Ng7e5jZTeFqLubbVt4SgYz
pnbepyQJcYPt57AfR2UQd9w+0OGcEJXvz9+Yd0QGCyleG56dEOKsecqbfCMI
v0x26bWIECJlJHBvHsH5LS3YuVeISY/Sv/iHEPqW+0fG+goxnhJ6IzdYBkvv
+ZRs3CnEbZ8zJD/2yGBxeITKnM1C9HUN85/wk8F8N6qBuq0Qbx9pa/rnSZwP
qLiuuVqIpw4bF8ftkMG8yZNUFy0VInvX44r/dsrgbsOlJe4mQlzftTNubJsM
DBym30/TF+Ko6H5a7UYZ3J/VrDc8TYhrapnW8x2JeW612TupCXGoz/Vosq0M
LvYEvatXEOJ17Wqpg40MIg+07nXkCXH+yAKqhqUMtCr0m3/RhMhnVDvtXSUD
u5XvdiwdEWBn5Zeh+pXE/ejGyKIeAQa/DohWXyaDaA3egY1vBPg1aNosbyD8
slGzTP6FAJPvTtp8yEQGObvTm38+EKBKu+PbR0YyEHW4zBm4KcDraotW/zMg
9p0+bYMgQYBTrQ54lusQ/p73tHjtMQHGe5d4TWjLoNb+3Wj6PgF67vsmu6sl
gxttX09reAqQ+SHKx3SSDNrNxLRHmwSold5nlqEiA1uBqM9/tQAdM1q7DJRl
MOm0/m+puQDbGN2N5otl8KvL6JXZQgEerRmbMllRBqH+Zuvm6gqwvatKc7JA
BrN/6vaYTiL6zU+/Fs+SgY2V93CUkgBjD8ZOHteTwRvDAUt3vgCdKyjqt6ky
kBNO8DIm+Jg/JWXpvwkpvD9pVsYY4GPC9FUHv41JIa/7vdbfXj7usT5baz9F
BjsH6vjhnXx8t9MjOm1YCm/8n50WNxJs8+Umf1AKT23Mu5484+O5pJB1379L
YXm5bt/ux3zcWD8tNkskg6YEn9wjD/iYCeSvK3qkYAgm111v8fFAQWZd2Gcp
dLdEbnG6zMf2obTsox+k8F+s3IHXZ4n8b45r/qPIICHz5zHv03wcLqtQ6W+V
QsuS7/VxYXy8Hi5fv7JFCp6W/3165c/HK+pz9gc2SoHiQ7qv5c5HT/7Txjs/
pbBmRuIenR183GHatCyjRgqRe/ZoX7LnY9mptlUTz6QQD/RHk1fxMWQeLk14
KgWbgEjhhsV8nGU7GSo6pTAjtqG9aCEfbX+gtipKgaVRt9xXj49bfjTe21Qo
hcD/vK8bq/Nx86llRz/kSuHZiOiegzwfcx9npT5qkIJm7YEH8gSbT9LNzsmS
wuIfJsZMBh+rFR+cTL8lBZqOYatwlIfLD+ZrN16XQtri1dv1vvGQ+8G9fPCq
FJbUHpqu85WHS4N5SbtKpLBo4vox5w88nMfBeaaXpJCy/Bb35iseso0/JlXG
S2HfyGAWuZyHh6/9WfHoPylcPUuOKi3jYbX4/UqtHCmoRtvM8ivk4ZW/kZGz
o6Wg73p/7c8son4VdU5ehBQ+LxA9i07h4en1fhVmoVIoyDu+UjmJh8tM0787
JklhysrvvrPP87CmwJZaESyFwkOb5L4e46FVgY693R4peH9PsSo8yMPUKfVP
lvhIQbRoMHDGPh7uMHDXKTslhZguVfFlPx7+vv/ISJeIDxdPlsbsIDi2NcPA
VQojYyPacQ483JaVWv1mqxQOzu+z/7yeqAdavIoQKfDtfogy1vIwsitaJ2aT
FE5Mn3O5AXi4QaqcXGtP+Hmg/SzXiId9Tx7Vl62VQvXhiURrPR7uPGZu/8VD
CkLSz6cbtYl5Gv4WZa2QQtvitX9zJ/Hwv0yfetZiKfjqXeeqi3k4t/RPmtBY
ChpW7Wu2snm4x2Hu3kai/jzm0dIkOg9Dvmho+hLxikHLAd0xLt5tXXIvRF8K
0T4a7pU/uJjVekeNM0MKlcO62ezPXPT2nvc7eDkxX8mvof0fuZiT0Xa3booU
Xj3cE2DSwsU+PXJaogrhz9XcHHoNF0Xaw3MOKBD7eugdaF3GxUU3p511nC2F
jZFfwj8+5eKA7av72/hSWLf3a2H9Ay4aKBxt/MmUwimXVMOaTC6ueT2p4ASF
6GfBl70zr3Ex8Uvu9nZVKdyssCppSeGiLKp17NVfJehrfrPgVzwXza/19Gf8
UYInWQ17J53i4o7oizozBpXArs/P2i6Ci6Ob7+uu/KoEb0caWuPCuWhCPbyn
hfgefcmxK5eDuThL85e3+icl8OScMOn35uL4o61X3NqVYGp6w8/1LlzMvqlX
m/OGOG/3eSh6GxdjBtax+n8pQXSJ98NSey7OlF9fdLFeCfRu1jotW8vFDyuH
rXwqlWD499OHNUu5mFl7ISitTAnO9oTvoZhy0XD84GtxhxIsPXfhtsc8Ljrq
LMx+81gJuM3aIuEsLuarLrdb+UAJfAran5dN5eJh+r205jtKoBF1TjyhxsUF
U/cxrIj677QSM45Kuah8rYesmKEEjdZ1l+z4XLzWv85k7JoSiDV3BhvQiH2u
WMbwSlQCyfvTTfsnOHhTvpiVdF8J1hc+VVUe5aDVzOPrW88pQdaXyl2Cfg4K
aatKTsUowbau1lWibg6qJmBe2nElmNA82OP7gYPP7Awt2lKUwO9V6dnJbRys
zZqRdOqIElRdezFtQQMHo/d+OqgVqgReD5O/OL/g4Lequ6/GgpXgVz0kvi3h
YPEz375Np5RAoca/OO4JB8dN3ly67KMEKvWvwhryONgQZrIgzk0J/oWUqU26
zcH4dOsZs52VwGzO/MMFqRz0nZ1wN4Cot8j4xt6AFOL8p8KsCUfiezYrfZsu
cPBt+6UTTFslmGvd2r0shoP9Bhr8x9ZKMC8mwph5lIMX7M/BM6KeEWvkWdER
Dm4Iunq/fIUSDNUk9Jse4OALw/J5mosJPVPFa2v9OXgs+4jJxXlKYBhscrnU
g4MdXb88ZauVwHuf6hNPgjXbfn4/Y6AE5oEvdAXbOHhPofE8TleC0xaHDxXb
cdA/9P2am5pK4HtKfClkLQdTz/9556pG+GPz3cieNUT/9Ubreg2VYGBqnBss
52D2cNh7K2UlYGXsrRQu4OBo56KWizwl+O/n0Zy+2RzcEnnsURyd8MMHf9VA
fQ56VAu8h1SVgBTxdrxuOgdNw5d0byYpQYpi+2VU42DBajfB+hFFoCxfFVCo
wMFuVd45lX5F+KtpFOIq4eCqKcnLghlK4D8+fdcTLgf5pWGem3sUYb157Z4q
KgfzXkYzqz4pgqDuw66Po2y8Px7u6t2mCMn6c/7kDrMR3YMt5xP1gu9YWNB/
sjHj/ZGk+GZFcJAs+mrQy8bZQf+2WdUqggHVxMz9Axu3leUdf1+uCGre+3iu
bWyse0WNMGhRhExN0sIbzWyM+xGyKOeRIrRFXyn6XsPGA52SCNEDRRjZv+Uu
PGejveHU6x73FGHSCHWKbwkb5SJLT9aWKELI1jpG4mM2fslISKpOV4StMS8y
SPlsPBQk/BWdoghHFm866pvJRsfNFYdyEhQhe4Osp+EGGw0Yy3lbMxSha2fT
0U+pbNy9Y8j64llFiHxYk7DzMhvn5Ddu/RStCJxz8re+x7KxNVRyJi1MEWxS
3/yNOcVGPTftB5NjFaGRlHs9/AQb/U7pty8LVQSjewP7VCLZmOhnd74oUBGm
8mwlxfvZKHp9MfrILkVgV0uMk/ewcXXDzbUPQxShxDDOxdufjUUupp8u7VQE
OcWbNlM82UgKVl8a6qQIkuii+nZnNmZ2O7nXbVSEou3Tw2mb2Pj8O4cyyVUR
XDbOrUt1YKN/X9Tz9daKsCvg9sI91mx8tDF05+I1ivCD3k9ZZcFG8uK3tfuX
KkLAdTmFGcDGKTlnKfQFijAaJswtMGUje2BukjyRP9dfw0Vgwsb/QN9YzlAR
ptvlvv6nz0amXtKKM9qKINW32Tk0nY22jvDi3VRFuHqm68fjaWxM/uf9bTOR
/4Jb8ff3ZDaW/3bSj1JVhG43ldPjSmxMmIW2xiJFaHfeQ+cJ2ei2a3WeO1sR
op89myvgs7GPZ1MTpaIIG7g6mzSZbKQ5npjyiq4IVjm1QctJbPw248/X1eMK
8EYitfT6w8L21eUZfsMKAL60gtu/WXgofvefxVRFmFbVU5vQz0Jqn/zCB1+J
+H+xnTU9RHxLz+2oTwrwp639DLeDhdb+/6U++6AAysc+lZ5tZ+H8bpuA9i8K
0LZg5yObFhbOXXL6/vEWBegqL9iUVM9CnVM3a2LqFYA/I37Tz5cs3BhlY1X5
XAEcT9scLX7GwpZL38dWNipAQXd7luVTor7dP8MZJQrw/m2iRU4hC8szu1R/
FBD9xNBVlXNZmKseE+CQR3zPhhpgmM1CjRmrXnYUKcDGm0HKJ2+zMCSraduC
LAWQ2HsbU6+zcPmGJcOfUhTAvDRme2QiMf/0GRTJZQWYNDDypi+ehQfFEs3U
awqQG5l5lnmehRENB87KnVeA+4z798+fZuF/43W2lccVwFO1pEz7KAs/t2w7
kRGhAHGbvBd8DmPhZe792N0nFMDSiXGn7BAL23J1yyiHiH5uf/Jw28vCsIZZ
C8r2KcCmJ62f+H4sdHLfqlC/SwFWX9SapunJwtf8/VODAhTg6dmTsiceLPQr
OfW12FMBEgceDge4sHBELeRrrbMClI1bBM52ZKFLlF9Cvb0CWN1denhwPQtn
LXorKLFUANZ4sCSF4PkzK2dsc1IAOZ+X0sdrWLiutebWpJUKQDs0Tfu0GQvH
9s9JjTUj+st/ku66mIVHWa5BuxcogFL951ubF7Ewz+2RE2W5Apz/pngKjFk4
7YMKSWCgAHtTGso19Al/3MuLXjtTAWwO5VrzZrBw14PtS6y0FGD+ivHLdtNY
+MZRN/49EfccSVAZn0L4wbHoa7aqAuh+Dps0KGNh3YwjKBMpgKZ85JofYmK+
H0MrfFkKkO7qcOSEkIWGjuLFbyQK8PB906UBDpHvE4DmZAVIelNNGqWxcDc9
L4Q9Jg90pzd7mP+YWHTtUPbcP/Kw1eCE8egoE1lzrQ2d/sqD6+ywbtVhJg7x
vA5s+CYPb2e728zrZ+L7zFkhvV3ysLR73a2NvUxM21ibo/ROHq5fctqe+omJ
PQsj3h79KA85syUfQzuZqDWzqwdey8Olr9eHb7UysbB+xkRPrTxsuSR+29rI
RNfy6bo25fKwuzm260gdE3HvtVk61fKwgXE4QlLDxNDNvyfUS+RhzR+jj9bl
TORe+WJsVCQPHk2H/8QhE7XnlgeeypGHB9GVSVeKmOi03fRDVr48+Gxsz2sr
YKL4wLbXiTfkwda4UqCTy0S7sbXvJ12TB7OWbxOHMpkY3PK6UO+iPDTf8nH+
eoOJOWHvzA8kycMrxviBN2lM/J0oUSiKk4fIxPKQeVeZeO2feueuU/Jw1MRw
8HICEwv0S64tjpKHSa+CtP1imbhs3H4lPVoeXvxZ2CZH8K7bI+vPH5QHJd1f
ukEnmWjYqj54J1AeotlH2nqPEPOgVqyZtzz82aXd6XqIiVZKrIaHO+Qh7uSJ
5ukEJ8+YXBLsJw/PTs4z6trLxAeHf9OUneXh2B3Fand/JmrW3rDYYS8Po0PL
Uwa8mHhqfHjIaK08lPm89BMTTKdda4zYJA/dfJtb4TuY+Li+Om1whTwsmurc
IL+ViY5FPvkykIdZCxdqZ29k4hXO6aIj8+Rhl9Ehir49E0F01MJluTyIejUu
r7Vhonnh7AUaBvKw7OTY5P7VTPwSaOjOn0X4oe7+nQQzJrrZGXSe1pIHu+eP
Ig4uY+Ltk7KYEl15uLdvyzLzJUy88zrdS6giD4tV2HV/5jFx1oYHY7UKxD57
e61zDJjYuWCyrp9IHu5cPyo/qsfEzEBv23tEfG3Qosc+OkxsbEtx+cGQB+N9
tjw9LSZ+TJBEDUxIQONS7PxfakT+wpaVT8ckoKM/5ckNFWJ/041kGiR5UFmw
e0GxlIkrpp61TxqUwNZ5fswzYqLft4YaE98k4F00K9GVy8SAyR8f3fgogbR7
djcjmExUeFTL3f5FAnU0m++L6EzUl5uVYtsigedzzg0rk5iYnn/af2azBFJE
T3PGRxjY/MbX93eNBNrFr/8d/83APY84zh8aJTDwOV/8aZCBbsVbqjY9l0Cw
mZNi/TcGLpRo7FrzlKhXlZVX8pmBA09mrqQ+kcDkXovWJ50M3K8envWO4Dxu
Qff9DgZG9aaZL8yTgKd5QlpOKwNZf4eiEjIkYLw8+Et2EwM9xz2tUlIlYBo0
OWJyHQMLM1WWnr8lAXmt09l3axnI/vtjeEWyBGpMpvU9fMnAs4JjBmYXJND2
4uLFslIG6u1Na1U4I4GP/Va5jY8Z+EpYej/7mAQOva8U3ya4vEp3kcV5CbT6
Fxn0PmCg71XI/HxYApVHXfmUewxcQdZ4qh4igYWFLcsmZxLz7evSnBMogeNN
ZU3OtxkYZu0aHB8hAYNHT17ADQaOXXru4OgvgXKTkotuyQz02OZVLe8lAdc7
V+78d4mBn/9wzJjbJNCnuE0eLjLw5b3ij/u8JXBwtRqt+BwD1yyYG8jZJIH+
B8pnB2IYeMz+GVvDXgLfyPusZxxn4J8T9pWtayQwMnUh2SKagadE0xnjRNzd
Y8Yi18MMnGsjSoFVElBaqGN1LZSBzArqTN3lEviXeyr8014GDm/xPnB5CeGv
/Jv9e4MY2FLLyTYk4iENO6t19zBQY3aVeYWhBOqN2/T2+TDwLa14drmuBFb+
U79a7sbAH/LRE7maEriUsm5hrSuxXy/avJP6Esi5GiRVcSHm99reJK9O6PtC
/fweJwa2/oxlX1CWwNoFoYIaO+L7jtfdh+QlsP2+21TL9QxMeBdo8k1FAt3p
XyJmWTPQ7qZ8pRZfAo8S3nT/t5qB81as/WbBIvazuMTkjxnxfW64BEjEfMcK
hQPAwIv31p0EpgTWOM3c42rKwOwTrfNfD4vh89S00w3zGRhOfpgW+ksMyQo1
USvmMjB1KPtK6oAYInW9rQv1GbhzWW6F4W8x6H9ca/dIj4ETqgqHF3SLYZ51
45CxNhG3o53b3CWGSt7UnfkaDCz90Vdzv1UMq8os1qSrMXDZlP7OWUR8W9q/
S/MIFri5ib40iWGq/eK4x1IGPhZIdAzrxfAo/aXpSgnRz83lT39Wi6HnZnBW
I4+B5NY58QdKxRB8/6VvIcFL22cvjKkTg9nlJTU7mQzUspg/5WGRGBYcVLsy
SiH8ciPrp9sjMez3maQQN07HVUX6CX9zxaBk4Szq/0tHhTHpiPFjMZy5tNZA
/w8d121QjIvKFsOXaeVfa37SsVTNs0srXQy6rHvL9nyj42B8isl6gr0bOnMs
vtJxWrXG1fFbYmj7vVBP1kNHT+f5EceSiLjZlYzSTjq6zZjGrTsvhvgmpVz/
djp27O2LY/0nhlm37W6XttIx8fKTTayLYpCMDi3TeEPHztwLx5WOi+HKpjN2
bxro2HRmwergo4R+b5d0/1dNx978cPPb4WKIZWQfdK6k45uNZIOIaDEYHvPp
X/uCjgzph6PJIWIICj22m1tKx1qtyfb9AWIIqOBsq31MR6m3ZdgRbzFs8PmV
qlZEx9zjHYbqQUS/W/cVnn9IxzuynIaPrmLY2u8Qui2XjuZhsQP7nMWwsAdS
dbPp6FC9us9psxg4VzKOj2fQ8TqvOG/fDqKeRdX08XQ6Xjqnfajfjtjnhav0
+lQ6Ro1krHJaLwaLl+4L05PoSHcVX3hiKYYcPhb9vUTHDdbvLtTYEv7TeVsS
eZGov2Km6dkVhL/W5Z13PkdH9WP+lWOLxWAyUHRv6Rk6Tqmvm+k6XwzWWnq3
VE7SccCbk+a6TAxTep/ITztBR8fvVtVxJmJwF8c94EUR/dMPxIbqE3qZKF74
E0ZH9tlNWXUzxFD6xLZ90wE6PnX2FOobiIFF1bvTHULHuaM33XSni2FRR/lY
cxAdP9tqHfuuLobxoTf7qvzoKPPKC69VJr7H2jq1zJuOFe6JV96ICT8v1em+
T3BIy6YtUUS+nZfTrydudCTlqFjoCgk/9rR9eeRC+C+QcuMjUwz3Hv4mP9lM
nA+m/P5AEoNG5O2Fcwh2oatsMSTyPd3R6OlGOn7U6Lz+kYgnlW6NfLmejj5M
Y7vLIyJQqRnpemVJ+E/jTkvdLxF8DNq7v3ItHQPP8iY+Tohg180S+w4LOl4+
Y9Cp8V0E1oe+vR5YTvjd60+1YbcI1hwqcpYzpeOuFxO93e9EkLtCYVLkYjq2
aNeb8QdEEPPEr19lAR1hFyk2iIgPzd4UaWREx61JYHj6rQg2nC0Xr59Nx247
7yq7GhGIDYXFdnp0tJ5iYXfygwhaNigk+evQceHu6AcFFSJ4dPHalHPT6Bg7
pdOo8aUI5JVexxeo0/HY26GdXiUiYF1c+HPFZDpqvLO78qtOBM3cSeMdqnQ0
0x639CgSgercvnU8KR2/Uo+5ZBWKYP+dwpMLJXS0X+b0bUWBCAKOxDmtF9Kx
XuNZxDOi3uUxTpYPn45FryXCiRwR8D/szElm0bHPMpGOt0Uw09kutplGxwOX
OC/Mb4gg7fzYnhAyHf32ZPc13hWBQeaudSISHflXb316mSSCq2KLj5Zjcihs
2GzxIlEElwYOW54eksPXI5se+Z4XgUiq3vn4pxzS/ELa76SIICH9eXTtgBxG
xfBflJ0Vgc6JojPy3+SwfY1lV+BxEQxUS7Zv7pHDfuM+H0qUCHL+TZipfpTD
hQs86uViRfA48ujYjS45XNIQsYgVLoLX4XUOv97J4erlFsMVIcR+N+cFm72V
Q3JyRONpgvUdRm0uNMnhXOkrhxOBIghRzZ9/nuAbj/8o+UaKgOvg9/lrnRze
a4obWOlF6N/Ya7iiSg6HTnxUz/AQwYlK07nJ5XJYfoRm5+AugrE7abtnEBwn
+s3ZSNTjPbT+NP5UDiXKvY9CtongdzjJbOsTOSxwYB3duVUEVb4mliUFcjhp
3ZnjZQ4iyHu936vpoRwyHApW/nATQa/a5/Fp+XI4sXzGggp7EczdS7I9kyOH
A+IzvDhLEQguha4avS2HuowyVrKFCL7uudV+OUMOH/aRdMaJ/I1vN79zvymH
0H+/5w6IIO5OCv/NNTm8wBox8zQVweKMDc2rk+SwavHm7ceXiMAtDnYfSJRD
ja+LxAfNiX16HDbCi3J4IOquW6OxCIyPwzST83Lo+Vlt9q25Iribmnrj3n9y
OKdHLapGXwRWJzXLA2KI/qcqrGo3EcGe+S9z9U/J4Yugn7+9povgSmbD6jvR
hJ7fCp5WqYugaG63h8FhQu8tP7PdCX4lZJw5Ei6H+zQDdynqiuDTKz3O/UOE
PsHHq/6oioC5tk1vcYgcPtb5m5gpE4FN3+Gnz4Pk8MphlYN9EoLXDIZn7ZHD
0jsvbx+aJIIm87QP6/0Jv1SFRs0UiKC8+vXeDh85TPeJEJxlieDeG8eoPR5y
+OR40O09ZBFEVTzV/b5DDt8PRG/P4IlAbe0+Op3g3A/D9U3jQjgdE/Ln8jY5
jN2S0h49IoSoQ3cd5jrJob9BpEXQbyGEmA6tM98oh1uVFG5ZkUTw3MNfs9Ze
DsVbXrQFDwrh1D/xJp/1chhqfSbM/qsQhtYMDnKsCL9M/Wl6/pMQ+mP+XMpf
JYc1A4VB+38K4Uh2wM8sgn+YRJ7e9lEImZUjNutXyOEtnv0cbrsQTkb/EIwA
8X21+TMc24SQO/ZU+9oiOQxe2crVaxbC6ornxQsJVjp20UdKnGf5didamsjh
5KB9/5JrhPB8ZZ3bmKEcnnA+JvEj+Ch37MhtfTm0cd/fa1kuBCsPufA3enI4
JjZXNGoSwj6bT7+26Mhh/v5XnQ3FQriaJ8oTT5fDGJc5+ewnQpjdSMeXU+Uw
TPzB2rVQCMcfbQs8qS6Hh9iL3gQS9Sjm6xQPq8nhyipqafd9ISid2Z+3RFkO
Zwf+fv0lRwhLVKQJfxXk8F922O0NGUJIEx122SAvh38HLUesiXrlc0uePBLJ
YfirtQVa6UKw/MufFsaTQ/74mbtb0oRw2flq5XKWHHZMtBQuSBbCy03rJuYw
5NBh7eodLZlCSFWUz2LLyaGdClvD5KoQos+KX7wiyeGgip/g9GUhPBpdrnz1
Lw0TeG/UBi4Ige0hx5g+SsNthw+qtiYJwXSmXYrPHxouhicm4XFC+JA05Ljo
Fw3//cAfz08JITm4zYzfT8Op70fDPI4S+7rVB7O/0VCbE3Mr7qwQ1N2fbO7s
oyHjEBWiooRgcH9j8sPPNOzNLPqaf1AITnPceWe7aLhh3t+tgkNC+NS9z9Lq
Aw0z5xgkNh8m5tO5k+L9noYvCyNKG/YJQdnnt6NFKw2ndycarfcXAtmAOm96
Mw3bqwXtLgGE3qNXh8Nf0dD4fsit6cFEfY00QybBbqxLlCm7hCCwuW3VV0ND
p9WaPX+9hNCj1RtVV0HD8jMK3LcuQvBNrhkvf07DdZWC2VuJeNYOo+YHBG+b
pTn3/DYhrJ/iBSlPaRhI0S/XdCDmyd9RfOoJDeN1vfaeWy+ELU/l1ocUEv1q
bkqrXCeEA+G3JmsQXMHt/JO4RQgTUw2GPO8T8+5Pb6xeI4QXn6tvOd2joc9Q
xu+1K4XgZ/3ca102DccUy4bVVgjhoeJKndgsGhpcH+ELrQl/PmPMW5FBQxvP
tdHhy4n7UxfJXXyDhprz5Z9dXCyENzKdXuNrNDSj1sabmhD6+LNeyKcQ9RbS
rqYvE8LczcMVc5JoOLe+M1zdQAj5rh13Zl+iYdL0xFP5s4n55brPz46noXR/
AFzXFcKxqB3PM87RcI2zTmW4EXF/ZHIH5sTSMDFzHj95uhCCgpduMY6hoRX0
ffabIoT/epIXLDpBQ7u5rP3dk4RwLz7mi+0xGvZVTl2sPEMI2Xq6IrOjNDz9
86xXuSJxPwe/v7OMpOH7LyNmrxWEgM+GUzYdoqHiU6FfiVgIKd11I4KDNIx9
/vfddFUhqCg5OLiHEH4LUVMtEQihy0CTtDeYhhzFEpVynhCeGQVcOLaHhldV
/qy9zRKC/tjW8ne7CX+ciRyNIPLLRNtUE31pOOh+wmvfPwE8PEQ7fdeLhvNC
zGaNDAng3Ujk5xduNHz8UEVtyqAASs4+I6ErDQ++ExY/oBL6FP/V7txOw+Kh
6860zwJY/ix+/fhWGrqeMjP06hFAbP6+bcpOhL+MF4uamwXw/r3NgdyNNLyj
emeG3ncBZPRWWc0nuP374uHSJgEU70A1R1sabjr1n35rrQBe1ERWH1xHw/GE
Ica/cgFY/beJVLCGhtYe+3f5vBKA227zTSkE6yTN6Nck4o0zAMtX0nCSfL3+
uiwBdO+5SepfTvR7KfFVVLoAlO3vS5WBhl+0mo5cuCaA2b7THOtMaXhL7WPH
hiIB3HS7RTdfRMOYjrfxbXEEFxe/CDCh4a99aaQl8QIw/bdgS+pcGsadZsd4
nBRAVPJu5xFDQm95d88FKcR8i7Y9bZxNw63zPfSMQwQQyQ8YYsyioQXrRbfF
AQFQQoqHF2nT8MjZLVZDuwTwxs78ueEMwp/fXx+tjhaA3+8zZQFaNDQ9qkmX
bhVAqMscp0x1Gl7vLfr4crMAvtGGC7onEe/Tzd+HnjsJILwPdoap0vDs15z+
K7sFwDs2+/1UZRre939n5rReANBv+NJZkdhvgXZIuIUATl92CE4W07DyUFaU
yxIiv34Zp01Iw5QFF6/Y2gtg/qI/Hzv4NPRsTbjXOk8A/o2+Ei0ODSdv8qxL
0BfA0F1lkheDqF95PGbldEKfb8zoVXLEe6h/a6SbqNfiuflWDpWG4UpNx9sm
CWBJYzxvZIKKHd9ZB58rCmAmU19n+V8qrtQX9DtQBXB5YlVe+QgVNZ0POR7V
EoDjxlOkM3+oKLBsmdzDFsC01dJTbb+oxH25mPRUROz78pIqnQEqlu26aXlh
gg9toZw19t+puMt+tb0VVwC75+4qPviNivxtF/rII3yga8vvqO2l4ivScZX0
n3zwzU17qNFNxS93+fOVvvAhLC9nxu9OKh5I9GSN/+ZD4Oz4ov0EV5r/86r6
wIcTKpu9699RscBVL2Swjg8f2X7PZ7ZSsUvJeLCokg9x73UnX2+m4jK888Lx
PR9u3l5bGUXwhDCG+7yID7Invvs6X1Hx5YfQ4cg8PrwX2VVBHdHPdkbT/od8
MI0Mf5ZcRcXetUbBx/L5kHHOiOxK8GRejPjFMz54/wzYTnlJRS23+v907hDz
rspL2fmMiuHqoe9br/Dhlt+LiIoSKv7mrfZae4nony3INiC4J2Hn3nVZfOhf
M59s8ITQS7V+i0McH6DwrNrFQioabJoi9/cEH5RYV6ooD4j8jPSxpsN82Bxo
1Cm4T8UZO/7onYznw8x1e9R9c6mY6Gj5I/YgHx4Gtgpa7xD7SQ0fcN7FB46K
d/yqTCquLwlO7vLlQ2TUrkPjGVQ8t3OiIC2UD/sq83ML0qlomZs8aOXFh4lB
GzedNGJfpXvCLnrw4WtXc2ZSChXvNQdGZW8h+n231mH0KlFv3RUXKyIe9aIj
SpJExbyLbfaXHYnv3+L0H79E+KW+rSDVhg9v3QZ7yReoKG8eefbuEj4InZTM
6eepmBr3ddewNR925prsORBHxYH3xt95RnwokYRGD52h4uUTi//tmc0H+beu
MwJOUXHeCcfXV2fxYUbqwpnqJ6iYzGSr9psQ+mjE2g4co+J+H3E7RYcPvxuy
Gf5RVFxxQC8/S5UPurHbl/+MoOLV7VXNH6R8+PBuybPVYVS8ELg58bI6H0Ir
NsoFHaLiTNJPzT4xH96kLlg7EkLFa8c9bXfR+bCRXKAYtpeKnVupF7t/8ED3
Ye9oZCAVS0ovWqmz+bD4UKQrneCGphI+jYiPeVkYnPGjovY3oVXHdx4sqHh8
SLaLioonI06Yf+TB9gb56y89qTg0rnzdd5AHPywvrE4jeHh4g6tHKw+CNpyM
m+NG7PNHpsqOtzxI/2TjULKdip/JO22FdTzg5Fy/YLONimb+pf+dq+YBPdDo
khrBCTdqGva18eCXnKl1lxMVd6i7DXGQB4/ftocHO1CR/k//k3Y+0V+x6QyO
HRXbk6ZdVc3mQeJKxwcRG6hokqcZMl7Kg4JOzRUpNoR/d/F/3kzjwRPmutcm
VsS+23d2/k3kwavTEW/rV1PxTP2g9hWCP6VZdvxcRcX0vwtP7MzkgbxLhLXP
SireoRmM8uN5sJSiMI9pRvghynd8YwwPVMJop9OAiscvZFGUD/OgXul7m78p
Fav31eVVXeBBiZ/MxmwxFUsr76hOj+SB0oha5Mf5VJQax+XdDeXBbOxQO2pM
xaovwWnOIUR//+ad/TeXiindMStKwnhQOKA/TduQqL/gTZOSFw8OLGiJr9an
YnHCKfPNO3hQ+ix7d4AuFb2VFF6Wb+GBT3H424SZVFxql+UU6Unot+DwHWVt
wj+cooWRm3gwUTjTrlSLirOsLF0UbHkw1B6ybddUQo+QmtR3a3kwRyX9PEyh
4tGwK4fiifj5nNXV0slUPNmsS/cAHrTe3XPlmQoVD4lazhYv5UFyXVVNgJSK
GUbNkw3n8uCZ3WDGbwVCf5escc4iHhh7znXWIPivmuLHUCNi38uPWjeKqHh/
4NaVm7o8WB+TnHSUT0WF8svLLqvwYPLnI50POFTceuNx4FpNHtzp2L5qAcHD
CoNbbijyoHde9rofDCrOrsxf18HiwfVvO3LSaFTccmyu9pxRLujpPdCKJlPx
naKWNXJ5oFjs5bWF4D2zrl2ooPKg6tn1g4r/KJi5curHzf+44BM88qlulIKC
Oz6i5z1cCEuyTjs1TEHtL38153ZxoWHRPltXgt0d1iUUD3PBdHtcwapfFBzr
HqjRIeKeCzLVmQMUfPmLWnW8kwuin0fbyr9R0JpcPvNsAxdGVxiuWUtw0rB9
oW8HFyKuC3uPfaHgDsGvMosqLigUzTNf85mCUxJsm4ZecGFyX99P/kcKovNp
h+J7XEgWegwv7aJgup+Zy28iv8FQ7furDxTUuZQ0KyyfC9ptaHypnYJrTmyI
783kwlu/8kqXtxQUWXFceGlc4JcYapi1UFDLXd96ykMurHk6LXNmMwWj5nvU
HL/EheOdja9/vaJgx7vhaMtYLizXeLka6yjYExZheySeCxbZosL1tRQ01nx9
pD6VC/WSv/TT1RR8+mvMzyeGC/ph7mynCgrqzTp2qe4I8T0v+oaZ5RS8p+c8
SSuaC4aJq67sekbBD/3sgXdE/lthU+doKQXX75qZqrmfC3Wf6vKrkIKF08pO
F0ZygXfmT+XVxxSESffdT/tzIbf4XPa5IgpOC0tZ0B3EhYyPazQDCyloMDZt
cMCTC43fKx+vekDB2w/WPHzvyIXvXSEXpuRRcCPvI6WO4PP3At+W36Xg18Wl
NYztXMibtjnnTw4Ft2ebo+t6LriYBTIasii44NVpD1jOhZafLy5nZlBwZvFj
hcemXLhgit/p6cR+3+vaG1ty4Q3fxefYTQpeCAuu5JhxQeuS2b6d1ynYS0ld
b2/EhacFB58sT6HgoGP10Ad9Qu/+9jc2SRS8tSNxr5wJF3TyJEs0CC5keuYF
zuJCzA/5IeplCppoCGJuTSPm7z/16dMFCq72mzI/VIEL43bHOS/PUXDXe9et
PFUuVB+bdzCd4Fi/qjNl6oS+bVL3rLNE/yn5NisVuWBuv2Y4NoaCpJ/PPl5l
c6Ej26Bo/0kKWuDr9FXjHIjsuvKITXBDloAPXC7Id7ffdTlGwej3syo0RzmQ
KnB9uzqKgrrq5zdZfeOAi02ToVEkBakJDUGuBG9x2X5sXwQFf+cfn2s5zIHo
jlWPp4RRsMSfzbj9gQPycs1BvIMU/OLWQJvfxoGZ/HObx/YR+iterNZ+y4Hd
Z1rvDOylYNHur9cDOzgQ5HjR70sQBSdZH20IbebAGRvS3bd7KHijZPy0fQsH
PFy7VKt2U/Dt0ePDupUc2HtdZ2qwLzHv+ilaC6o5UEDfmvvEh4J7N0X7rinj
gPeDUwH3PCmYGlluv+kJB4S/T22+6UZBX1H91KF8DiydyCyT20no2+zmP1DA
gY1LQ3ddcaVglc5e0aV0DkSohaadcyb03Xpr/sVUDnTysqint1Cwdd32g6/i
OfC8Qyk02Ynw3+gSy6KbHNgUoxd91JGCc9PeX1FI4MAbZU39iI0UfPLrnkvr
SQ50zLg7enADBVcdsslsi+LAPy2XhebrKRgRWn1eGkf0N320Z78NBT3IDz/n
n+LAjQOaI3utKMizma01NZQDosP2M/euoWBt4+3Uq/s5sN9Tp2HIgoItBR1b
SGEc+G7c5b+X4M0lDvvfeHOAbnK1c98KCj4ULimetYMDpvmt/geWUdDlwqqm
tds5sDxg5px7pkS9C+3alkT+3qanamEEX0o7eVNjKwdSssN6Di8i6jWk0QRb
iP2bLak5Pp+4T+px8084cCD9qE7tf8YU5BaeqtNZxYELlqHL9hE8SDI6WmvP
AUfroC8JhhQ8lWG2+qwZB37sXD352mwK8pv8dwWacEAa+NYncxYF5a7VJ58j
uCg34YsFwZ4evT6aQOyPb9/wYCYFn/cnuS9ZwgFO9nersukU5NwCg+N6hN45
rzvqNSnYNFMJFGdz4MT1byqaBGPjxSApEb9mt/TEB3XivVZZdm+eFgcai7ev
7Fcj9K8g/cmbygG9gd1SsioFmay6xaYyDlgfXnSbpULB3XnWl/yVOfC3Iumv
WEbBfzcrZNc4HLDhThvUUqQge/ZF73kMDqD14rH5EuJ9PxH1WXuCDUsXpZ0Y
EVGwX/NCwjcqB5QFk+TXCSkYknxLP/EHG+Yk/Fu0k0e8F047fwZ/ZUOSgmrQ
QTbxvb415ee62HDR/uO1QSYFlVYYnNg9wIbQYzlF5xgUzFbjukf3sWHhi2FB
No2CB2ekNNoS9Vwi9PxfkCnodei1KqudDZEPae3DE2SMfqyk8fIdGzbNjX3X
9Y+Mm5s2DDQ3sWHZXJeNpL9ktE3Mtb9dyYYnaW/fThoh4w2rd2sLn7LhZlSd
Dn2YjPdyn88fI+JloUs8Fg2R8d2Ni3olZWwICq/+5zRIxhXh7PKFRP6A6csr
B/vJuFb7/bm+u2wQ2//dqfadjD2x20qOFrDBQCXQLOkbGX+nvMtJesSGzkWi
n/iFjAtXxj+tI/Lh0se0j5/JeP5ejb78DTb4dv88BJ/IKJdbczPtJht+D8zZ
xiL405TRaQ+T2cQ+lk7S7yS4qe3uzgQ2hAdsfG/3noy1793I3ueIficKr4e2
kbFsaUWVQzQb8uf0OfsQPJSfbHQ6lg2MVXk+N1qI+VJqtddFsMHv60njutdk
NFjNsrmxnw2Dq06Sx16RsUh4masRyoZUxo6hFIKnbJy2kHeQDWaH/1ZNqyfq
5ZluzfJnQ0nIzATbGjLeMnxiNrKTDa4NztsjKsl4vTFG74kPG8wDXQw7Ksj4
UOpRFOrFhrtf+mbmvCDjkVcBjK9b2ZDbIR14/4yMWyysQtK3sKHnrFGesJSM
2dzeL783suFni1u/9lMyJiuTTqU6sGHJ2f8CliEZH7dO0IyWsYE3e79e0GMy
3tFr0A5fxAb+PtOP6YVkNNzgVQAEU6ncqQcLyLi+I5e7w4wNTjpzz7U/IOOZ
r5dUGQvZsLs0fbEkn4y5Wf2+D2azYarfj/er7pFxUEGWJzVgw9BIZ25zDhlD
lNW+GhsS/Ss6hUTcIeOrhxomu2VseGRtyi3MJOOMixoDAdpssPbuPzd4i4ws
Hu73VWdD3oPis4vSif6CN67mTWHDt52lEr2bZGzZNPW3RMKG/wZ4xzyvkzHR
nPXgpTIbinZPG0hLIWPxgcCny6Rs4v/hg5sZV8lYf+me/A4+G44MuFp1JRH8
cZH8JiI/xVjtqnoi0d+HZxtsKGw4kJnV6XyRjGetHo9VDLDATqbep36BjPPH
VRc3/GXBol3e0pR4Mj7Y+VxzdTcLOpbcNe2MI6NTzYsVur0ssI1t2ah5loxH
P4Zyo7pY4OIQbnwthoz7x5aVBPaxYH+kqbM7wa/e/gzLaWCBzaslDrdPklGW
2zEzimDWgKFp/zEyFnjMUlZ9yQLlHwfkjY+SsX21/KkBIh7bdy9Mh+A9z+PX
333DAtfowOaDh8mouqKqpvQpCyxkB6PLwsn4J6DR7FUJC+rTBzR4h8hIj494
T3/GgvObnuc+DiVjVXzB5f+es6CifW6m/QEyJjHO9g7dZcEnyo3JKfsIf1d7
PZyaScxHuxH6NYiMDV/L2oOvsaC1mooOBPf2/Lp18x4L0v3jn5kEkFFR6+8E
+RILQve2DEX5kTEnx9T6yhUWTPlYL2zcReyv8KztjTMsOP249NJfHzJOilDn
qySzYFijS6zhTUYr7QqVXf8R+i71/7vHg4yHdze71MWwQKvrQ1XpTsJPip9H
fxxhgbmVaMqtHWTE6ZE2PSdZoGB54bCCKxk7K7Y+7T3EghdbRid7OJORueOT
378DLDgW45dStIWM/82K0fzpS5zPRfOtm8noQt2yrWk/Czb9dGYIncjoehJ6
j/uwQN/I0GanAxm1TzAG9xOsfnndoSI7Mjpu0Euz2MqCssmkcZUNZFQ+Vzom
78GC1Am1GLEtGS3CXCZOOrLgfiM73MuajIdUVZrnbCb6nxpqW2pJ+KvqbOn1
NSxIezLXoHMNGXWTny19u4EFj498YEwi2OHI+qNRy1hwclZy4l4LMvKmNbxf
uoAFwo7polcriPeIydKJMCbqrUt5m7OcjIuTF7WrLmfB8aGuHfoET534mvB9
DgumbVx64RSQ8a1KVHegHgvWhGbd/LKY4MeLmcmzWOAd8eR19EIyLhknLzox
mwVNAfHnVxEcnvdAX3MmCxyavJxvmRDzrcrOaVBngVvlRQbbmIyLbnMe5ktZ
UMOLO+FtSLx38x0fzCAYzi6d5E5w1C/b51Q1FvR1PO+pnk28f9fmnX/EYcFH
2Q11Az3CL8Uz5a6wWfBLcm3ueR1Cb1Y9vZrBgss9269YEXyhNyZ/D58FBQW6
6qMzCH/sj8qXjjDhYNjD7m3TCP23V+Xv7WfCfteHR55rEPPa3zcq/cwEhTun
zZcQbPil4kDtGBMMvl0dnaVOxtvpDs6mg0x4qNu1Ml6NjHkFn1U83jOBVDjk
PaFCxqycq1EDHUR8cqvQmOBITp7H+h4mzMpb5+YpI2NsXPHPC21M+ISuxo2K
xPt9olNOq4kJ1zi3Wk3lyfhN75WiC8FpT6WtRhLivm5fcG1xMxOmLNS0zBSR
keZdxnpYz4Ql6wwvywRk9J0pr7WmlglOS1oeRXPJuDf3aNzsl0xgf315ZTGH
eF8fra77/IwJcWYxd4dYxH348zDiTAEToqdU7nNjEPt7MEm1IoMJd8UscTON
jI31GFFzmwnr+lRXWVKJefLXGG3IZ0JxW8lBCwoZx+uTmF1ZTBjA3Q8LJ0g4
PghrYy4ywS/idNmscRL6Ro3x3c8x4cCIb/WOMRL+ypHFKKUyIXtbfHLKKAkf
xisn3D3LhDIV+lrFPyT8YO59hBLFhPpBh+cnf5NQ/Mb47KGTTPj544rGkUES
Nnz7x7b7jwmOqRwBheCnw3nOaseZkLH9stb+fhIq+X2p9zrABKPuKNbANxKu
fKyx0C2CCfPv5Ovc7iPq6a+f/yOMCeNbVhV6EnxtiefgsB/Rf+COeV09JGzu
PG9WSfBGa/vwLd0k3HfO+GToTibUnhx619JFwrEDtfnBvkzQP5N07g3BJ/SX
NabbMeHyqscBGzpIeHMgKnuHExPMhYaT6t+RMHCrv4H2euJ8X/h/Vm0kFL0p
GfCyZYK29R49IcEBOdpy7zYzQW/zjOqqFhLKkupu2NkzQcPhdsOaZhLen7Zb
UUBwytpTyZWNJBytkDl1L2GC3Dw3jhXBkn3q9dQ1TDBRtTJe20DCuK+ZDrEr
mXBYLTCuupaEYT37DT7PZULC5MgH66pJmGpIcjptzATVuB2746pI6M/sPnFr
AROCt/1Naagg4SvfxvDWGUwIPOu+3v4FMW/QEVvdaUy412rx4u0zEpodzUqb
asIEJfnUhR/KiH0VX3gzSOTHvNaiOpeScKeIapCrzATRqSOUbiRhdmFaUDGf
CR57+575PCHh89Vn+l4KCT9fFHjNfUxCz86NZu8VmLD+SMfaX0UkJB04GLB3
nAGX+d/jDxaQ0KR5tvbcXwz4ryMhVe4BCXvGl8jfG2MAJyfm65l8EtY00++G
04l+53ntOZNHQgPTLJcLvxkw+vALRfkeCZNc809U9DKg8GDqhrQ7JAz5Mmr3
m2BnnVn5P7NISM2P+zT5JwNy6GruBgTPuOrItW0jeOXH+U8ySFj8fnMdt5sB
XYnhVWvSSRjk3lKa+JkBggUaTzbfIGHVI1NttU4GrKgNVXubRvgl2aUnsoUB
ahJ3fc9UQp8YvZN+rxgQwXjx708ykR9/W2JUwwDL4JKO6iTCf77rtpbVMkAv
Zsa54wQPt0YPX6tggOyserNyIgm/nr7/3vMFA2KDZn7OvEjCy6ce7YnIZoCE
dn6m+QUSXrx4uolfwoBFt36kmhJcRpk+6WcmA1LkXuu+OkfCPJ9336W3CP1k
SS7usSR0/eSQ6JLBgKUWl1z+niFhsPDBh4uXGZB6TTXuGcFpt7/0brzDgC0z
rnJjTxP6hR9hBSUyYPKjrxEzTpJwgbg1aHsCA74c804pPkZC5RcZDudjGWDg
sv37GoJls7dtdkpmwMX4iJCNR4l89oXU3JMMYKyNVO0/TMJYC/eCK5EMkHYH
uB+PIOG/AFv/7QcZkNSw1LQlnITb7lnm+p5mQGWdR4hGGAlns1nJLeEMeDQS
YvTkIAkTL0bXcv0ZEJif8WBTCLEfYyXKGQ8GUNPq9+3aT8INB5tNa0OI88e1
On7vJe7LsKjHNIABR1601MUGkdBylLxBm4jv2Mt0nx1AzOteck/RiwEXbNfG
MPcQ53d95YztYsCfkdNPa/xIuHZmwi9/Rwa8fvykdJcvCTPaws7M38wAXLvz
OM+HhP1RRptu2DDg5TVBQIYXCY2uvHzvSORP29E7mOVJzH/qOq3Oktj3C+rU
de7E+xK9TW3hSgY89NX/1b+DhHy7JdJCIOZTS1S2dSXh9iXBUz+tYoCDl+R4
3HYS7v+7359PxLXrF5cYO5PQ4+S497EFDKiRmhW93ULCLW3SbSu1GCBOPLeP
spmEF6asmXKAiFs7l28McyLhkSu3l+nMYkBv3Jp8zU0krGvKOT9nJgM8y47k
VdgTfpqqppKnzYDhwsfhDzeQ0Orcplx1gt09PgX4E+w8MUOnlmA377mN0vUk
rDb/bO04mbhfHQ2DuI6o/7T89hx1Bvj4jE8LsiShysuoWltlBngduJTrSXBl
du5KqQID6sbfGkjWEOebXNUSOAzY8yx83WMLEjJovzKTGAyw2lIx08OchDpu
en3pJAbIp6b5mhAsWOZcN4WIyz+8f11iRsKhvzdYW0bp0GcS0Fq8lISsD1pr
b/fQYd96UY6PKQlLf6YaqX+hw0jA/FkUgjP87JtD/9D/x3CZx1PZBXH8rpQk
spXqbSFJ2SKS6pxEWohQlhalUpItikhkiaIFCaWF0CKlJEsYSymELCFZE2W/
13Vx9/f58/uZOWdmfjNnPs+DdWyysdJWUpm+aI/uCcL/rKKbx9fNpLLcSy+0
W1lieHjkgJ3fJlJZqI+inUSPGCYJ7F2aDIj3/kehcOtfMZxASu9U1SfyOxij
WNkkhs/kWi5t0yWVNcxJpf6qF8P93qkzkTqkskHZ4k/NLWI4rvGs1AttUlkM
N/aOeJsYFpaExhhqkcp+Fa8bt/8uhuka+4pH1hP7a3DXd3oh4e/Xmf5InVRm
p8o42lZK1Hd7avG1tcS+Xji/49UnMSxven+NtRqp7K629KoHeWL4YKKls5gq
qUw9+qzt9Uox7LowUP+jMqms+/aTHXXvxfDb8/eDXFeRys6+uBD5jvDPkm0p
91pJKlv5+/Net5di+LLqyIDqclLZfk1K7+o0MbxU4XRZ11JiX1STNzomi+Gr
f/7TtFlC5FOwsME3XQxT8PCGBCVS2fO/z8NeJBL2CYlDFosIvT6YCnTjxbAS
ClISUyCVrW25ExgeJ4b3yTuv2CFHKrsqd9wg764YNpX8cgtkSWWxhS696tfF
cPri18mXZIj3nqycYxoihqv/PbPXW0AqM8rUf3z5ihhOjT2+23A+qaz/dUPu
h3AxnN8QnT0hSSorXjBJ0yH8x+iQlyVBKpvdXnvkp5cY1j2mbnNmDvGeZE6L
HTkthh/+Mni0UYxUtj2Wk/PMRwy/71r1dDXBbo9XWu8+JoZDStIi+6mksq9c
M+nT9mJYsn18WRqZVDa5e/Pv/86J4YLw1XcqhCKIe7f4ftAJMTx4s9LUi+CH
UwOZnwk+FXxtpzFXBA6PuOVXHcXwa4vNypVsEcCIxZvyg2I40OPGMVOmCCpV
a+Z83SuGpc/rHb3KEEFf6137uANEvcNNFV9HRbDS+MACTxsxHHB4a7jFPxE0
9dht7NwvhleSdrk294ugevT9C+kdYrij1fTWo98iMFapaAOCua/4WY49Iuh+
V9z5xIDQK4sn3d8hgjb/7mVh+mK4aYNW07lWETwfSP7A0xLD9zMly7+0EPGq
Psf+0yPq8XR4P9Mogq+T8ltpOmJYaokpM6xOBHdSs0iFy8XwoeWtFjLVIohW
sW9+t5qYrz/NffwqEWyb8zk8ZJUYXtueT33ySQQ28wISOpXE8LUvE21aZSLg
pLn/vLFIDAfPl6CVfxSB1B7blKkFYnjz5JLOrYUi8L3ZHdwqK4ZTUjQsbPJF
sC+W014qJoYZAV9GB9+JwDRihs2niWHjgeXPA1+LYIqz8gGTTOTXkfzgRpYI
qGXHfEKpYvjrv/ACmZciuB62jGvFo+Nbg079zzNEkObr80lbQMfNsr3Ht6eK
4P5cw0JZDh3r3deX7H8oAgNRWu0TNsHfb3M6UkTwemWQBmLScU5ycP+FJBEs
ev+PduofHXOeOw7I3BVB6KhJQ/YAHUf4SimZ3RHBH49tM7N/6Nh6YOGmN7dF
EKm53edDOx1bGPmmWkSLwN3vv3VJHXQMS6wdx66JYHlnRJhuEx3fxl5vP4SK
QNXf74h3Cx2rUJLVbhGMpTLv//pCx8I5QhPtK8S8DWS2fa+kY778rQvNlwi9
D3n9O/SJjg3n9076XRDBtGdjiuY3OpaY4/lLh+BAr+BrXMJ/qdLKsGXeIhhz
Mb23p5SO5SRqjn46J4JHGiSOw0s6pqmrmZ87I4Kr/Jpu9dd0vNooZG/BaRHc
EgSvacmj401W98LkT4ogRiVS6SvBMl+u1oKTCEzsHM7KvaBjyZtrDrsdEoFb
5farkU/o2J2pPW+PI9G/twvP8tPpeE+VHF/RTgQX970Vt0ii46cFZ/o/W4sg
wPjDM+U7dOy57Xu77z7i/PmEyl836Jj8JV78r7kIzFcaP/8VR8ftVAu51XtE
UPzIyPc0wWsuZh1uNRXBFgOn11mE/8OqhqGo7SLgjj3xq71Axz7vhjVuIxE4
RcaBSzgdn27KCN2yVQSHSotDRoPo2M9j6ihzEzFP5vNZVX50PPdzlekzPREI
/D9N/iXs1qcz3Yw3EPnYvv9S703H6u5VHke1Cf3aFn5yJ+wxH5elKqwXwWM1
zQsDhD1ujYPc9zUi+CB+vHrdSTre+fHUa9JqEZwKAVu6Cx2LS1XcvqEsggFW
3vBxDzp+/efLnp3LRXD74NTwEifCf7xJkrqEmK8Vzh0nD9Jx+nx2f7WiCGYc
Mt38HIl5Ld44v1xBBFHCe56ifXS82M5PNmShCO6d2jSy+zAdc2sYm7EUMQ+j
lJmNhP3qWwvuQwkRkO8YjjXvoeMqXtcjMsHxB6U17xnSsWMbS+wTXQSMjzGL
0vXo+L3B1peRZBG8eCXhG2RAxysdE3ouC4SwX6D7QnYzHf8MuGllTvBrZ/Hu
S4R9g7BJeyFHCKZzyYfNden4s4do4c8pIQwxS4bHtAl9a/5opDKEkGI84fR6
HR1/vb4s1IXgP8nOFUrqdHxkNG732VEhiN0P+5imQcefbkOK3j8hWP/J0R37
j46lHiZNiPqFkPrjsjdjMR1XerNHHAneVm70J5rg1y/y/b/1COE6skj4oEjH
DTfOkO7/EsKGf/5xIcvo+P43tZIzbUJ4rp7gs2gBHZ/Yc73FoVUIVbqh9ffm
EO9Z2tlvU7MQHgU8v7WbTugxfeHU3AYh3H5qsvuIBB3frB2x/FUjhLtnc3Zs
lKXj6AybnSeqhTBu1C+Q59Aw8+hc99dVhB6N3svWi9Pxvxs+EaEVQvibv7Av
aYqGr7vaNtiVCuFxnh/DfpaGf1RYavsVC6FRW1uBO07DY9s9ZDWLhNC5ZKoo
aYaGwxIaIukfhNCb8Gy1bysN35+1Y3e9FYL0o9lEQTsNF/BTrya8EYKRcsZP
XicN53tyY/OzhbCx65NSdBsNy5Tkqsa9EIJ63bssEWH/GXZoyD1DCO0LrFsP
facR//OJa0vThLDXSdOyu5aGpRLmPd2TKoRvPs/t2r7RsMAi5LraQ0Kv87tj
Jipp+Kon45R4shCOWXY7+36m4eon6YrMBCFUs4z9SKU0bLZe4P73rhBWO1Yv
DS+nYSsF7tmvd4h8x64tjaii4Uor97iXMULIulEStKKAhn+9cjHSvC4ESxf6
/LbXNLx1xZfsm1FC6AoQyp8pouEDuecnvcOFsGS0XOHpWxoe/81faxcihJoV
XvqcbBq+uSQ1/MJlIZi9WL7WKJW4j/rh+laC96/xfsNMp+Elp8x+qfgT+skf
vKKRQcMuKYM2832FUHlnP8khlob7rBxKpj0JPSLOrk+OoeGJzdv6qwj+1Rqy
QoGwp/kUmfe5Ef1t6PTbk0DDOoMjtd9OC4l91BM/fZ2GHRaMexaeEIJ5yIbD
0540fPuYuPMqgjeMvjo+dJWGXcdKKc+chNCxfa//v0gaVvAzKUw4JIQDO6yf
ZfkRer9MOhJhJ4SkmrPWJZdouLE562PkQSH8NlExSzxPw9OqkSoXbYSQo6eo
SD9Jw6l1pu2nLYVQ4Hx96u5hGo6mXMt23Eu8h9me5qFzNNwxYsub3i0Efmbh
RM1xGn50Ntljn5kQXo6fRi/caXjUTNFqxw4hKJ4JfmvpSMNJf88tNURCcL+c
PMW0omHSu1AZr61CiLsh3ut6gNAnVHGOtpEQXLuP1nUR9vOTj7vWGAjhjaj1
WcUuGtYKcW1coSuEfSMXrj60oeENgT/HJ7WFYMeVjSs0oeFyn0WvlbSI97Nz
yqTDnIbJ26efya8j6us4NuGzm4ZNQiuuy6wRwukf/zHXb6Jhut/K8GAVIeyZ
o2ISrk/DQeOvIqWUif6ujXO+uYWGQw7eOSe5nNBviebJzxuIftaFnpu3RAiS
aRZDhusJvfHOCvlFQigEg0jP1TR8ZVuA9TxFIbDMt65fRPCwjo+1pKwQZH4s
F7+nTsNPY68YSC0g9s1U6bc3S2l4sdfB+3nziP4ZazfcUyTmyyd4owzBnfnb
TfbJEf7pqYry4kK4OOzLVJOh4XV9r2WUqEJ4ora28ulCGn6uHSY4KhLA4qrc
rjXzaPhJydj4coLjprUv+C+g4RV5Uv2qPAFsMWc1FErSsM0cn0LNGQGY3BoZ
jiI4au67DAOWAHKV8t58k6Jh3ZblXTIE1y9967CTT8Wnbpj5bJ8QAIeEnFlU
Gk759vaA+YgA+Bbc5LMMKm5TjFxk/1cAh1qPsUSTVLyw9qZJ/aAATgW8vPhy
jIo35q2fONkvANLndZ8ruFQcbWaTcb5HAF1xRa8sh6jYwcDM4+ovARRdPF/2
Z4CKG6YvMuM7BKAkOpn1qYeKGaeb5WPbBODkzFty8ycVc/3XNaQ2C2CKa577
oZuKwUfPJbdBAOaupn/Z9VT8aSZuwrleAP92Lvxd20DFpTvnSlXVCkC/mFXP
a6XidrEXcT+/CCBkpdK02G8qHp2jsGa8UgCOiVGe70qoWP9DobZRhQASdT9/
U62kYmzjmkgtE8DVHwFuN4GKLxbEKCgVC6CEfcbYL4+KtRRyvXQKBJAe8p/+
hSIqzjXtz1z6gai/rm/x51wqVmjJbt/9XgCb7n4wH8mk4u03q5VO5BDxffPi
0p5SccwBcA16JYAWvZ7boalU3B+2xkT8JVGvpOOc84Qd3NixSc8FcPKDufmu
l4QemZJV79MFsIBhc27Jcyqmfg9vanwigMKGVJNraVRcV1DC5T4k4lvEWd9P
oGK1pMGhiRQBxNMUA42TiPObatulkgXQ6RiUZX6Vis/ZPm3UTBAA/WZpZmkI
FV/axC+eiRXAtRHK5eMRVHwzcGWqJcFn9gcnH/Ci4mG7R5e8bwpgcJfKSrhF
xe8KBtbcvS6AVNoq9wVRVMyh2wcJIgTwS1fCsuwiFUec2tSdT7BYxNLvuUFU
XG8d6Np5lfDPf0W6do6K0y638chXBLB3QvLK4gtE/v17nNUCiPnLffjwqCcV
f/c7qSlJcPWaYpL+aSpe2jBYb3lRAHfgd9qEMxXP062Q8j8vgEfrLmSEulKx
WX6rTaqHAM7tvL+325aKN9wT/lIm+MT2DnG2PRW7rrN1qz0rgJ7118m11lQs
8Xpp5LSLAPIuzdEJIuwXGv19V50QwKullxprifNUw+idJs4CmOcxV9J2L9HP
7bqnLJ0EEDuP4dq0g4qfGWarBh0SwKKFxaNihP/GufeHs+wEcDZbeZGiGRXf
k90Y4H6Q0Pe/2CXV24h+XvG58stGAB5x3mUvN1OxvOxP7jwrAfwMvvjCxYiK
NQus/beaC4AR7J9hsIaKFa3oZx/vEUCT7zWPNC0qfj5y5ZPnLuJ9GIjpvv6P
ilMYrdJPTQQgL6kYdJXw130gs64NC+Dv0nyBpTIVJ+etnNuxTQBGsfrcdyuo
OGpprInkVgG0qW/wYC+k4oxIlXXGhsQ8+/0b2iBJxSxpRelLGwXQN6G78uAc
Kl5l+23PMl1if+iIpCiKxPuZtCzP0RFA6e/OmCAivlYA1WtIQwDBT9WGBQpU
7MjUHl6lLoD/uEWnBsnEPOucWOW6htArKG+/PZ2KC5rYx46oCkDux+OYgvlU
7HzcNS1plQDsHNLXnxZS8FrHuJ6W/wQQsIX905VK6MtxCitZIgDNxpshldMU
XNH3eFCG4M2xB0I+kqjYRDL0n6WiAFrTFmr3EvEo1cG5t2QF8OPxbLTdKAWf
fGl3XEmamPeENLXd/yhYJum8f/0CAeDDyd+Deig4fGkhfYEk8f6ic6jJIxQ8
304hxmqOAB5YuUX8GqLgykhSRxxNAKvI9+43d1LwjBn3TTDBUYHnbx7rpmAf
E5UVrSRiPvtQruAXBafZLNBQEvDh4yrT/otdFHx/yk7HicOH2l2pV8NqKHhn
UFTg2CwfEvfSl56oo+DmI0956Ww+7FhHEo4UU/DRGO/iESYfUpr/kTQ+U/A+
6WBj3XE+NHh3OtdWUvB+xtC1E2N8KK/OviJTSsEvCzaWBg7zQZ/xcUyyloL7
7V2Fnwb5cD995su5TxQ8J9Ndd0E/H+KX7ezrq6LgXTcyuvv6+HA7RBTe8paI
/0RjvWMPH7JTl+rNvKFg69nBRZm/+OC8TuWX9AsKvvnpwdfJNj4sObU+WKeA
gl85tVw808qHBMFTRVYaBbtV+LjhFj40D4z0LXpPwe7zor7f+s6HY70N3qxX
FCx/ZXhN9zc+WJrnrHmQTMED81/smKkh7n8UHhiVQMEPl9dizWo+qE/696am
UHAdVXVv8Gc+RLlkBX68ScECurFCYzkf0HVWCy2Wgs+d9zS8BXyYv/1ryaJo
Cv4SSm9SLuWDmX+L3vBtCl6tUG/hV8SHdxGTV7SDKXja/1xh7QdC/wuXNcqv
UvCsc4y5xns+MEkuBx4EULDfpO2fFbl8aFdpq2F5EOezjIUX3/DB9PfB52ae
FGwcUtZal8UH888XpTZdoOAMlyDvlud8gNo3NdJnKHjNMt+HqwmW3LtCvYWw
z/QIV15J54Osd3p4nBcxbxLM+LYnfFjeLV8ad4qCl3m1p4Q95MO+TPsiPycK
9j1FqdQheHOn4/UUBwq+05ndHZPMh5PJL/862FCww53yD/8S+HAnwbf3xT4K
NlvzNMA0jg8GctSbGW4U/C5pb+Vmgm+OWD6xsaJgf5oBN+0WH1b81dsmf4CC
TR/WnSRH8+FgfKv78BYKNg89fuNYJB8uzU0a6tSjYNfOlJ+ca3xobDPWe21M
wZESmvfLwvjgpOcXXm9AcM+OkytD+HAuTsEsbAcFx5pXK4Zd5sMBlcnrD3dR
cNW+E6NlgXy4UOqzPWgTkY/oT/iAPx9azN6Gnd9MwVJ7n3fsusAHD2qN3nt1
Cu74Zjn0ypsPbGdOpo4WBf91kS6/7UXMn2Xs2Ya1FHyb0dYj40H0y65un9ly
Yv6142/5nSX6Y/9cSVKRmF9lV5VuFz4c9dNcZalKweTDASddTvFhjd+pC2sX
UbDXvApv0xN8sFDeZxSuScGsEq+MbCc+7Gk5/Fee4Dht1m2Fw4SeW35vHpaj
4Ozln2pNHPmwdFXG4ReSFJwVJX4sxJ6oX1mBmyBLwUOHtg8O2/Lhu7j8Nycx
Cp7Q2bP/4H4+DBepnApbQOwrvGZU3ZLQ9zHzkLSIjCPX13pXWPChqlwj5y2V
gh+bOVzU2sOHiC633y/IFOy5LFfr4U5iPt2DtZ6OkHHlC1bRIhM+2NT+Me9k
kvFibYdv83bwYa2qW3sAj4xzrixfFoj4sHsqqW4v4X9E+bzViBEfHutPGYb8
JeNFrrc1pAz5oBS01rCgn4zvemw2OLyJmF/Pp7fe9JCxscp3UZ0eMQ8J9MTu
UTLubNIJxDp8GFB/eWPHHzJe73HRcJ4moa9m19OCZjIu4KS15WrwYe6tbXdy
ash4nrXB4Bp1PrhnaB+4107GK9T++5GiSszLDoVVCT/IuMI85MJCZT4INH/V
mxL+NlabWxYQLH+AJzr9mYyzhv3ZUcv5oBKWJHWDsKu3maqSlhL7b/HlII1y
Mq5eP77RfxGhT9C/NdXFZPx3YShrCcHhD9qvTX0g4zPvPrEZcsT70S1Wi8kl
41dhxfFnZfgw4VGcsuc1Gavt3Nr3Zz4f3Bw23+3II+OLqSvTtQg+vGfymuAl
GTeuUZU8JsEH+yLDu4lvyFjjPmvglxgfhmr0k3a+IOPH414p9lQ+hNwq6/qU
SsaO4lnZeyh8eL6ljrvqMRlPW2qRW0U8WFbcRF77jIylTAa32/J5MGqT5nmN
YK8UI+3mWR7s5BwfGHpExoI365a5z/DgedmF7V9jyPi4SjPHms0Dp8isZ+V3
yPj19tNezUwexKnV6FbcJeqVjyq3HefBRWfH7q4wMnaY/+jfvVEe1CWxf4cR
XBJFg9ZhHlhZuH6MJbh5lcM9h788cJGbOSKbTMb+Rq6Lu/p5cC5Mc1/TNTKO
7ZUW+9rHg/IGCf8RHzJWaH544XgvD5b/DPD2uEzk+2j88mAnD5rFv2j+CSBj
a9W3h8/95IGr5ncV8RAy3kJ95kZq48F0nHCb5Gky7j3LHJz8wYMgl72e+y+Q
cdNN5q6AJh48/pzuyvQi5vNroy2lgQe93yWUjZ2J+dRJXIC/8cDkpLNXymEy
jhssM4iu5YH4OSf1EjsyDtnFqpT7ygMD9gcjPW8ivk+46uNPPJDJH03YQfDi
lnX/rpXz4FHNGd6vfWT8uatYR53gSGRLvU7c/7E1feGHEh5s3LTuRusBMma2
Jz0wLuJBctl8tSuWZCxXVzHS8oEHtkVqSb+3kzF6x/zdQHCUI+kNm7gvs29K
eCSXB+baRXI+BNO+LK0YfcODBsou9WBdMp5lbHe4/IoHd8bdXX5uJuObxnXS
6gQvjFn9QG0jGYcnTt6TfMEDxqa63GxjMi7cO/XsYQYPCt7dbS8n7PaSQ0e1
0nhwuZk61aFOxqpVFievpfLgL7Uq3m8V0b/LYf/KHxH6VYzdX7iajI/tv6R4
4AEPAvspBlbKZJxteXbRUCIPnK88xbWEvai54c3QPR50xvs3r1xExtrfl5cG
3eVBiUB6zGIxGT+sUd0oG8uD12fKvnIIvqF+2OrFTeL+Sq5HvAIZh4beINnG
8CC1Kd1wWpKMT67dvAXf4IG1TVZ9kiIZd+m9rW27xoOPIfGpj6lEvDa1dV5h
PFBmu4kauCQslN5s8fkqDzaI02IDRCT8g5GuMTeEB4q/7Tm2UsR5twBR2mUe
eLjvSnMgzs9GlvlsvcSDQxv7Pi8UkPDNOdkxW/14IOVzNN+NQcIGqYUf2i/w
ICLqfXkCh4R377zzwPc8D/LUj3sLpkhY3MZ3n4wncX/izCqvCRJ2mf8pr/gc
D37pvJqJ+U3Cs3efpr12I/rZ533xZB0JK/gZfTI/w4Otmn+eHuskYWV2zLWR
kzx4uY8b3z1MwmpvvMHYmQddfZ1bu9pIOHDRU/no4zwIkDkdv7OVhO9z+0zW
HeXB2gP16mZEPFdrY/zNkQdzSOd/hn4n4QWbi5402PFg6N3e88xqEs7ZafTL
nWDr4Bal+d9ImLY3d7u0LQ883yqUORWS8LIwPbNcKx68YCZ63qgg4fyoXKsT
FjxIUwwVGhSTsKlmvKIdwcqaX6/5dJBw3+Fz13i7eWDTZFSxoYaE/6mFwpOd
PHCULfeubSHhLcHh93bu4MGrJ6uKdepJOLg1vEpgzIOVnbWWnGwSPnlC2WAM
8eDwm+i8U5kknHlr5YW7W3hwRID791eR8Ch/6eUthsT85hglVBL5nN5vs+Dx
Jh4Yxm6ToDwh4V/KI8sHNvLg+JZscdJrEg4RWxRzawMP2l4rmeQS9Y5URd/d
pMUDLTxVG/CQhMurQ6Z3avJgdsK37EsCMR9BZSf71/FAssZBZzlxn91wzvdb
ajzo2LW2XDqDhPfs/kw1Wk3sL68+P6vbJHzqhvN1tjIP5FMmHx29QcKGgxJN
f1fyQEG488LOxyTsq9PukvAfD7bYLPjj+oCEz7PM7+1YQrwne+uYE0S8N3dP
wMvFxHvJjNyYdJmEp7qyoycVif0ZJyE7RfCAqsaSNDke+M/9LzPWlYT7GwSe
1jLE/LOyfpdeJOGFnqLbLgt4UFircSzQnYRLz508SpUi9qdvcgnXm5jHI6Ey
eRLEPqHrZAivkDCEvT5yWpwHv/eXOaBLJFzLLZ9Uo/PA/Q7l+wknEnZ/Neuu
RONB2eN1IjXi/L3ZaoV6Eg8OHotRrnQk4Y1vVoSFCrgQfFjfa8chEl6xx6yH
yeWCc33wTK8tCe9Y6R9pQHCVn0zvrtMkHP1fyb6xaS7kF4dzVp4i4aBFQdlP
WVzY+1qivpLglX5GFuUMLmjl1q2TMSXhmgvx9Y4Ebww8cMTSmoQ1Ch9fWzjG
BYVTP7e9tCHhzeNupNohLrzY7FYj2E/CfwMc9RIHuXDhxqe2uk2EXskvpMMJ
frJg4/tbO0k4IUDm99Z+LuyRPNx8x5iEPeac3j3bwyW+b6avMwmOqdjvndvJ
hX9/PThjhiTsRPeK8SFY6qr3u+NaJGxNf6bp+ZMLXau/cR1WkPDx/wRZ61q5
MOfASXqIMglfQkal/5q4cI0fWeu8ioRvHLCzOEhw8qzhB3OCr8YN3s5sIOJp
Zkms1iHqWzDLPvmNCyf8Ni80J+7XqO1XUqkm6r0aUGClQsLdo5bh6CsXwg80
Mm7LE/vJ931z/2cumFxevPiTDAmvW1S3J72CCwvajwUeo5Hwdak9B04BFzQF
2/npHBHSSUwRapZywXR1u8eVuSTsfyZo2ZpiLrwpO13cIUHCY4sT/IcKuHBl
1sRtL8ELdjbdeZXHhc9z1vXES5NwwIvn1SrvubDv15nweJ4IDZ/zNfJ6x4Wj
cz35aiRiXzRmpem94cKZ5UsFZ4nz8uerH3CyuOBEvRN1gy1CO5fEdK14yYVd
/8p+u/8UoXelo1bwnAsLzX7s7+wVoXAV/8SIDC58SBH++E7U07kvINk8jbAr
zNRggQiV5bpvUH7ChWU8H0QuE6G3806vl3tM5C+GFu4jk7D5vi0BnQ+4wPPI
dsuZFCEng2D7jCQu6EhYjIcWitDnP6Fl6+5xIWlR0vT2NBE6vGAZ0yOBC+fV
PxctLhahSKNXiw3juDB5qNKi+LoIJbvM5VNvc6EtofvRyTci5Ju5IGRzDJH/
fg+6720Rslrf6d4QzQX+YOIRh7siVJLJSHoQxYXR/OPsz7EiJHNfZH0mgkv8
v7vOVkSIkLqNi6tlKBfIAUoiO08Rykv59Hkjwfv1G/Os/UXowM25X6jBXHgW
0vP77H0Ryoy+FNIUyIX3PGkPrwIRGg2d+JLqz4W+hqxM9UoRGgr763uWYFhc
dkD/gAiJrxX74n2BC8cGHsfXnRUh0pkXNsbnuZCn9/X2UnsRKkw6kSjryQXd
OpwQvlmENo2RH0R7EP2J0JnPwyJkcE/nzIAbFwyZy6/tlBAhVdebE/lnuNBu
tfP78y0i1NYQTo0+xYXlnltTb68TIdlZ6tC7k1zwU3uhfPk/EfK5fbXuqDMX
Gk/v3HOIuJ9tlKas68SFbe+NZ34S+WWdwFpzDhP9ux777dIyEUoZ/aLR68iF
/laqvypNhF46R1d12XOhsOs/dqmCCAlTvi18f4ALacfibgr5QmS91mT4hjUX
IiLu3fxD+BfGfboou5+wX5nrVTUlRHyLdRedLblAUfwYc0RWhBrqm2I2m3Oh
8lWYVpe0CNXN5BnL7ib2Td/++fmKIpSb97jY3IwLFtPK9rQuIWr5i16NmnJB
L8UvYrOcCAVbdDyuMuaCRnm/+LSKCG05dG9nKuLCWMmjj219QlQfJzkbvZUL
NvoGl23KhejS3vGLl7cQ9e28kZPxRYiOHe13sDfkwoPhhdsOTxL5mZOq9PSJ
97sr5eWyIiG6VVC7slGXC6usjMr+yxKiy976f2QIjv7uucG0QoiOTq+IntAi
3l9o25Nf8UIkfzi1v249F57r1B1b4CNEHoMvNyxV50LP7pXt228T8XVOfHq1
lgul9pfo/plC5LZ208EYVWL+iqwLEoaFaLF6p+c5ZaI/Gj7HLpcI0dBouLL7
Ci5ILtui2OshREwVmc0WBHc7xrtreglRwJ6n0ZrLuFC22PPTVLAQVbaa3JRW
IubrQ5OiSqQQVRk0ybMUuJDQL7VBz16IJm9uH6skeLo2UzuWYH3SuEWrLBc+
+p7P7dMWotT6cMkiaS5Y7ku8stBfiOyS1gY8mk+8x8ZNn8NvCVHpkR9RKwge
s8p7+ggLUe7yn+5hElyQGYnPu6kpRNe/Kki7inNhfu9F24ENQrT93ISBJY0L
6uldvPm7hKjb5R41jErst5LuN7vXCpHMUOt8fTIXWlJyXm7YJ0SfVw2fWSbk
gJrv3XP+RL3lQTe96TwO9Nsens+RE6L1zZ0aIxwOrKUfF2uTFaKEX2PCsRkO
tKVqRGavEqK7G44Ztk1xgPerZl/XXiG6dmDlbBmTA/e+2txL0BKi+1PK8g4M
DmzIO/UwjCFAx9ovnsga54BNz8G5s2uI+s9nW98b4QA5Y86HL8R9kcd5Y1f/
cWDb7R2v16kQ9frFvfs2yIEj60OqxDsEqE2vRNJjgAPWbw4XurYJUE734jbH
3xxgv2neLM8SoKKiIJVdPRzgKA92uDwXoBKTQyLTLiLfIPf2DTUCFBZIWqbf
yYGG7NE7W38J0I4t/yWp/ORAe7+r4oCqEPkE9pTItnLgdWUJy6xJgNKcS6Y+
NXNAtIUbUvdagJLEv5+iEpxB/k927QsBitIfymc1EHbDI5rxaQLUFVQV/ecb
B1TvLo66Vi1ARh3UmN01HDCN+5RBuytA2grWc1urOZCTsVk3o1OAxKQN5nyt
4kAaRalxbEyAFOOscooqOWDu0PnsEWEfSI4obS7jgFBG+VbSBQH6YOTwM5tg
nf1mf5IiBIimsSwrtYQDDC2SHf+VAClFuQgSijiQ9ervm04bAQLvyZkb+RzY
ynq44GegAPk6ZEScIPi11/muGycFyONKY8dsNgfMnpH/kHYJ0Mfw47Xx6Rzi
+7KtWKhN5Ksrt1bvAQdq16fZXFlC6HvtBLkjlgOHx6M31pAFyDVmxCIiigMd
b52TxQb5iOtvM0c/mAMvvjTFX//GR/23LNRHL3Bg6IL5ozVFfFRJS8x+do4D
1XN9d2s94iOx0ZnoMyc4cMBr/NCcSMJfcQdoOnIgb0Bj0RUPPkqgHdzOteJA
vsKK2INH+Cj9UPjyWjMOVN443xtoxEfe5t3rU7dx4MOGF8eeqfDR5tC2i5c3
ciD2cEDU/Hl8pLPOb+bweg7IrX5fHcnmoT+Z9c+NlTlQr9YyozvAQ7KenHAN
JQ5c8SprKi7noTrSsmvLZDig2UCuMcoh+POZzIVzOFDabqK54S4PLRXK90qK
ZsE7Zuvw+0vEfS9Oa0hOz4J+nOUPznEeuuvzMkp6bBYufjfbedKSh+iv1ESL
/8wCOUJcYVCbhwLsLU+p/ZqFwY/rH95fwUPitte+GjXNgv3PoKCPVB6qXYKV
batnIfjMzZd7hrhI333W07tsFtqMSttfNnLRFR29F/H5sxDtfvOjfCEXHXG9
Wl30ehaOzo9NlX3KRaJFfrWDGbPgv8qpJP8aF6nq5b1QfDgLQ0M97257cVHU
jT9HLe7Owq3J5qWlNly0nmc8GxlN3De9+SB1GxdZK5/Z+yWUqCeM81hOnYtO
nM4+NS9gFlbXaP5evpSLHu/s3m7rPQuqQWJjz4QcpFJS35F6ZhasImS13w1y
UKTOoXVTTrPwuIShql3LQYnOZzT32s3ClXRWm9obDrI/0N+duW8WFrA5t2oe
c9D6HeUG4jtnId+68WhfJMFRIt1zW2dBfcPmT6vcOcjV5VvvD71ZuOP2oLDu
CAcFDv+UM1k/CwO2/9ZoYQ6aEPPq+qA8CwklR0Z/KHNQCztro+aSWagquP11
RoaDTpe+W/Ry4Sw8WFM8ZM2aRWEqb6+qS8wC29lKjtk7izYn/XJ7Qyb0qUE7
62tmUeJqj6ZNnBkoT7i+dHXRLLp18lVOFWMGumRG+oszZtEi1z6yw78ZMHyz
sHlt6CyKV1/bPNEzA7Fu7NNr3WbRDtPt/BttM9CUeySac2gWpX84ckO9YQYe
rIJDHVtnUe/goH991QxsX35d+tq6WTTP3bzyYikRr2nDDG3OLNIk0U8pf5gB
myu8LX/ZMyjgzC2HluwZiNugY5z2ewZlermnXM+YgYpbcXnfa2aQa5vG2h0P
Z0B5rNV1+t0MWrXdmUdKmAGpTTu6ndJmUOradKnKmBnIDD9+ZmvUDEpvnPW8
Hj4D49rPar76z6DD9nqzNpdnwM9q29GKQzNI/tD596t8Z+CrzIYcJeMZJKl2
+gnbbQa2LH2QfGn1DCI9qcv/dmIGDn9/tPW+3Az6onZ6+tmhGTh92U4iiTKD
Fj/h2UXazIDJEmau1dA0ctvn0H527wxofjulNFM7jWZ+2vpY75gBmbm7q1s+
TKNfhtUq24yI/H659/33bBply2RwNHRnoPvwpGNx7DTSPP+qduW6GdCmbVwQ
4DeNPvB+P1usTNS7r+X2Wddp9PvslhvyS2bASYeqOWs1jT7feuchLzsDDzuZ
c6/oT6PvW0z3L543A/P2vPi2WmEaNZhwNVZSZ0Cs1Ne7ij6NaKe6SBq8aci/
E5uZOcFGJ7aRqrawpsFhSeieyF42GtoVcMlqZBoeXcksLq8hWLBS7Uz/NATZ
uiW3vGIj7/zHr8J+TcNO82ftZ+LZKOpFl+zT5mnwfv2qfkkEG41tlHCsqp0G
Eb3xz56zbPTlsEPgWOU0vDR5Z/PTkY2evaX5LiqeBvU/g+sMjdnoidVebPZ+
Gra1v5ToVmWjoGbvzkuvpiEg3XvDUzk2kjarMMlJn4YkuyfL5gim0MMVMReG
U6ZhWXOrb3L/FLrgEhOoljANmfkPpjk1U+jwsMmGszenod6bErI3fwqNmkZk
vomYBrWOeUp6GVNIX+1dy2zQNPQlvvAWvzuFdl/YWGh6cRpuKAgDz/lOobVb
rljd85gGdnx2g9wR4vwrUuKwyzQM+ReYpxlPoQEp/evGTtPQe7tsRkZjCo1/
SFF+ZDcN7pwAzWWKUwgE+c4Cy2mou2+UKEadQgtd1W2O7ZqGPJrjk45+Fjqp
a9pYhaehc/fUIfUmFtrgUjykbTgN11rWpc+WstDSeWuSH+lMA6Z2lX7OZyE3
3dXfFqgT9efM11t/l4U6mHvehK+ahhDnDr3CyyzkImOwXKA0DSlzXD2mTrBQ
3cbqWX/ZaaBWrjrVZslCWc62/rPzpsG3e7HqemMWavlEPxRImwb5Wq3yy+tZ
aJu8sJMsYIOcnOikuTwLKS188zGazYaPPTvwE94kcrgorrt4nA1rD5tEbPw9
idpIJaSXg2wwDe1d1Vw3iaKKYo5t62HDfsujZVA0ieRaPKVb29iweJ9Wq0Lm
JBqYYO71/s6Ga2nqH8diJtGUQSRjQTUb3M9dTR30mkQa7L5fb8vZoLfEdVWO
8yRK2GKy266IDfsyBG/4ppPo4QWLGdE7Ntxr9J93VWcS9c1ZsPJVFhvspzXi
fVQm0bkh14hD6WwoyGr1Np5D2JciJ6mHbHj0XS//2yQTtd7Pcf+UwIZbpeIK
J3uZqGOf50jQLTY8fqQ3R6aBiYzs7n3YHMmGJVp7/nv6mon4rZezucFsIMme
djK9y0RaSjESpf5seLNmNVU7holOOF27Ge7NhtqrJ51e+jCRQ0yG176zbMhz
XLCad5yJrBaN+Cw5wYbs2z3WMmZM9Kr6eOPIITbY9owncnWY6Nr33bvBlg3b
vc+qFK1gon1KwfL3LNjAGu3vVKUw0VuZkGnPnWz4+7R6tSyHgSgy3NUWiA1m
YYXWxV0M9CO+NlRjExtmvrZssq5hoIvZkqPSOmzYKHXR6+cHBoo9svrBzFo2
/PDyS3ybykDnQjX2961iQ5Tb5djhSAYa0HMyq1/CBiPrB3ZFHgyU2iOFSuWI
fgfn/NVxYKDXs7u8385nQ5LNi9igHQx0RvTw8TMxNjiSZzXjVRkoUmKMkiqa
ApkfZSLxhQykWJ4d8HB2Ctb4HynaR2Ogyqu3B1OYU1CQ9CJN89cEam/UCH48
PAUGlNuJne8m0ODxbLGM/ikIa5u54nVnAtkIL+dld05B8PVcdU/HCRTdwrMo
/EHcb1sYtWnTBPpgeG7O1/opOFFbPNUiMYHSXE4/+/llCnYd8Umjd48jlwDq
ifGyKUg5uv/V1KtxJNolK6QXTUF14CpJp0fjSJkfkrMidwqidmmxTpweR3Pr
/Ry3vZqCbdo/LUb0x9HJCPvOoxlTUGFwcU8CfRzpttS6hz6aAr9DVTekR8dQ
3ZsNTc8TpyC5wls378MYOugrsb3pzhTYHpR46xc/hj7qjgYJr0+BVZns2vtu
Y0hfV71MI2wKJNXUa4fWjaEq/YRap8tToKVVoDkoGEX6WbZtdy9Mwed9drkB
E6No+0OvZ988pmD14lVz5CtGkXHPwHnxM1MgoUTbtjp8FGkfi1YyPU7o68tY
u8p9FCXdcQuOcJyCjtNPxAz3jKIb9Tvav9pMQUksdcxXchQ5JKYPSVlMwcy7
izvshkdQrNnKYbudRL0LN786UjWCOreGPHqKpiA09mO6UdAISpZZt3VyE6HX
z5+XNh8aQS8fLYvesWEKTt0SyzTUG0FrWYmlieumwL7edA1VbgR94M8UjKtM
Qe1bG9VAyggavVt3aNd/U8T/8ZXbpPJhdHFEqStdcQrqc/kU05vDSG/QiUKT
mYJXFdzhOy7DaDdcILtITEHsR27qJoNhxAmTflJDnYKJvYYH3y8fRlq5vbIb
BCwYtiu/9VB+GO1fVb8qZZoFy0x+FMR3DCFm/THKXAYL+gzvHhFPHUL2s7n+
/kMsOBAvO3D86hDSsF3zcfg3C7b5zy/NcR5CRcH5WU6dLJjYdX/O841D6KtG
7Pq2Hyx4GaCXP3/OEKLItp/f38ACO70tWw91/0NPjqua1n9lwa3VlN8rMv6h
BXL+7RYVLBjL6dl1MvQfuhmezGr4yILCg4PaM/v/If11TrW2eSyIDH78AFQJ
u/YX1c7XLLhclhYpJ/YPdZdf2ezynAXZ/eGmdWN/0eqgvLrJVBYo7tMs1Xr+
FzEDmXKhD1hwpy9kVhDzF3WFfZmUTWCBgkHPSmnvv+hELnf381ssUKpoPG68
9S8ijbXuQ1EsWDxnQ8NF6b/oB5te3X6VBattGNYu3YMoQiV71DeQBcsVettD
Pw0ig/DMq7IXWLBC1qHYP30QHZJnfnzvwYL3tqdfyVwfROdb7p2wP8MC7aNn
2SvsBxH7idcr4XEWfKy1vyi/ZhDdXBd96dkhFlB/NxraCAdQp/KK19YHWJA2
9PaLduMAknjQEESyZMGRd2p1qtkDSI2/+G3OLhasvZh+/EzgAKoouhR4wpgF
80uO3ZZ0GUA/ZB5lLNrCgt3UxnuvjQeQ1rxO5+8bWRA1Vq+VQBtAjGMyl29o
scC6Nyh1z48/KG3QXcVsLQtOK1dE3yn9g+IiBCpiyiwAuT6duOQ/aIlUbc6X
pSz4d0A4MXH0D5K+7JUVrcCCcy4lM1XoDxoxyJ3dL82CpyoFbVEL/yDHUZda
JQlCzznp69nMfkR+MndsgMoCy2NrYkPb+9E5/z13cgWTkLJCeFQjox/NJLdc
CZuZhBFXr76N/v2ouXXDyAHmJHDc1X9GmfWjQpWtj9VHJsFmR0T11RX9aEDX
sY48MAk6+dfPZop+I0p4vMOv7kmYb9WfX1/zG3V/WaqW3z4Jny9mrqxJ+42g
XdUtoWkS/iS8/HTvym8U4zE7euHbJMxxTKnKNfuNgooe9dhXTYL3F82AtWq/
UTyOmb+tbBKqg7YXPVryGy0uevl8ddEk1FrZRKb39iEdzaTABe8nIeCtfGpV
eR8iSS0p4GVPwp5i/fL2tD4U8YCvNvxsEtRTKprYYX1IS6tX1JE6CWbZq+SH
t/Uhg1/WK+sfTEJyOj/+l1ofyvWTOF+ZMAlHnKszXCZ6kYX0ReWPtwmeNye8
pLkX3aqoJuVdnwTpqIudqh97ke/0fqO3YZNQnrNH2tGrF0nNd3/0JmgS7mZ/
ZhjZ9qJ/syaHcvwmoTOFulRBrxcFLXbemus9CdF1nSqpC3tR1eJvFwrcJgGb
VJn9bO9B+rIbv8OpSdDOmrU4EN6DKu+FBlU7TYLycnNb5YM9yPNomfMPh0nw
OkLrjm7pRsa3V57qt5kEv7dal496dSPOX/s8lsUkiGR/Xl7k3o2ysoKXi+2a
hBzzdolxzW50ZUK1Rcl4ElQ1XuumPepCS6ruPNbZMgmBEpl6VSu60IUv69/t
0Z+EsoL2Y0odncjk7qn2U9pEP71al98L6EQOPteNw9QnoUF+/1CLVyfy2TWn
NU1lElJztuW6LutEp238/T/9Nwlff5tASNMv4ntu2uHfIkL/8KZ7JUm/UGKj
lZmU7CRsOLmMdYb8C337F+alP38StpZSpX3aOtDHBdfSjolPglX31x0qJR3o
r9mG+TfJRL+eVHjbOXegpnuZQR95TGAlzpM5x/6JzD0fKo+ymVD0PbS+Mfsn
8hc//O0/BhOeId/Op34/Ub375Wc2w0z4ET/p6mb3E1mM/7l/4w8TlIzl9hdy
2lH61JOYym4mFO79HHHWrR1lmim9ErYzwblbJbRWuR09lZipMmpmQvW180/O
/W1Dz+dclQysY8LeNsvaxPttKKYsfE/xFybkjV3Z17+nDfWqr88RlTPBJEbp
6bBkGzo16DrPtJgJFwro605+b0W6xruiYz4Q+WltbxV3bEVRe+YptOYw4er5
r0uW72hF33SXxK3MYgJTnjKY8O8H2rbERtMzgwmzRq8P+nj/QHPHqYWlj4l6
izxImrI/kFbE0DHp+0wo5z82Ik20oLMrA6ZO3GVCxxblgYT2FnQ52Dqt8BYT
dlr/3pR9lmDufEOZ60w42R9X+JPcgp46qv89G8YEoC7IdKpqRgWdpwOrgphg
Wf2HfimmGXUErlZR8WeCaNcz2Q/LmtHJTQpfw84T8a835e6e04yOL5beN3CO
CaR2+qxuRhMq0DL5s+s0E27kdql07m9CeTN1Dq+PE/k9yx4RIzWhKwplnfKH
maBbtfR6wK1GVLTGcUvwQSaEVp6JXXi5Ee2MvpM5bMUEubyoiHr1RlT6uWrY
bi8TRp6qGu779x39U2zW/2LKhAd3WS39Md/R6cItjpswEzbtdbwiefQ78b/w
MTRrMxOG83f/kNr+HV0b8khcsZEJQSfXvhwLaEDnPiYEJ2oxoSsQz70wVI/k
SMVnpNWZ4F1kYia7oB41m5avilZhwujGW8d+NNShN9dlf4kvZ8IO3YnRl/Q6
tMA27/i1xUxIT3i/tfHoNxS4bqZfTI4Jft422va5tSj1qFDnuhQTWj54XHq2
vRbtXiX0nz+XCa4nz9u/m65BjPuuT+KpRL8tVMZ7HGpQiPiP20uEDOhLSPRy
y6xG9wbNfDNmGeD1/F/Rbt1q1HBv6386LAZcs2xP/jT8FVU/flJUOsYAWih9
0c/JLyjLV0pp3z8GxD63m20cq0LsalvXnt8MaPxDzUt8WoVi2Bsune9iAPL0
aW9fXIW8+MQfTjsDfucnuO0x+YxGBl7qPGpiwKbn0+bO/z6hdvWiNv06Bmge
xObtrp/Q52wnq8YvDCgam2k88bQSrfeID3OvYEDb02HIkq5ED23h4bwSBsQ8
fLDuy8EKlFSv6JWVz4CNz5rYa46Vo7+3h1Ut3jHgR7BaWJpuOaJK3YxnvGLA
hsRdPtBehi4Na/9OeMYAA9+ek/0zgEx8zP9sSWOAxGG3/gMzpYjnwP48kMKA
e1c0ap+cLEUPA2087yQy4GD+pvsRO0qQ6rzXX7fEMWB/U1fHa+ZHpLqQKRiO
YYDbP4uq5PtF6I3mn977kQy4rLRasut6IZJusHtoHsoA44NhkhXzC1BPlS6d
FMQAkdlzJ+2LH9AzCQ2TPD8GxAew7i39locaLuxdf+48A7ZZTiadWv4eHUtX
G1JxZ8DiCb2IlZdz0S7zUfOe0wxw3eb7KMbpHZJpkgt74MyA2wt2q5E13qL3
s2q+DkcY0L7ve/mGizmodKJuzmJ7BvjcC0zTyXmFpK45nOuwZgCpV+ZJe3IW
mmtl7P3QgtA/gOE5cfQFeqZfaey8iwG2H0uNwk5kIDT/fK7aDgbMejmX9N7L
QCozHuOMrQworJU5lUx5ivgdHlVFmxggdfq78sZ7qShE38/lmi4DDs1d47Zw
/0N0sv1Qqo0mUd/b0W6qwn2UVCCetmotA2pmPrhIqsQjpatH9rOUGRD92+tG
isdNhFyPJH3+jwE/S5FevfsNlPirJjV5MQPKVyaVpc+9gv5pVWFPOQasWRw3
36PfFT1Inn28cwHhPwIiw3me0F/5JG65BBHvbKSFaM8lkK2x2MGlMYBhqVQn
8osEQ0qhRLZoAuJqNh+dvR0LWxTCxVzZE2Dx/unqpQkJsMjU1lxtZALiN4vL
bzRIAUsoej3cOwErJ9k0c/sUSLCyDc1pnQBHjs76nq+PgDzPy+PStwlwyX91
KfhtGvge8/tiWjEB2Zet7J2WpYNY0pSefMEEnEu4a3/z2zNYJPbfvH/ZExBl
Tbd5IXoBrq0FzJKnE/BE/zUrIiILPgd+3ZKYPAEpt2pmUpVeQ+cH87s+tyfg
TN4T7QD7HDhnq2BuEzEBXjlrNtmn5ID8WXUD/cAJGN64kfXL4R34rq9SW+o9
AbaWpwpL3+WCTreHL/30BEy0J1sO2+ZByKG8CubhCXiZvTXHZeUHWNIy6tJn
PQHPnuaktJHzQfVZz9yWXRNwkGYt5TGeD0nr3girt03A0PpF1R9nC+HR9NHx
Cj0iPkN37e9TH2FzWfc6UJ+ApmPbLszP/wiO4m7HSldMQOiN970v9hfDhf8q
ussUJuC+uNQZ93klMBAcG1AlOQFyo1dXcbpK4IFhiXgDZQKY/ZcbHy0vgy+M
wvaO2XFgLW3c3P2uDApW7U8cGh+Ha6o7/HvayoCTUpXA+zMOEw9EqP1BOdiX
Lbki/WscNjiPYNG8CmgvOpGm1jgO3oVGGS9uVIBaZNurHV/GIdx4+IetUiVc
G3GYOF4yDjsFO+xjQyqB5PnftrDccVB6UoNVJD5Bx9RN92cvxmHBo//62R8/
wf0FOxrqH4/DY4Xn1u7HP8OyyyQpTgJhf91/5YDwMzDGtQNVY8ah7D7ZxcGt
Cl6U15UfDB2H9TeYzOWSX8CJvFD3hv842Jl9fkYx/AIWRzQCyjyI89L4gVfl
FzDyXvePc3IcakkFHmbrvsI1nrea/qFxiPrgGMuUqYbzh7uiL+wfB5u7iy3s
Xarh0138N99sHIIHjaKHa6phIi5tgWDrOPy3qXrCM7UGdhsnHzDVG4dIWdaI
iFwL1QekT91RH4ery3N0C77Vwg6K563uFePwvknl4S2Fb2Cg2BqkpTgOMRtc
Bh6YfoMEsythYfPHgWpYsKLXvg5MjUr2dlDHIaIg3/RASx0k2T1U1eOOQfhI
948y5XpoeOE1dIcxBq3+628F99fD+LxiV8bgGERcYrODnBvA+rvJjHXXGNCX
bi+0+tkAkgn92wqaxyDz9uq+94e+g1yv1p0VNWNwr+xS84T3dwjeqp8UXTYG
Q6Zrdsilfgfa/WOZnA9jkDBXYJLT8R3+akycPps9BioCeqWhWSOcDv5vfffT
MSCbvLL0zmmEpzrOT2zvj0FYMI4xXNgEHfeqZevvjMHVB42dhppN8E+49fCe
yDEYXXvjuLZLE9A3dFhWB43BAcHA8YDwJkhceHbrXt8x6C1GyUBuBlFub1PD
2TGYwik/B3Y0w8XtXUftjo+B2fPh5T82NIOjfcTtPrsx8GsS2/EtqhnkHu3N
9dg3BtmX+tezppqhhRvpLzQZA/M7gRvPTjSDKYRoxBqNwY1lkqWBNi2Q1wMh
qhvGYDZnUfyxLy3QGOVUVqo2RvyvzlPwVvwBBlKdFQ7Lx2BnsIGJx/EfUD7V
d3RGfgzsokW6Nnd/gPyt3b8TJQk9ziuU5wt+wO6uRfzN1DHYHP1N4pJeKyRH
8Tm9nFGIPf/t5RWnVjjyZV30dcYorF325hzvXSv892mNQO/vKNzrkKfG5LXC
92x70e+uUbiziRNuuKAN3jrL9cS3jIJWThpzzu42EPcz9zGrHQW5JWsKpO+3
wYrXK+MF5f9XcN3xVL9f3L0XLVkNJKKUjMpIiqhIU0MyWqRFEqJEVMqqVJJ8
S7LSsJtC0vsjs2TvfafrXrL3/H1+f57XOc/7vM/7PJ/nOc8f93YjXa/c7HlB
PTaZJgZ/y+zGimUK+nN76xHBzhdx+9CNURHTkYm7DfBg25zVeNeNg7EG1hEl
DeAI3d/W/6ob1Vot8rs5Dbi0kNbzNawbF1qU+2rXNWJTnOgK7wfdkEyfw/tC
2gYLdqzYeacb3vQVlB/XG3ErfkGMmGc3ylcs+pYi1IRN9o38VuduHPPmlC7l
NWJvknJT2vlufBh86sLZ3oSJn3E7757sRqmN4r8/IU3g+bt7WJt3w2Z3bKm5
XDMMnvkraO4j653xSCsLa4ZGf91jkR3d+OW94OuZe80QlbvjxtftxmsfaXvx
mGYEXT4hVbK+Gxsb7I/W5zXj9eLk9WmrSf3y+E4Bq1og3SEv+Gw56Q9k8uO8
WrDoZ7yLz6JuZF6q3ezyvQX2geZ77ed3w3qxouj4bAsEV8W0HKV0o/V1z3He
8lY4BG9r3jnWhTqfN6/+M27F3xCfJ7q9XVj+ZeUl15hWyC01SFPv6MJtl/VX
Poq2wU849rZSaxcUBFhpCf5tSJ/J+iZf04Xkqy+XPr7ZhrWqd6JlS7qgYZfA
1fuvDYoJurxlv7qg/unUO8X6NtyUTGYsz+pCTYpzy+Id7Wjbe+C04scu6Fr0
Lk260Q4rhR8Ga993ISZssmTLj3bUv72Xrxndhf1KF2n8v+24WnX+vUF4Fx4N
y5rYraFDLeSHhunDLjR/mlfScoKO7JdOi075deHl4ke1SsfouMD4FuF6owsn
Yme6qxzooH597xF4pQuV/3ZOtL+nQ0TdeijaoQvKKUm9l7/SYTgmUJhl24X+
q3uOFnDpELofplNv2QWpVsX1bksZ2GFCWz56oAvXd8zo7yFtP3fnIzImXTB9
ZEtIazDgejR4peHWLrzQpgiec2LgaIzA9vPaXaA6c1RzvRkYOHJq6LFqF6Ln
PN6x8i0D8RXug98Vu5Ck90JpawoDK2aSA3nSXRDcIPy0speBDV9pZ5aJd6Hl
0175Tkkm5Duzyw7M6YLdKE3NV5yJPq8N7/xm+HjkEOUzqsJEwWFWbvYwHzPH
lsj1GzAhZNLmONLNx5UHi7iDF5ionblvoc3mY5Or6LyCUCZe/yn849bMh/ff
TXMVSPudjMrtr1V8HJuIcbD7woR0jWP22G8+mpxilOexmdCn7d+4LZePbGeX
j6brWHhx5JTWvUw+vj0OdeGqsEBoBTtWf+DjnlfbiowtLLRsMVqt+J6PZtvD
0c32LHwvtd56JZrE63s8uOY2C1tPlN3PCyfzhcgK1n9hoTqu3kL6ER/rdTnW
MT9ZUN5RZOHizwcz9QZTO4+F+ztTKou9+VietUnmfgMLk/Npt5Xc+fjwxGKP
mRQbGpLpb+868qGgu6RTRIkNo70Ok0w7PhzOfZzJ0GPjYSG9yOQYH9zEP2kH
TrBxKcWKk3SYD+v2jiazV2y8PLZ+veQePhqOPJQS+c4GU7yf572NjyVtV/89
SWUjuyWljLuJD4aplKfFHzYOjhavslzPR9X6IuLkCBt61t4xhav5OLT1a1yk
HAcPLYXvb5Hjg/eF7nDdgAONxOL/0hbzcUQpjNN1iQNbXrvYGhGynvilqUZ3
Oci3rU6KofGhtsaNl3KcgzqRV2mykzzcEzy250kuBx5U3nDEAA/bewLPD1Zw
IBnz5MQyPg91ipp2ep0caBtbrIli8DC77mR26PwO8t2/cuHKRh6s1ArSf6zq
wNpnzy0TK3hQf3pKIfFABzL2FGVpFfPQc/pFu/LZDvQKq9/8CR7mefCoOVc7
4OpNsTbN4CFm4KHHk48dePIj6klLGg/uv1KKS/904Nqic23O70i7VOVGeWEH
KgoCg2jRPEwknGBLDHSQc5iy/ctwMn9AxLWBNVwU0J5Yaz/i4Ufa3suPbbn4
2JIdV+bPw9ru224PrLgomXtl4pIPD2b2AxK257hQpt9LWHCVB+6+hTLuN7j4
Od57NvUSD2rCyRaiH7iQPXbSzewsD2evySlsa+EixIURPHqch8Mc4/IaLhcr
xSRHYo7wEBgd5WTex8UWS6eH+/bxcOv8otIckU7Uij9THd3Bg7af3MGOw50Q
u8dd8m4LD1dXo/PV7U7I/9ckbKXJQ1SYxK1xu05sTUwwmq/Cwzf/qIXz4zvR
wOy6AwUeCo491TLO60TU2I9516V52LPw28fqf53IU2l5qiHOg6/7Di2pqU4E
hG870z2Hh5zwuVZnhHlIdynVSJrthNff33vyFvMgefaYseNoJ8Y89+87cozs
05Pya+q9nVgf2iuuQtbN6Nr+pq+jE2E7j/c73+HhwacDizLaOiF+55Kg/Ece
Bkz0fG7XdWLhN+YyW7JPA3n+q/aVdUI2TYy3dYyHzpH/fi0tJG2ORzJniuzb
xN8oTk4n0Phq7MI6PgIa0p2/pXfiF//mns1ifISXBXvdT+1EgR38k3bw4TRN
9bR524ml4zcNrQ7wYcTRTtOJ6oSK8qSx8B0+/Od7jImGd8J69Mzf6Xw++gZ3
avMfdiJHcSBNnzx3juQFvi7y78Rw5LOOWhYfS9/tF3jvQ/IJ2eVeBz4Mjlg/
uXeV1Enf/7+LE3y03WWIODl1Qkr1XbCFchfcXz/IMjvXiW+lw9ddLLogW51y
eMvJTsyEn6XudekCw/zPklVHOyGY5dhV5N6F4jdPOKKmnTgUl+Eb8rILj+Mq
Xk0Zd8JFv/Tuy4IuzNCab3Xrd0JHRkL6GXmvae05u6tNuxP5ga0eZfO6MbQ/
YlOVWideWDck8EW6IX756PziVZ3YVqulMLCSvOf/xgsSsp24G+tVpnOCnFsC
7tKzFnWSvNVi95FzwJBMOz19QSdqfmvbp8Z1Y9XWBuILrRMj6nGtH9PIuahf
P+/LJBdz4kb0NjZ3w+iFfEH6IBe57tN7jPK7cVgpIz6riwtRKRsrmsA/fJaO
jwOLi1v8O62yov+w6uaxG0XNXAyPsqwLNf8hJN7KtbKaC5u5KS+9Tv5DTKLu
ttYSLp6opg9Zmf1DfpmlSlceF+zU3bftL/3DnpVu/IlsLnzuvZk4n/QPt3oL
80W+crEwh/J1Q+E/zJnMDldI4aJN6/Ka3sp/4FKb9Da94eLwoDXNjvUPs6/W
jxx4xYW+alTkZskeyD0v9bN/RtZju7HMVLoHm9verPZ7yEWEeROj/1QPLnzl
P4/150LbsYUrdbwHvt6XlxM+XPz3jnZv9nIPwgoDXBhXye8+G6LbY3swe59Z
JXiZi0+fm1+Y5PbgfeAMVfU8F4rueyrOFfaQ59bFHWanuIgcvZ7x8X0P9t3q
vnTDgovoLpZ/t3gvQvzcTr89wMVBo02ip8R6seHoydNVJlxcc95x6PLWXhwK
9lpLMeSi7zhVIVi5F3ZCIhOam7iYl/4s2vxYL9ZKCj09t56L8uQyhu/zXgi/
CdKMIM8xmuVBZ87rXmhGvQsvl+ciSuaFvuKfXhArL8zOkeKi27ijbCW3F+eD
JtSMxLhYe9mxTUaiD/e37T15aw4XRTMLJ14t64OXjI/zj9kOTOmxD0Uv7sMf
59btU6MdyB8dO7FmeR8s6EqLDfs6AJdFFz3l+hBT2Pj2TmcH1Mwb6CvU+vDF
OnxTEb0DTYYJoqfN+nCQP+sn2tgB1pzoJJNjfcg996zMqrIDxcIR9osv96Fv
WLbm9e8OOBlWqppf6MMFi8Ga3twOpB7/4ajs24fmiNAPht87ILTp86hkRB82
1z0yCvncgbA3auKvvvXhUbJUGSOpA0m6OUHev/oQ2bhXfFM8ec9sUuf/+tkH
1uJNex9Gkv4QzdqzNX2QCZDSZYd1oJIhPivY0IcXC5kyhg87sO9x6ZVkfh9a
5Po/RPh3IE64xKdwYT9sWcu2jPp0INTEIF9/tg92w03ultc6MFY0R/kSpR/x
HbyYjMsd+P1mgU/Q4n58t5F9texCB969jCroUezHXaszu2/bdMC65s/nc1r9
MF+/n8Gx7MDeM7dWNG7pR9eRuLUHD3WgVuzqxQ6dfqwsqT6ZubsDN2xGyl33
96MXpVuVtndgMDExMnF3P/ZO0Oc83dxBvtd0+/fa9WOTgfRNimYHeqzuqn+7
3Y/DGxKa3VQ6kLg3av7+1/1IFs1mchQ7wMzWf7woqh8jz4/2H1/WAd2j1Ov+
z/oR9LYtsFKyA6tFsmT9H/bjp7sjc++CDjxITRYs+daPtcErafm0DgQIJBvb
5Pbj75Ey5e1THFS/XT+an9ePCtqRipwhDoI1Z9oPdfajb2WAvsE/DrhumeQs
3g+xkGcOPzkcNB/4rLlmoh/Pb4v+t6ONg4TNahdocwcwN/7wzsI6DmZlLHTG
FAegu378k2k5By9uPlPRVhmAWuYludoiDnY47ztXbjAAX5fTc2wJDrp6PYIo
ewbwqWJfGj+TA9pt2zePdw6QupyQ8PzEQaiUMG/EbADFB346z0nioNa/drHp
+QFIhb/e/eI1B6yULU0KdgOwdTNuUo3kQIFy7tbbywN4KFSzGmEcKIXF7029
N4B7h3Y7WDwk+Qddlot6PoCPZ3au+ufPQXezdlbs6wE86Ch9FniTA0v3bHMm
BlA1P3VC0YPED4ji1ecMQCGEUffTmYORkoVrsn4N4IXWTvtT9hy8yb+0Ooc1
AI3eBcnTthykPLlkaDU8gHX3/7THWHMQYv67IGN6AJl6w0HGZhzcvlh8KEtw
EB2b1zE693JQTv/UrLtwEPPfJfNDjDj42jAazqAMIm5rCWOzPgcZA1cqTlEH
0Vh7bS9Lm4O55/YnaigO4setJbYh6hxEKFwwPbdqEOL8ZluD1RxIzKpefqY/
iPON88q7yTmRHjjpqmk8iJf6dF7UUg7AvhhVf2EQJR2RHw6LcaC3x+LlSvtB
+KpvPiU0l4PE4JwYmYeDoA84eGQLkP35efNDY9gguhI3b3YfZ2PBI6pUA2n/
lL7Rrj7Aho+gb+CzqEEUDm3q4/LZKGi21HJ7Pkh+j2bv37DYKBab1X2eOYj0
2rmCZ1vYWKdnrCH7axCR1pNGq2rZ6B5ud676O4i50/Gd7FI2Qs0OPSd4g+Bk
pWkmFLJRmPVo3aOuQWTNsZG7DDY+h+fFhQ0O4lOYTKd2JhsrqxXe90wPgvWm
dOnURzYeXFnaoTA5CO2MPk5BIhs9iX+8j68YIu+lX6Ghr9m42L2M1r59CMZ9
fjE2kWzo/JyyWr95CCPL/Pave8bGIUElEyXdIUSuEA6ffsjGCxGzXycNhrBV
STqzPIAN89apJUcdh6Ay96Je/C02BPh/OyNIO+2xpLXndTaqFSi5A7eG8D3y
pPghVzaWBOlnPH88hM4BuRjli2wESl6I+uQ6hI8K1x5QzrCR0lR7xzJhCPKO
u0Vbj7PhdJJTLf6ctP13XvhuzsYu0SfCwe+GyLmtVTrClI2nXA3W97QhnHWs
sPMyIfNxuP/O5g8hP8xh+wlDNs4wmHlniCFYsBX7DHXJd8qdEz8b/w4hPb1p
dJUGG8GMt+elRocQvUcubL4KG1EWMhvnSw5DOHNT7oAiG3YDZwKL1gyjNMAl
p2UZG/mmOWd/KQyDFy4pVryIjF+6/qPLkmHkx3r0fxVhY/7OAOLglmEUl+fE
xAux4fyjq2lk0zDce/ziwmZYKEgz8n1E+j/vGdcMGGWBv3xOWqrhMJgazoc9
+1hY4l/3TthiGBGTlbqXeSwYbrwZdNhuGGNJaq5nmSy4bz859e7MMN5Eem48
0cyC8Ltt3urew3j/b77/0RoWXLecWHQlfBg/PWIiDpWycPPJBu+3nsM4/vH9
9P5CFlYntG6dDBnGKpse/l6wsOXx4RvP3w7je9r8V3szWTiQdFJE+vkwbnrm
ROz7xIKDbNXLiaxhPMhPlj+QROYr0Y4DaeeWqKqaxbOwyufF+GDxMOyqYkYs
X7EQY3Qqb5g5DOmWjQttwlkoUvXZvqJ/GDP/TiZceMyCyev8jcazw4hdZE29
EsRCcSiTpjA9DOvM6Dc+viwUDijIn5YZwa3wW7/ve7HQF1x+2XPdCET4h1xf
uLHQ/WC337TOCFZfVKxOuMRC+N//mmIVRnDZvtr7+zkW/OauWbBo5Qjeqd99
U3qKhdaN3f2N+0cwkhhkyrRk4fq+RIeiUyM48zA3dewQC7/0qaWvDo/g8Inr
R8T3suBoYNfoaDcC/23PrqoYsbB9qPF1qP0IxKwqD+zUZ+GYReCV/ddHECqd
53B6Iwu075JmCndHcGKBxuxN8p0+3HVjcPLmCGznXxOPWsPCwGjBMYU7I/iU
vawuZwULR+fLz/kYMoKyR7LN7dIsTAftR/vTEby+vvAYTZKFiYzSw3e/jMBz
5OChtQtYWKPx9tj34hGE3Ns8elCQhRU/xtQkSkfI95BKi8c0EyK0938W5Y/A
6Mc93dgRJna/i6Cl9Y3gfOJ9o5JeJp79+mqwrHMEvvT6e6OdTNRVc65/oI7i
3/J049VMJibCuUWz+qP4kXTX7WgzE5lS/n5rl4xC4Y7JwYAaJtwfvDJ7tGgU
KXyRsxmlTNyoDj+YsWYU0f/4PH4hE4oP5CjfV45i30Uj5gqCCc3XlnmSW0YR
LMTzt8xiorBI9PCbW6Mov2pm8/gzEx+KdixL9R/FfUub90XJTIirf2GU7hnF
2LxfL6hvmdDZed5T7fwoJGy3wDCaiSPsT6lZ5PrtkX7mPs+ZaHg7r4Z4SOId
EbbIfsLEupOrnmSFjOLOcpOpyftMGN+9zZe4NAovYds6Az8m9F8kbVn2ehRv
PNiyd3yYaF0QK1SbPYo1gVv/Flwj/RVegVbfR2F56McKERcmXg/VH3pcOIoC
D3a8uQMT69vv+C/5MwrN8qWhr+yYeLoyaUc2MYrNRQEruMeZEJtfQwzkkvwL
J1q0jjIRWcPKtJok62N/pfgeYEKAcccky3gM1rVyj8p2MTHngOoRnXljoIjp
ZchvZyI61WK4R3QMgc7aoq5bmHjp6F0VThlD/MSyP7+0mDjbvLtCYOkYxtqq
VkqpM2G2x/2/svljqGP/fee0molqE3Hmu51jOJ05+ihPnokKCyX31XvHsO4V
6mWlmXApFXZJdx+D/M7G7GsSpL41m0612Yyhq3LJ74r5ZH8yrgxvuTUGoXOb
dNcJMlFU/rsu4OoYYpMThIKnGdBcq6tx0WMMJeuGLvFHGNCrze2SfjeG3fl7
xvf1MeB6Y+LZy7djmNqjx0nhMdB14oudZtgYzj9aby/OYsAuPyuDETOGKpFX
otdaGJD01Vo0N2kMV1uHJJtrGdijZaTY1jUGrEl0NypnYP+/B6e0Gkm95g3Y
JxczQGMmNu3MG0NhfPztJb8YGBCz3FUhNo7Fu2gDvtkMvFseEeNFG8ddr7s/
/31l4Ey/w/q5/DFMDK1bfjKNgaUjr8dokuNQadsUWfKe9Duo6C4eGYOR8De3
rXEMCAXkKlw1HMcW2vPGtJcMnA6pN83ZPA7H44dPr3zGQEyDUN3fa+M4k9Jo
8PwRAxwPTtfDS+P4xnx3ZWEQA/Rso+b3u8dx/c11rQBfBoYjJgIMzcfxxVVe
YsaLAaboAq7IuXFYsS/s9HRngEsMlU2eHkeQYWHJoBMDka8dWy6QeD98Klpd
LzCQf7PE8ZjHOKpuf1nQa8tActO70EnS/3KN2EPnYwycuuJyXy1xHE9bLMN7
jzAQEZe37nTEOHoTpjKvmDKwS8/0ntrDcZj8vr1u2IQBgRKFjaHR45Aothrw
2kb2S34D8fD/v1tq+2sgsIUB91cJpjrscRS4JscFaTGw413A+Nwa0n9191Fx
dQZaRmv7DVikDRmLl6tJvJtls4MDpF5R25pWr2Dg7dkLv1SFJjC+qf3aZ2kG
dJrnL9KeIuu/q2izXZKBB6Nh38qlJrC7gPa7fAED/swF3ZdXTMBUvnfPaSEG
FG6fpToZTaDkcveigRk6BtRddr4xm8AJeKgEjNGhtmGe0qzdBG60nYbMAB2n
ryvq7j48Ac5nJ4cPXXQEh/Xr6F2YQGKI5/FdHDo25doxx4ImMPxTILytjY6N
V2vTkvwmUF2TesCzgQ6rMkd24oMJLO+PkFpURcdC/eNXCn0mILDca+2HEjqe
d5nn/Oc/gT7HmnTTAjrWVOjqRJJ4Y7/nmHf9pGOz9eNPBz5PwOjre53gTDp+
L/XJROAE5r3QOqX+mQ7jZ5qnf5F4OwrmzJYl0yEdNc3Ja53ALvumNLe3dOSF
7XDoLp7AF4Ulr6Vi6FDUvus48HECn6TGFv58QcdJw9lcxZkJFDy4Hnj+KR1U
uRz591kTeMJu2y76kA7h8vIk6ZEJ3EtO25oZQEfPERG53rIJBH+cTjt7m442
zuLJ2/QJ5PgsVRf3oiMw9/DzWPVJfJOU5eW40fHRr2O7zb5JrF3ziOPkREe1
t2fY+OJJjF05bil3gQ6DHy/e+W6cROe2VRVltiS+7Lo/JvKTmONID7pzjA7O
MhHteo9JiAjafdYxp8M+5e3WR5aT0DsYwOab0lGXvG4ljcR/f1nZPG4XHTmf
w54+t5mE+fKSaevtdExH1T9YaD0J94KlMpJ6dMi/69b6L2gSd7236f3VpuNU
ybKfU1mTqEsYCQ9aR0eWBOfA7VuTeKuaq7ZTmY79pTZs+9vkeoqcBlWRjqal
2TZbIifhEhy2OXcZHcl+RtHryXiNb6ledxbT8WndnIMHwybhe7xE2ViUjtx2
ZXvrV5NIzfjaIDSXDopVU+rLnEkoB9YQvyl0CHVSriT1TcJf4yzkRtuhORWz
nj07ifZHc6qT+O2QDYyMDeki9bxY2rmlrR2xlv8Kc8j4DxJ6F0sq26GIVpFY
Ei/+1Clz24J2/DRaEtUoO4XznlZiI5ntsJVQDcpSnkKDvdCfxynt6KcG7Ju7
ewoXy191qcS2o+Ggr76e3BTM/agtRWEk3iPNNyenJjG4PqTYPqgdbxXlwqkr
pzAmaCAz37sdSvHuTifXTMH33YrSNOd22KxRlZK1Jddrlu63PNMOakDqF0O7
KZwwNcqbtWhHvla05cPAKeibqUYm7yXxfMxS9gVMoZISWXXMgOQnnn/JK3IK
W/RbKuZrtsMlXzdhzZEpHIh9lJ+j1I64J79N+1ynUKgsssRduh2PC6pKLX9M
YdH+8ypqIu2o13litzh+CqeMP2twZtvg+lMy6uarKeg+WPI0brANjl5n3qpV
T0E9OMH0NLcNe3SGzY4mTyF5n1qRYnMbhNST/G0fT0Fup7Ump6wNQ3N7PI1I
fMfjggNJv9rgPf3aZmH+FHoK0l3cv7VBiX2Gof1pCrmHYpoMktqQJHG1T4Qz
hZThExHzo9uwpXV+blPLFFyy5iY3hrbhl9sN3fmLpyGk3H4tOaAN3UZPJbPM
pyHz/JPqba82KPO7M2cGSfwtZRssLrfBYMmdzK0C03BdctR/nV0bNMz46xkG
07h5Q+PxXIs2hGkNS3vumobwyZpbnD1tUOdc+p1rOI1zj3f8yN/aBpu7vY6f
vKch4que8k6jDczarujvttN4f93H94FSG8S1HVrl3aaBgxPRrtJtCLrCdZN2
nQbfr1j4mEgbXidIDT5ynIaL6GG5nQJt6OEYJy7SmYaR8pIlmkOt4BAqVnfv
TcNLPNxcobMVL+i7xGwSp7Fr61C9REsrxIgbr/7/v49OEYfnCFe0Ytl8ibiG
0Gm0n/2zeCqvFcMCLl88v05jY3rY+aGMVuye3urOLpvG5M2nNr3JrVh4Ludc
+5tpHDt9Qrs7phVqEYuUE/5Og2fbuacrrBV03qT8ob5pqO23i+4OIvNJffMd
50/j3m+7F33erTB+X7VWrm0aD5jSl0ZcWmFU2hJ5lozX1tzkPXOWjFddbNsh
MYMf9qyiudatcE6osSuxn8Gdw27pS0xbEf3fiQz5wzOYcE72VNreiusbEq/0
Csyg327oms7GVmh6/We0XHoGgTX2EnvXtsK394Jl9rIZ1Jdt97VZ3orsiyaq
vgEzMM5KXeMh3grlVLccvRUzWBjUTHsi2Ip6z+SgN2T+HbmR3iljLfB+2zz/
9rkZmFvn5v3pboGo9HCFieMMOO6a27voLdCwtonkXZrBl+ZlfQtrW5CeeSdY
8f4Mjp4W1tX+3YJD8jfHIq7MIHvk1P7jOS3QNTzTfvXUDL715jzx+9QCZ88d
6pvJetzqPB0/vG1BzuHe1rfZM3h78KJYa0QLlkwcz27xn4HMgWGmyOMW3E57
VJx9bwbniINsw7stqDDyfLTm/AyGNX093D1a4F9pYWmbPIPlxHhFomML5ik9
uBLcNoOZbY2WTJsWaKpHVwytnkXCzUFHOfMWnNC/9kaoeQZCimtNju9uwf7M
6nllf2fwUs12T4R+C77U6gubckj+r0vdmza0IEHrjXJGywxyBSmq8kotyPe9
5O1Nxlv0OcWflW7BDktunrb4LFomPxkli7Qg2FlD2fjPDJx5wnOGBVpgdnZp
hHHvDJwOfT6yY7gZjwTuNm2RnMWWzu82IbxmeInO3vvOJ+s1ufGovbUZPo/O
z3Qem0W9OHWHVlUzwryqjkdemiXfm4WfAwub4Sets7NYZRZ1Qv92tn5vxqAE
o++SxSxO304b0fnQjOYlbdqhSbNYn1ynEhrfDNed4mr7Ns3iZdIl6Z7nzaA8
lwt1T5zFcOZ+pQMPm/E7e6HGYd9ZPDb5bJrm24zibqPNV6/P4l2P0qDENdKm
SlSLPZ5FVazekesXm7FWinDe92AW594Fl7SdasaVjeNSYa9nIX37IrHnSDP5
XmR+u0ziOyvVX/q6qxmLR+0rZKtnMT9184aV+s24PbxNoujXLJqc/857uqEZ
qhyfDs34WSzNjT4pqNSMF/5+ke9KZpE+suOspzRZb/3qBtuWWTQyam71iDTD
7aWm6MeJWWy98TztAqUZ3qEH7EcFBYiSQ2bmjOEmCDjyls+MzkLRcFXiKX4T
plMfC66iChBWG7niLW1NqFtyqrSsbBbmTppdJ6ub4H56380IEQGid8Wjq+1F
TVg3pbb14GYB4kV17MJzP5pgGvKIlrNWgBg4+CGd/7EJZxfcmJtN4lelzC11
f9uEC7cszt8i+YTuKngyE9EE/nyKsrS6AKF7Ybdd8OMmLDIf7OwUFSBuOlQb
LPNrgvHZ/arQFiA0Eq4FJl9vQnFsRJDtEjK+qsrT0KkJzxTXbbqzSYC4bTHv
WvXpJkSKEbLypN0yMdDkaNGENzeCTh7QECD+rI3qpO1rwvuoQaqTrACxNGFw
OtqwCZskcipoOgLE0xCDZVu1m/BArPXBgIkA8eChRFSzchMyPK6FbD8qQBiN
zSnwWd4EtmqK+RYnAcL6/O/+FRJNGHCpDXu+TYCIufj9boFQE95256cuNRIg
jkg0f3OaaARB81MoJtfn5MX9W9LbiN6BwkVLbQQIi53Wa3JZjVg56OXFMhcg
wj8oEM4NjfhD0473shUg+An+E3KljchcdKJZ/aAAISKYubE8txEf5oV6dVgK
EBlCws53vzXCB317PpB8v6ccFNqc3Aj3KyllVt8EiLMub/R6YxqxTONugHmk
APGJN+aU8KwR/5kL9zS7CBBziYmJs/cbYetbIGJwj1wfuHK14q1GFNtukFCL
ESAEnDT20d0aoak4mZ/3XID4Zup2Mc6+Ec/+CA1KuJP6H7RgnDvZiKzQjmcr
zgkQS/wbB1TMGqH9MEkrw1OAaPS7OdVn0gjrqeis1SR/zdgn01l6jdB/ODU5
FSpASDcaHg3Y0IjROXbFmiT+bYqY0RGlRty+dmChxxcBQs3VcLWiTCNe2u46
seyJABHpV3xiYGEjDmTHqFgnCRCL4l4oF1Ab4XUoNkgyQIDoc8zuiBhtgDEj
IcIhTYDYnnn3hWt3A7YeN/NvHiX386nEl3sZDVi7WrC9opPcv1qxG5TqGjB5
Q405NJdCbNysnS5Q0gDG5InV/30SIP6lpauS0xUO5OvYW2UJELObX//D1wYI
zL7IvyNMIRbZ92x/ndgAE1a00pw+ks+/1XcDoxuw8um2Due/5P7wDRO9HNaA
9WyvSEUZCiGTG6Jica8BUywiRoEvQGw956Gx7SaZj98QcY20O5ZHrVRza0C8
yg32a7YA0SwkdkrGvgEWmxMLFnMEiCqthFXzTjZgmTc0JWQpxPu3/tUThxvA
bom+dkuNQoRdmbzUY9KAHfJ5q6zFKUSUU8Netl4DXDecll8nRMZfuPGpeUMD
PBjfmDFNAsRzwZ+zNUoNUOA6/w1WpxDD9G2hFTIN+CmyZZZDpRBydkRSqWgD
HB9+fNdymEI4tXQn/KWR9QmovJAh860qkA8uHavHX6Pvau7yFCJZ6Gtqxb96
KHQsCGtvFyBO3u2xqGXW49gHzy1bpgWIJ3+20pvr6xFWU3LosyKFYE6WJrD/
1oNacXAfQ4NCDMTvHO7JrYf9Ui2/BNIf4E5XnPxWj5jOD2dddShEpMb0unkp
9YjWkZ/bIkkh9jQHX5OJq4e5VN6hTYcoxNXdHwzV/qtH83kaQVhRiNo+B45h
cD0ecW0jYk0oRGv3kotHfetxMn2P4q79FGLU9eJqp2v1aDNfdXNpBoWI7xCy
C3Csh5+zblb7Lgrxkpt2Pda2HoOF8sczAymEQxAvP+doPWjfKHbJXhTivFNG
SMveevjWX9ruQta/YDpVe9qwHjnM4gUnHCjEvlD1jys21mOzfoGmfShZD8X7
9E6Veuwfyrb7c55C0K1kHjrK1+PE/rfrWxdRiJQE28dPF9VDbeBDR81WChEX
mnbhx9x6mChGapvvoBCLKRKundN15DyedinflUKoZvoPLBmsg3k6q/iiH4Ww
+aO016SzDvXfzDZnkv3ySi4r82itQzhzg5rFEwohOtxaklhVBxn1855xtyiE
+IbtkW1FdfgdUllV/opCLFGx3rokpw7FNuUP/F0ohMV44byDn+vgr3tSUMGX
QpgWnDO9974OgeNFP3w8KQQrlmmT/6oOzREXB/w+UgjFF2+2U5/WwTWjtjKd
xJP9ImZqFFSHxjypzCspFGLdxPU/fj51+KU8nViZTiFqTh5ZWnSlDgGrLH2O
DVCIyyL190Xs62DZ0bTTb5xCLH/0zdn8ZB02StkZv8+kEGLczStemdXB9PKV
AleyXwp78l927KqD7PXOazebSX1OWehrb61DaEqcTNUQhTjpILX/jmYdCuau
TEorI7+P+qVKlWvqIPHp4cpiUSoxRyS7YOXyOhxjz3Hcp0clUrwL7ntI1IF5
7OkKjUVUou1O8/cS4TpEikpGbSbt6G1ln1dO1eJg+VAu+ihEyJBWiXd/LV4O
80+2nqIS+SvnH6rrqMX3eJ3wYwJU4tubsedaLbVQiSEo+uuphHiP/dsnlbUo
a82+VaBGJawef67oK6yF35X2kp1KVMKEeuT8kR+1OLIiLcugnEJk2Xz8kf6p
FjstxT6rLKQS2+ymNsi+r8VeA+sd7INUQrJh3oK7r2pxtTz1+wdbKiE7svQ9
P7QWj2eavN8doBL1uiE0i6BaBI9ULnu7g+S/wd4r16cWtQRxYbSYQswG849u
cKuFx/fwE97DFMJ3m1xvtH0tCnl5Cg+ZFEK4+9Ju8VO1WPZD0G6xLpVoNQ79
5nekFjLpsl4z1RTi0KbD98d2k+uT7zTWFFCIOsJN2sWgFuc0sk9r6lCJKpt7
P7hapL/x3ElfdXL9nNRfdmtrsS2vavXVlVSC6Xbbr1WuFj+OJNCWGVMJga3O
M8cX1aIuKC8jJ4BK5PiWBzfNJeupMjs25E8lVpzX8ToxU4PVe2spNfOpxN11
QivaBmuwptcpjK9JJbaGpfmc4dXAvenga7kaKhERc5Df2VYDTxOCl/uc1EP4
X7prTQ3kxx3sdrtSiRB2uu7E7xpcrTurakDmn30dWRSAGhSeEG8IuE4lgn5M
f5FMr0FqwuBQ+WUqcT669WhcUg3+Ja0SmX1FJaR6UhI1Y2ug5xfe/PYmlVC/
s3p+fngNjjpwPUFQiWJz2QKr4Br4nNZ0ik+gEnqqVlr/fGug/KXL7eA5KnEA
+838Pcj40Gvter+phNCrG15yTjUI+R74n9ZjKkG+eicy7GqwQ4KSbWdJJUS3
9aoetaqBR0G16m99GlHIXX52wLQGfdOuEnfCqMRBMfOBUKMa2CQzpY5mkPtD
YGyD9uYadLh3mAWmUQkXc1/ZunU1EP3uel2vn0o8yFwg4r2qBrZOYrmjZL3b
biebKcrUYHvegERDHZUIE31s/Fu0BiIb2gwiX1KJJwtVGG6CNVCy+dqX6kwl
3F6fuyM/UY0ROf2y0nAq4WWff7WktxqfanfETJL6yCpvk7zBqcby9QmzclVU
Qjok7KNqczXG92vsqmRRibSQl7EtFdVQyzYUCcyiElpOilueFFZj11+tHD9F
GiETFeNl8qMaL5dnsYvUaERq7qvMqU/VoDFtSkOEaISVxNnd6e+rcXXelj63
MrKfqfd8XKKqIZSj16j2hErYSjulqYVVY8ePhkc3BWiEuHzKet69alx5Ivbs
fgqVuPQ13TzhVjXqXjX8faFMI3TkqHIXr1bjtaaKmnoWjWDuzKKrOVbDeufD
j1kLSD7b+H29ttU4Va381qSVSvRYl8SnW1SjqX5JzRNDGsGtrRvz2V8NpdmU
zFQJGmFkNmOya0c19nqLZnl3Uwm7cKJVXLcalCvbf+Z2UQnVYLmlrerVuJR5
QpYtSCPeG7TtTF5ZjY1fbiSO7qQR+YyaHzekq/H9XHmpzj2S/6+G6v2i1RiL
1XLYtYxGjLadvy8vWA3V+8ZWFndpxG8HMe3B8Sq0u3kVnbxOIxIOL1X63VuF
1O8qV0KyacSXQdnPsZwqPFN9vOItqafsgagWr+YqLG3Q0Qk4SSN8h0fHjlZW
oeKAk+2hPBoRLNJ8XLOoCgvX7HleUEYjpE0+W4nlVIEx23HBOJpG/NX8srP3
cxUS9bSlOEY0Inlz+7WKhCpctQseUiymErljXtu/RFch3bjEfVkRlVgnT33z
/FkV8k7XswkVGkGT9hy++aAKK25enUq5SiOuBuy7f963ChJXGcm7ttKIxPKg
rwc9qlBZdN6DZU4jSv774LHFqQpOt7Uci0/QCEmHR0przlTBNX9Jay2pz+LQ
KcnF1lW4TwzG+WvRiP7Auv9oB6twZk7a4Go9GuFkDcFh4yrQEp4ecCfzG3qz
PnG3VCGCPu0X50EjAhuGBpo3VEH2UWFooqUgkZt+tahyNamH0pmz9/+v36cq
v9+yVbDv6MiuliH3g8D7m78kqtAW8yLWtodKKMx1mZczpwrcvprdUiRe+VTK
mqzpSjDH0ivqT9GIIwdeqWQMVkL/4/Hc869pxPWz2x2+8SoRsCYrV/42jZh7
nrkpo70SZ5bc+8OKpRGRRf/xsmorMadX6EqQuSCRLvipLqekEpYqF6cPudOI
3frmR/JyK1G+2cDi91ZB4sZmysk/GZWIN1RIelFDI7o/Re6uTq3Ewz9dUp/i
Sf6X6Jda4ytxl8PTyftMJTZ/yVnOiyD53I4p+KUqSGQ9/5c6ElKJFNNT0svr
aYSfwU0PocBKrDtP6214SiPuG278s8SnEpLBOftUcmjE6snnCcpulQhfNhz+
15hGNGlsOK/vUInG+99UQqJoxIILrlaHbSox7FnncnWFIBFT2Vt14Wgl1E48
UzjuQCN2ZWjX39pXiVspAgW/a2mERm5Ixovtldjz+EW0fZggcfgoq+TLpkrQ
jk+/Z5Hfr6BfiH2FeiWyv3iJupH9/lWZ29qzshIHfP/Etd0RJHxG3geKylSi
zb3PQaWHRghX+qRvEKuEo6/oqmOBgkTCuuKLR4Qqkasura4URyNief4jHpMV
+GMl/bmngEbEpO/5+qq/AkfiR18cbyX5ZcmO5HErsN9Iz5d/jUZsjw7M7m6t
wLzrTx5yWDQir97MSqqmApkX+zal95Pn0ZMbK43/VMDUp3f95vWCxI+rdS6u
RAX4ev+2SmoIErGH5z6N+VYB2l1BV0uyH+nhx5nlKRX4YPjVfq8XjXi79eYX
SnwFbM7wfA6S582VyxOCOhEV+PWqu6eQoBHFg0YqjiEV2KPQ+pP2njxvmufc
iA2owEHn5XFplqT+C4v2NnhXoHPeqms2X2nEtvsLXki4VaBGfOpjMNnf3xaL
M0wdKtAiE5rFIvl2R44J3LepwNDV6OLMekFC10WwuPBoBYyDuEMMZ0HiZbKZ
jfB+Eo9tlH5Ah0as/GEsv3tHBZLOKUy4NtCIwz6U4/d1K5Dwgdn+1VOIUD8t
JVG6rgIxRqO/mx8JE2ncy+GSShUY+dW9Y+wDldBB6Y5jyypgeH0sbdth8r61
UHeIE68AFo2OyTUIESsGls7tEq6AmZ3usofkfdrBvt/hNFEO1jKr5F+7BIn3
oUXzhLnlaNWhOCaQ87D7BRe519XlaFhtbTn/O5X4Hwh/++w=
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.007526408293301, -3.550014692725674},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{{{-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}, {{{{-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {{{-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.01\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.05\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.10\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.50\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.007526408293301, -0.24864603459609533`}, \
{-3.550014692725674, 6.518686218447805}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9023902216433315`*^9, {3.902390332965553*^9, 3.90239034545841*^9}, 
   3.902391697059836*^9, 3.9023918036352324`*^9, {3.902391844632812*^9, 
   3.9023918522005377`*^9}, 3.902392847025035*^9, {3.902480701405431*^9, 
   3.9024807792961397`*^9}, 3.9024817531669083`*^9, 3.9024821446989183`*^9, 
   3.9024825909638405`*^9, 3.903581040357691*^9, 3.9035816058067493`*^9, 
   3.903584871490862*^9, 3.9040176824009085`*^9, 3.9040177941678133`*^9, 
   3.904017826565359*^9, {3.904018258687391*^9, 3.9040182747546525`*^9}, 
   3.904018561545083*^9, 3.9040193408415475`*^9, 3.9040195780773964`*^9, 
   3.9040198057383785`*^9, 3.904019887258906*^9, 3.904111287184654*^9, 
   3.9047041335992985`*^9, 3.907745108203864*^9, 3.9138008522477627`*^9, 
   3.9152726836279135`*^9, 3.9155254846881776`*^9, 3.91872742871078*^9},
 CellLabel->
  "Out[1370]=",ExpressionUUID->"debef488-6655-48cf-855e-df7603c3d996"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwVlnk4Vm8Tx9Wz7/tDJRWhUnYp0TNZSipRiSKUaCGhlPQLqVRa0UoLIbRQ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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-4.979352626382122, -1.7894206074901833`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-4.979352626382122, -0.9178459678266211}, \
{-1.7894206074901833`, 5.82553903788786}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9023902216433315`*^9, {3.902390332965553*^9, 3.90239034545841*^9}, 
   3.902391697059836*^9, 3.9023918036352324`*^9, {3.902391844632812*^9, 
   3.9023918522005377`*^9}, 3.902392847025035*^9, {3.902480701405431*^9, 
   3.9024807792961397`*^9}, 3.9024817531669083`*^9, 3.9024821446989183`*^9, 
   3.9024825909638405`*^9, 3.903581040357691*^9, 3.9035816058067493`*^9, 
   3.903584871490862*^9, 3.9040176824009085`*^9, 3.9040177941678133`*^9, 
   3.904017826565359*^9, {3.904018258687391*^9, 3.9040182747546525`*^9}, 
   3.904018561545083*^9, 3.9040193408415475`*^9, 3.9040195780773964`*^9, 
   3.9040198057383785`*^9, 3.904019887258906*^9, 3.904111287184654*^9, 
   3.9047041335992985`*^9, 3.907745108203864*^9, 3.9138008522477627`*^9, 
   3.9152726836279135`*^9, 3.9155254846881776`*^9, 3.918727429553151*^9},
 CellLabel->
  "Out[1371]=",ExpressionUUID->"84bbd803-296f-4c94-bb19-e02baec580a9"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\DataMerged.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9023902216433315`*^9, {3.902390332965553*^9, 3.90239034545841*^9}, 
   3.902391697059836*^9, 3.9023918036352324`*^9, {3.902391844632812*^9, 
   3.9023918522005377`*^9}, 3.902392847025035*^9, {3.902480701405431*^9, 
   3.9024807792961397`*^9}, 3.9024817531669083`*^9, 3.9024821446989183`*^9, 
   3.9024825909638405`*^9, 3.903581040357691*^9, 3.9035816058067493`*^9, 
   3.903584871490862*^9, 3.9040176824009085`*^9, 3.9040177941678133`*^9, 
   3.904017826565359*^9, {3.904018258687391*^9, 3.9040182747546525`*^9}, 
   3.904018561545083*^9, 3.9040193408415475`*^9, 3.9040195780773964`*^9, 
   3.9040198057383785`*^9, 3.904019887258906*^9, 3.904111287184654*^9, 
   3.9047041335992985`*^9, 3.907745108203864*^9, 3.9138008522477627`*^9, 
   3.9152726836279135`*^9, 3.9155254846881776`*^9, 3.9187274307977943`*^9},
 CellLabel->
  "Out[1372]=",ExpressionUUID->"0ac13db1-04b5-4708-a66d-1d1157abf59c"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.797177742009224, 5.819762008655829}, {-4.797177742009224,
          5.822026346865364}}], 
        LineBox[{{-4.797177742009224, 5.822026346865364}, {-4.797177742009224,
          5.824285569428744}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.744476194802894, 5.818076969077218}, {-4.744476194802894,
          5.819541788563895}}], 
        LineBox[{{-4.744476194802894, 5.819541788563895}, {-4.744476194802894,
          5.821004465492522}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.694413992516303, 5.810436370756855}, {-4.694413992516303,
          5.8123374163203225`}}], 
        LineBox[{{-4.694413992516303, 
         5.8123374163203225`}, {-4.694413992516303, 5.814234854765767}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.639079310907025, 5.800455426589272}, {-4.639079310907025,
          5.802676580195167}}], 
        LineBox[{{-4.639079310907025, 5.802676580195167}, {-4.639079310907025,
          5.804892811209535}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.586515845300355, 5.795876906689839}, {-4.586515845300355,
          5.796145120940487}}], 
        LineBox[{{-4.586515845300355, 5.796145120940487}, {-4.586515845300355,
          5.796413263271541}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.5366970158370865`, 
         5.785888103998467}, {-4.5366970158370865`, 5.787643768656461}}], 
        LineBox[{{-4.5366970158370865`, 
         5.787643768656461}, {-4.5366970158370865`, 5.78939635635738}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.48913548264223, 5.776554683693232}, {-4.48913548264223, 
         5.778426199014414}}], 
        LineBox[{{-4.48913548264223, 5.778426199014414}, {-4.48913548264223, 
         5.78029421830785}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.443832202221532, 5.766051469296165}, {-4.443832202221532,
          5.767084277866418}}], 
        LineBox[{{-4.443832202221532, 5.767084277866418}, {-4.443832202221532,
          5.768116020843588}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.394399014142127, 
         5.7569033058719565`}, {-4.394399014142127, 5.759345262741718}}], 
        LineBox[{{-4.394399014142127, 5.759345262741718}, {-4.394399014142127,
          5.761781270981475}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.3416092662832835`, 
         5.744337860279319}, {-4.3416092662832835`, 5.746326316518357}}], 
        LineBox[{{-4.3416092662832835`, 
         5.746326316518357}, {-4.3416092662832835`, 5.7483108266445555`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.29137418436557, 5.730942683606787}, {-4.29137418436557, 
         5.73327564075603}}], 
        LineBox[{{-4.29137418436557, 5.73327564075603}, {-4.29137418436557, 
         5.735603167881768}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.243627592963491, 
         5.7176175453693405`}, {-4.243627592963491, 5.719821204304834}}], 
        LineBox[{{-4.243627592963491, 5.719821204304834}, {-4.243627592963491,
          5.722020017803358}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.1930755116491225`, 
         5.700548177855296}, {-4.1930755116491225`, 5.703155492212756}}], 
        LineBox[{{-4.1930755116491225`, 
         5.703155492212756}, {-4.1930755116491225`, 5.7057560261568945`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.14031009566014, 5.682979178475781}, {-4.14031009566014, 
         5.685425217338356}}], 
        LineBox[{{-4.14031009566014, 5.685425217338356}, {-4.14031009566014, 
         5.687865287691052}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.090113989052181, 5.661717697016165}, {-4.090113989052181,
          5.664900879165424}}], 
        LineBox[{{-4.090113989052181, 5.664900879165424}, {-4.090113989052181,
          5.668073960809335}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.042387299327325, 5.641793424923118}, {-4.042387299327325,
          5.644833693509849}}], 
        LineBox[{{-4.042387299327325, 5.644833693509849}, {-4.042387299327325,
          5.647864746873178}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.992759631205534, 5.620529605994944}, {-3.992759631205534,
          5.623497742995775}}], 
        LineBox[{{-3.992759631205534, 5.623497742995775}, {-3.992759631205534,
          5.626457096224359}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.941670190878295, 
         5.5928611598106475`}, {-3.941670190878295, 5.596489031597599}}], 
        LineBox[{{-3.941670190878295, 5.596489031597599}, {-3.941670190878295,
          5.600103789492039}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.891269897861019, 5.569309619769229}, {-3.891269897861019,
          5.576479701281029}}], 
        LineBox[{{-3.891269897861019, 5.576479701281029}, {-3.891269897861019,
          5.5835987384985675`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.840589006272296, 5.540149821174754}, {-3.840589006272296,
          5.546936017684205}}], 
        LineBox[{{-3.840589006272296, 5.546936017684205}, {-3.840589006272296,
          5.553676471971935}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.789314195620098, 5.50169064297325}, {-3.789314195620098, 
         5.50771286744662}}], 
        LineBox[{{-3.789314195620098, 5.50771286744662}, {-3.789314195620098, 
         5.51369904172644}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.7385082206568967`, 
         5.463193512837019}, {-3.7385082206568967`, 5.46961982295645}}], 
        LineBox[{{-3.7385082206568967`, 
         5.46961982295645}, {-3.7385082206568967`, 5.476005099170418}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.687553966799195, 5.418630050627681}, {-3.687553966799195,
          5.424081558008672}}], 
        LineBox[{{-3.687553966799195, 5.424081558008672}, {-3.687553966799195,
          5.429503507519082}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.6394701977421353`, 
         5.369307163437533}, {-3.6394701977421353`, 5.375355618531926}}], 
        LineBox[{{-3.6394701977421353`, 
         5.375355618531926}, {-3.6394701977421353`, 5.381367709652956}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.5913770350437364`, 
         5.318798120237559}, {-3.5913770350437364`, 5.325497728173848}}], 
        LineBox[{{-3.5913770350437364`, 
         5.325497728173848}, {-3.5913770350437364`, 5.33215274990805}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.541481118467001, 5.260011883768924}, {-3.541481118467001,
          5.266963851292039}}], 
        LineBox[{{-3.541481118467001, 5.266963851292039}, {-3.541481118467001,
          5.273867822439983}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.490560446322198, 5.19605843767869}, {-3.490560446322198, 
         5.2027761194173765`}}], 
        LineBox[{{-3.490560446322198, 
         5.2027761194173765`}, {-3.490560446322198, 5.2094489748693995`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.4400466065210358`, 
         5.124021542752819}, {-3.4400466065210358`, 5.130467753854947}}], 
        LineBox[{{-3.4400466065210358`, 
         5.130467753854947}, {-3.4400466065210358`, 5.136872677326231}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.3904598481031187`, 
         5.050139923211506}, {-3.3904598481031187`, 5.056943510240905}}], 
        LineBox[{{-3.3904598481031187`, 
         5.056943510240905}, {-3.3904598481031187`, 5.06370112110056}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.3399476489202504`, 
         4.964814545271143}, {-3.3399476489202504`, 4.971786093102067}}], 
        LineBox[{{-3.3399476489202504`, 
         4.971786093102067}, {-3.3399476489202504`, 4.9787093747497035`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.2889155395734413`, 
         4.874118084586548}, {-3.2889155395734413`, 4.8809835989888075`}}], 
        LineBox[{{-3.2889155395734413`, 
         4.8809835989888075`}, {-3.2889155395734413`, 4.88780229932309}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.238862605729559, 4.779043514336999}, {-3.238862605729559,
          4.7860047461953625`}}], 
        LineBox[{{-3.238862605729559, 
         4.7860047461953625`}, {-3.238862605729559, 4.792917854113653}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.1884844566706505`, 
         4.678304782263578}, {-3.1884844566706505`, 4.685684103144152}}], 
        LineBox[{{-3.1884844566706505`, 
         4.685684103144152}, {-3.1884844566706505`, 4.693009368299112}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.1392549255926787`, 
         4.574021849195823}, {-3.1392549255926787`, 4.581258773506933}}], 
        LineBox[{{-3.1392549255926787`, 
         4.581258773506933}, {-3.1392549255926787`, 4.588443700817609}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.0910678758086894`, 
         4.468071446837726}, {-3.0910678758086894`, 4.475501580835913}}], 
        LineBox[{{-3.0910678758086894`, 
         4.475501580835913}, {-3.0910678758086894`, 4.48287691486374}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.040621982057506, 4.351661642931898}, {-3.040621982057506,
          4.3593108278432275`}}], 
        LineBox[{{-3.040621982057506, 
         4.3593108278432275`}, {-3.040621982057506, 4.366901946602512}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.9899908876929957`, 
         4.240105290737719}, {-2.9899908876929957`, 4.247254749420476}}], 
        LineBox[{{-2.9899908876929957`, 
         4.247254749420476}, {-2.9899908876929957`, 4.254353455979342}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.940769275071801, 4.125991474524718}, {-2.940769275071801,
          4.132917315606916}}], 
        LineBox[{{-2.940769275071801, 4.132917315606916}, {-2.940769275071801,
          4.139795519155296}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.889929645114332, 4.016835299909933}, {-2.889929645114332,
          4.02404565351082}}], 
        LineBox[{{-2.889929645114332, 4.02404565351082}, {-2.889929645114332, 
         4.031204389869201}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.838758551120944, 3.904337528847628}, {-2.838758551120944,
          3.9103429738325364`}}], 
        LineBox[{{-2.838758551120944, 
         3.9103429738325364`}, {-2.838758551120944, 3.916312568637161}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.7892381567704363`, 
         3.7965900169762117`}, {-2.7892381567704363`, 3.802765367018318}}], 
        LineBox[{{-2.7892381567704363`, 
         3.802765367018318}, {-2.7892381567704363`, 3.8089028160446143`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.739463208562421, 3.690786713586362}, {-2.739463208562421,
          3.6966983493581713`}}], 
        LineBox[{{-2.739463208562421, 
         3.6966983493581713`}, {-2.739463208562421, 3.7025752429748646`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.6904867995296233`, 
         3.590790154854505}, {-2.6904867995296233`, 3.5966402637533914`}}], 
        LineBox[{{-2.6904867995296233`, 
         3.5966402637533914`}, {-2.6904867995296233`, 3.602456347830588}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.640636822027714, 3.48638593309271}, {-2.640636822027714, 
         3.492112831822956}}], 
        LineBox[{{-2.640636822027714, 3.492112831822956}, {-2.640636822027714,
          3.4978071198536873`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.589854431426529, 3.383415961942288}, {-2.589854431426529,
          3.389299497739821}}], 
        LineBox[{{-2.589854431426529, 3.389299497739821}, {-2.589854431426529,
          3.3951486199189382`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.539884052803793, 3.277884605434408}, {-2.539884052803793,
          3.283262096224978}}], 
        LineBox[{{-2.539884052803793, 3.283262096224978}, {-2.539884052803793,
          3.2886108242111196`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.4904198577188468`, 
         3.174677705634412}, {-2.4904198577188468`, 3.1799492073200386`}}], 
        LineBox[{{-2.4904198577188468`, 
         3.1799492073200386`}, {-2.4904198577188468`, 3.1851930659324723`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.44018399544433, 3.068567005271303}, {-2.44018399544433, 
         3.073742823984378}}], 
        LineBox[{{-2.44018399544433, 3.073742823984378}, {-2.44018399544433, 
         3.0788919914807775`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.3970037328631912`, 
         2.9783762132835534`}, {-2.3970037328631912`, 2.982681821147142}}], 
        LineBox[{{-2.3970037328631912`, 
         2.982681821147142}, {-2.3970037328631912`, 2.9869689701996642`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.3363931588589124`, 
         2.85057469874118}, {-2.3363931588589124`, 2.8824366082533066`}}], 
        LineBox[{{-2.3363931588589124`, 
         2.8824366082533066`}, {-2.3363931588589124`, 2.913314605159022}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.281265675526911, 
         2.7294352265460966`}, {-2.281265675526911, 2.760180312167539}}], 
        LineBox[{{-2.281265675526911, 2.760180312167539}, {-2.281265675526911,
          2.790008264747162}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.2290195976231373`, 
         2.6094416088569883`}, {-2.2290195976231373`, 2.639563814322594}}], 
        LineBox[{{-2.2290195976231373`, 
         2.639563814322594}, {-2.2290195976231373`, 2.6688051418575385`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.1793685730020647`, 
         2.4973697377283317`}, {-2.1793685730020647`, 2.5254570684459785`}}], 
        LineBox[{{-2.1793685730020647`, 
         2.5254570684459785`}, {-2.1793685730020647`, 2.552777005973759}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.132066928366445, 
         2.3865870275042487`}, {-2.132066928366445, 2.4148300348279905`}}], 
        LineBox[{{-2.132066928366445, 
         2.4148300348279905`}, {-2.132066928366445, 2.442297235646723}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.0869022806908246`, 
         2.279623999195259}, {-2.0869022806908246`, 2.3064377100897744`}}], 
        LineBox[{{-2.0869022806908246`, 
         2.3064377100897744`}, {-2.0869022806908246`, 2.3325511810655786`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.043689890843803, 2.177037311307883}, {-2.043689890843803,
          2.202810776953295}}], 
        LineBox[{{-2.043689890843803, 2.202810776953295}, {-2.043689890843803,
          2.227936627407772}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.9922591417332391`, 
         2.047665111979076}, {-1.9922591417332391`, 2.076759946610725}}], 
        LineBox[{{-1.9922591417332391`, 
         2.076759946610725}, {-1.9922591417332391`, 2.1050321497791575`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.9431847987770763`, 
         1.9313584267014237`}, {-1.9431847987770763`, 1.9552483142101713`}}], 
        LineBox[{{-1.9431847987770763`, 
         1.9552483142101713`}, {-1.9431847987770763`, 1.9785807661736017`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.8965524789113963`, 
         1.814874717671796}, {-1.8965524789113963`, 1.8412308180785588`}}], 
        LineBox[{{-1.8965524789113963`, 
         1.8412308180785588`}, {-1.8965524789113963`, 1.8669100752324486`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.8432385413825239`, 
         1.6773658745992075`}, {-1.8432385413825239`, 1.7034750703590953`}}], 
        LineBox[{{-1.8432385413825239`, 
         1.7034750703590953`}, {-1.8432385413825239`, 1.7289198856746457`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.7926241709578499`, 
         1.548204160452878}, {-1.7926241709578499`, 1.5730196288864224`}}], 
        LineBox[{{-1.7926241709578499`, 
         1.5730196288864224`}, {-1.7926241709578499`, 1.597234171999519}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.7444491170269572`, 
         1.4223861293620237`}, {-1.7444491170269572`, 1.446802512422968}}], 
        LineBox[{{-1.7444491170269572`, 
         1.446802512422968}, {-1.7444491170269572`, 1.470636917301671}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.6910946257624335`, 
         1.2760102000732005`}, {-1.6910946257624335`, 1.3026325462287156`}}], 
        LineBox[{{-1.6910946257624335`, 
         1.3026325462287156`}, {-1.6910946257624335`, 1.3285644836513213`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.6403211163655644`, 
         1.1387935393832334`}, {-1.6403211163655644`, 1.161913306433651}}], 
        LineBox[{{-1.6403211163655644`, 
         1.161913306433651}, {-1.6403211163655644`, 1.184510606426205}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.5921129974870758`, 
         0.9993182227925739}, {-1.5921129974870758`, 1.0247152728913502`}}], 
        LineBox[{{-1.5921129974870758`, 
         1.0247152728913502`}, {-1.5921129974870758`, 1.0494832563003338`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.5396620614092322`, 
         0.8472301074668827}, {-1.5396620614092322`, 0.8719033109539255}}], 
        LineBox[{{-1.5396620614092322`, 
         0.8719033109539255}, {-1.5396620614092322`, 0.8959823773224341}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.4898261687190073`, 
         0.6986084101688271}, {-1.4898261687190073`, 0.7226584956303658}}], 
        LineBox[{{-1.4898261687190073`, 
         0.7226584956303658}, {-1.4898261687190073`, 0.7461437325510569}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.4423568402492635`, 
         0.5532733561898138}, {-1.4423568402492635`, 0.5766140840775194}}], 
        LineBox[{{-1.4423568402492635`, 
         0.5766140840775194}, {-1.4423568402492635`, 0.5994224250666534}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.3915620127029256`, 
         0.3911632244617875}, {-1.3915620127029256`, 0.41673587660326894`}}], 
        LineBox[{{-1.3915620127029256`, 
         0.41673587660326894`}, {-1.3915620127029256`, 
         0.44167084167268456`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.337943758573481, 
         0.21859403335034472`}, {-1.337943758573481, 0.2430844911704719}}], 
        LineBox[{{-1.337943758573481, 
         0.2430844911704719}, {-1.337943758573481, 0.2669894763956347}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.28705529483288, 0.04913397488560122}, {-1.28705529483288,
          0.07295643070337181}}], 
        LineBox[{{-1.28705529483288, 0.07295643070337181}, {-1.28705529483288,
          0.09622455700547318}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.2386319895218896`, -0.11486988047420081`}, \
{-1.2386319895218896`, -0.09150920522185076}}], 
        LineBox[{{-1.2386319895218896`, -0.09150920522185076}, \
{-1.2386319895218896`, -0.06868181687345848}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.187979598895396, -0.29168130157726835`}, \
{-1.187979598895396, -0.2674450106988737}}], 
        LineBox[{{-1.187979598895396, -0.2674450106988737}, \
{-1.187979598895396, -0.24378224490409117`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.1396995114830504`, -0.45992233170280916`}, \
{-1.1396995114830504`, -0.4380333762277172}}], 
        LineBox[{{-1.1396995114830504`, -0.4380333762277172}, \
{-1.1396995114830504`, -0.41661330212069314`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.0896630773474778`, -0.6423850103954032}, \
{-1.0896630773474778`, -0.6181620075471068}}], 
        LineBox[{{-1.0896630773474778`, -0.6181620075471068}, \
{-1.0896630773474778`, -0.5945119084656934}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.0380375960802406`, -0.8252309962813671}, \
{-1.0380375960802406`, -0.8036690562283811}}], 
        LineBox[{{-1.0380375960802406`, -0.8036690562283811}, \
{-1.0380375960802406`, -0.782562237397956}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-0.9890092612848482, -1.0026024788413008`}, \
{-0.9890092612848482, -0.9808188921150512}}], 
        LineBox[{{-0.9890092612848482, -0.9808188921150512}, \
{-0.9890092612848482, -0.9594997311536956}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
    PointSize[0.015], Thickness[0.005], PointBox[CompressedData["
1:eJwB4QQe+yFib1JlAgAAAE0AAAACAAAAbx2sXE8wE8DI8lBGwUkXQNpQtfdX
+hLAX1lu9jVHF0Ag+C52FMcSwNWmMWHVPxdAZJWPzmqOEsA/0HTZ8DUXQHGa
GJyXWBLAyDylqkAvF0A6hgvnkyUSwFscjRaMJhdA1QuV7t/0EcBLd+zBGx0X
QATQ5fJ7xhHAItl6in4RF0CkQs1V3ZMRwJBk982RCRdA/snK0c5dEcCpXEb3
PPwWQMX+gv5dKhHAnABAz9/uFkC/uQCDefkQwI7TTc8Y4RZAC8RAlrXFEMDt
OUz+B9AWQL+iIHOtjxDAqEmxG+C9FkCckG/XRlwQwHpjrMbbqBZAqoGBk2cr
EMBM76NIT5QWQMmIJvYr8Q/AyS89MXZ+FkDZhYthiogPwKCJTAXOYhZAWce5
HFIhD8BOPd+xUE4WQICImrqGuQ7AItXT/g8wFkCqpwP2g1AOwDfExeHlBxZA
YGN8/3boDcDlmtQE5OAVQNQZTUscgA3Al++Zb0KyFUCRjRCNoh0NwJ/bJzld
gBVARPII4iO7DMBFt8VGT00VQPm8eQ30VAzA1w3K+F4RFUDuUY30quwLwM06
BYukzxRA/sm9JzeFC8BT9b9WmYUUQD0IsGmpHwvAB9FIZk86FEButxN5NrgK
wO9SwuQb4xNAaDFO87JPCsCS4IeQIIYTQDLEPsww6QnAs6Odbd4kE0Bgo4kj
BIIJwJ2QOfkjvhJA29G5rzEdCcDC5vp/NVMSQB6EYsuBugjA04vr4unmEUBJ
fCOeMVMIwMy9ei3vbxFA3dWvV4DrB8CeKlpZMP0QQL8erAqyhgfATmoOehuI
EEA4Dgxvkx4HwHrCfWyfGBBAOnASC8e1BsB0CKblYUgPQL2sQBhcUAbAEqSt
PxBsDkBz98qva+oFwD5djZXWkg1AQWVy8R2GBcCMYaJU68UMQHzHuTIGIAXA
7Pg02tjvC0BcBaOZBbgEwFIiGQ5JHQtA0mTzuq5RBMCK3PvqHkQKQP2wET9h
7APApwvDNYlwCUCCP8Uvf4UDwOaeSnoGlwhAckwISxAtA8AHm2FJiNwHQGMt
f+XusALAzu2p7DoPB0DiAO83CEACwMqUXmrZFAZAw3kPOgjVAcC0wxGi0x0F
QN7KV8pYbwHAi2vj1SI0BECIvBEbeQ4BwMrgx2iSUQNAhh6s0vmxAMAQxjid
lXMCQDS44hV6WQDAdlOyQVufAUCway4fS+D/v6ivolE0nQBAZU+N8UgX/78W
eNF0skj/P6MngWlHWP6/R45Acq51/T9Xb1+y5339v9flSxNvQfs/fYfErpau
/L8oiGChFiv5P3OrMnpD6fu/WAkqZBom9z/IdAE9uQ77v+QejDmV1/Q/KKfb
WsE++r9Utz5oMpfyP3ble3pLefm/JXuM1ztl8D9EUIqvdKL4v4FHusWh5us/
R/j19lPW979dFp21BCDnPw2FIMTkE/e/gNQwYZ9z4j/Zo26H1kP2v/wtRfTM
q9o/4l3vtjdo9b8f+d6BZB3PP7Y290rHl/S/K2Tny0Wtsj82auzGb9HzvxX3
tbMlbbe/gSJZ5fYB87+ohZut0R3Rv9pjEY41PPK/rhZdJL0I3L+x2w2NQm/x
v8hswbD7x+O/8e1yT82b8L/P2ykrqLfpv/gaFcD2pe+/79sdTd5i778iIVH8

     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-4.9575042796091555`, -1.536845211412012},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-4.9575042796091555`, -0.9890092612848482}, \
{-1.536845211412012, 5.824285569428744}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9023902216433315`*^9, {3.902390332965553*^9, 3.90239034545841*^9}, 
   3.902391697059836*^9, 3.9023918036352324`*^9, {3.902391844632812*^9, 
   3.9023918522005377`*^9}, 3.902392847025035*^9, {3.902480701405431*^9, 
   3.9024807792961397`*^9}, 3.9024817531669083`*^9, 3.9024821446989183`*^9, 
   3.9024825909638405`*^9, 3.903581040357691*^9, 3.9035816058067493`*^9, 
   3.903584871490862*^9, 3.9040176824009085`*^9, 3.9040177941678133`*^9, 
   3.904017826565359*^9, {3.904018258687391*^9, 3.9040182747546525`*^9}, 
   3.904018561545083*^9, 3.9040193408415475`*^9, 3.9040195780773964`*^9, 
   3.9040198057383785`*^9, 3.904019887258906*^9, 3.904111287184654*^9, 
   3.9047041335992985`*^9, 3.907745108203864*^9, 3.9138008522477627`*^9, 
   3.9152726836279135`*^9, 3.9155254846881776`*^9, 3.91872743109986*^9},
 CellLabel->
  "Out[1374]=",ExpressionUUID->"ccd449c4-53c3-41e1-9cdf-332edbc8eb8a"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\DataMergedBinned.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9023902216433315`*^9, {3.902390332965553*^9, 3.90239034545841*^9}, 
   3.902391697059836*^9, 3.9023918036352324`*^9, {3.902391844632812*^9, 
   3.9023918522005377`*^9}, 3.902392847025035*^9, {3.902480701405431*^9, 
   3.9024807792961397`*^9}, 3.9024817531669083`*^9, 3.9024821446989183`*^9, 
   3.9024825909638405`*^9, 3.903581040357691*^9, 3.9035816058067493`*^9, 
   3.903584871490862*^9, 3.9040176824009085`*^9, 3.9040177941678133`*^9, 
   3.904017826565359*^9, {3.904018258687391*^9, 3.9040182747546525`*^9}, 
   3.904018561545083*^9, 3.9040193408415475`*^9, 3.9040195780773964`*^9, 
   3.9040198057383785`*^9, 3.904019887258906*^9, 3.904111287184654*^9, 
   3.9047041335992985`*^9, 3.907745108203864*^9, 3.9138008522477627`*^9, 
   3.9152726836279135`*^9, 3.9155254846881776`*^9, 3.918727432361436*^9},
 CellLabel->
  "Out[1375]=",ExpressionUUID->"eb1ca010-d449-4570-b45e-d7987bd3ee22"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\Sample playground \
LH-ESRF-E27 SAXS data merged.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9023902216433315`*^9, {3.902390332965553*^9, 3.90239034545841*^9}, 
   3.902391697059836*^9, 3.9023918036352324`*^9, {3.902391844632812*^9, 
   3.9023918522005377`*^9}, 3.902392847025035*^9, {3.902480701405431*^9, 
   3.9024807792961397`*^9}, 3.9024817531669083`*^9, 3.9024821446989183`*^9, 
   3.9024825909638405`*^9, 3.903581040357691*^9, 3.9035816058067493`*^9, 
   3.903584871490862*^9, 3.9040176824009085`*^9, 3.9040177941678133`*^9, 
   3.904017826565359*^9, {3.904018258687391*^9, 3.9040182747546525`*^9}, 
   3.904018561545083*^9, 3.9040193408415475`*^9, 3.9040195780773964`*^9, 
   3.9040198057383785`*^9, 3.904019887258906*^9, 3.904111287184654*^9, 
   3.9047041335992985`*^9, 3.907745108203864*^9, 3.9138008522477627`*^9, 
   3.9152726836279135`*^9, 3.9155254846881776`*^9, 3.918727432656726*^9},
 CellLabel->
  "Out[1377]=",ExpressionUUID->"30f78083-0506-473a-b21f-efe2b68e9e5f"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\Sample playground \
LH-ESRF-E27 SAXS data merged and binned.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.8926137112076287`*^9, 3.8926137597068872`*^9, 
   3.8926137904555197`*^9, {3.8926142793509655`*^9, 3.892614293785022*^9}, {
   3.8926143341300197`*^9, 3.892614379762048*^9}, 3.892614465860449*^9, 
   3.8926960604540453`*^9, 3.902037114926843*^9, 3.9020422053140135`*^9, 
   3.9022934592621293`*^9, 3.9022934952818155`*^9, 3.902293810169385*^9, 
   3.9022961961234293`*^9, 3.902296684173396*^9, 3.902297541969925*^9, 
   3.902297602521983*^9, 3.902298377775674*^9, 3.902389065137349*^9, 
   3.902389158029107*^9, {3.9023893989402933`*^9, 3.902389411383639*^9}, 
   3.9023902216433315`*^9, {3.902390332965553*^9, 3.90239034545841*^9}, 
   3.902391697059836*^9, 3.9023918036352324`*^9, {3.902391844632812*^9, 
   3.9023918522005377`*^9}, 3.902392847025035*^9, {3.902480701405431*^9, 
   3.9024807792961397`*^9}, 3.9024817531669083`*^9, 3.9024821446989183`*^9, 
   3.9024825909638405`*^9, 3.903581040357691*^9, 3.9035816058067493`*^9, 
   3.903584871490862*^9, 3.9040176824009085`*^9, 3.9040177941678133`*^9, 
   3.904017826565359*^9, {3.904018258687391*^9, 3.9040182747546525`*^9}, 
   3.904018561545083*^9, 3.9040193408415475`*^9, 3.9040195780773964`*^9, 
   3.9040198057383785`*^9, 3.904019887258906*^9, 3.904111287184654*^9, 
   3.9047041335992985`*^9, 3.907745108203864*^9, 3.9138008522477627`*^9, 
   3.9152726836279135`*^9, 3.9155254846881776`*^9, 3.9187274329398203`*^9},
 CellLabel->
  "Out[1379]=",ExpressionUUID->"bf08ef59-b106-4c52-9024-33e5a18effff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "slopes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "8"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<Slopes.pdf\>\""}], "}"}], "]"}], ",", "plotSlopes"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"slope", "[", 
    RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "slopes", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", 
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS slopes.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookFileName", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852797516969694*^9, {3.852797632109549*^9, 3.852797683131383*^9}, {
   3.852797796480151*^9, 3.852797853718195*^9}, {3.8527978838837643`*^9, 
   3.852797901227326*^9}, {3.852797980320817*^9, 3.852798038102087*^9}, 
   3.852798223135673*^9, {3.852798406664549*^9, 3.852798409306513*^9}, {
   3.852798512004775*^9, 3.852798555547234*^9}, {3.85279858828354*^9, 
   3.852798831366269*^9}, {3.852798896028565*^9, 3.852799007753936*^9}, {
   3.852799080350028*^9, 3.852799084748775*^9}, {3.8527992586158037`*^9, 
   3.8527992606884203`*^9}, {3.852801934781908*^9, 3.85280197103442*^9}, {
   3.852802103164875*^9, 3.852802118419861*^9}, {3.852862635200562*^9, 
   3.8528626398081703`*^9}, {3.85286268207966*^9, 3.85286275183375*^9}, {
   3.852862799533414*^9, 3.852862876114451*^9}, {3.8528629338179607`*^9, 
   3.852862985846582*^9}, {3.852863040437448*^9, 3.852863051004711*^9}, {
   3.852868510428824*^9, 3.852868602768145*^9}, {3.852868644287572*^9, 
   3.85286868020261*^9}, {3.852868718724351*^9, 3.85286873785894*^9}, {
   3.852868770378528*^9, 3.8528689132597523`*^9}, {3.852868965432905*^9, 
   3.852868981650947*^9}, 3.852870677134739*^9, {3.8528710993603067`*^9, 
   3.852871145669981*^9}, {3.8528716178560038`*^9, 3.852871618411791*^9}, {
   3.852874052533587*^9, 3.852874070324737*^9}, {3.8533820192129173`*^9, 
   3.853382032526078*^9}, {3.853403584226432*^9, 3.853403584753387*^9}, {
   3.8534051467395353`*^9, 3.853405196243081*^9}, {3.853405235261485*^9, 
   3.8534052353804817`*^9}, {3.853405414194544*^9, 3.85340541704944*^9}, {
   3.854423706814918*^9, 3.854423713174549*^9}, {3.8601401065322495`*^9, 
   3.8601401162752795`*^9}, {3.8617652315248656`*^9, 3.861765245785426*^9}, {
   3.861765486245756*^9, 3.861765500810083*^9}, {3.8617668960181065`*^9, 
   3.861766896503375*^9}, {3.861766959391518*^9, 3.861766970643777*^9}, {
   3.861768170754223*^9, 3.861768171551543*^9}, {3.861768267366991*^9, 
   3.8617682678668547`*^9}, 3.861940907625001*^9, {3.861941874731223*^9, 
   3.8619418752572*^9}, {3.863686273326891*^9, 3.86368627384243*^9}, 
   3.863687238834276*^9, {3.8895154361670246`*^9, 3.889515452084921*^9}, {
   3.889672427830373*^9, 3.8896724458079796`*^9}, {3.8896763888939342`*^9, 
   3.8896765605915513`*^9}, 3.889676629643072*^9, {3.88967679120571*^9, 
   3.88967681543388*^9}, {3.889676858823769*^9, 3.889676888283419*^9}, {
   3.8926137291399455`*^9, 3.8926137292831807`*^9}, 3.902042275559038*^9, {
   3.902042306429104*^9, 3.9020423363791375`*^9}, {3.9023894250958447`*^9, 
   3.902389439127889*^9}, {3.9024870353830957`*^9, 3.9024870425194087`*^9}, {
   3.904017906588855*^9, 3.9040179273644595`*^9}},
 CellLabel->
  "In[508]:=",ExpressionUUID->"8edd1d77-e6da-4feb-ad70-9ef9a39ee410"],

Cell[BoxData[
 GraphicsBox[{{{
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.666434935624927, -0.16074152965638644`}, \
{-4.666434935624927, -0.14279918773074873`}}], 
         LineBox[{{-4.666434935624927, -0.14279918773074873`}, \
{-4.666434935624927, -0.12485684580511103`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.512862916193583, -0.21082813131634534`}, \
{-4.512862916193583, -0.18797780654247617`}}], 
         LineBox[{{-4.512862916193583, -0.18797780654247617`}, \
{-4.512862916193583, -0.165127481768607}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.365237434279209, -0.2632989669493056}, \
{-4.365237434279209, -0.2345469973215615}}], 
         LineBox[{{-4.365237434279209, -0.2345469973215615}, \
{-4.365237434279209, -0.20579502769381744`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.216687967910003, -0.3566572631690621}, \
{-4.216687967910003, -0.32139855568662606`}}], 
         LineBox[{{-4.216687967910003, -0.32139855568662606`}, \
{-4.216687967910003, -0.28613984820419003`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.06536105292994, -0.46745747972557694`}, \
{-4.06536105292994, -0.42419526652454304`}}], 
         LineBox[{{-4.06536105292994, -0.42419526652454304`}, \
{-4.06536105292994, -0.38093305332350913`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.914122845331035, -0.5689431008730088}, \
{-3.914122845331035, -0.514698405238346}}], 
         LineBox[{{-3.914122845331035, -0.514698405238346}, \
{-3.914122845331035, -0.46045370960368315`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.7635736923549876`, -0.8626701091711091}, \
{-3.7635736923549876`, -0.7964022662483572}}], 
         LineBox[{{-3.7635736923549876`, -0.7964022662483572}, \
{-3.7635736923549876`, -0.7301344233256053}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.6135326438036355`, -1.1525510185344587`}, \
{-3.6135326438036355`, -1.0742227707392813`}}], 
         LineBox[{{-3.6135326438036355`, -1.0742227707392813`}, \
{-3.6135326438036355`, -0.9958945229441039}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.4632407195546566`, -1.5017152248825756`}, \
{-3.4632407195546566`, -1.41005416417936}}], 
         LineBox[{{-3.4632407195546566`, -1.41005416417936}, \
{-3.4632407195546566`, -1.3183931034761445`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.312392087877392, -1.8856521240526958`}, \
{-3.312392087877392, -1.7808590241541822`}}], 
         LineBox[{{-3.312392087877392, -1.7808590241541822`}, \
{-3.312392087877392, -1.6760659242556686`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.1619421961108927`, -2.22332528319037}, \
{-3.1619421961108927`, -2.1082563914122274`}}], 
         LineBox[{{-3.1619421961108927`, -2.1082563914122274`}, \
{-3.1619421961108927`, -1.9931874996340848`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.0122836128141244`, -2.3598890593824633`}, \
{-3.0122836128141244`, -2.2461174752588122`}}], 
         LineBox[{{-3.0122836128141244`, -2.2461174752588122`}, \
{-3.0122836128141244`, -2.132345891135161}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.862460876081072, -2.2956902614127905`}, \
{-2.862460876081072, -2.1937841008982275`}}], 
         LineBox[{{-2.862460876081072, -2.1937841008982275`}, \
{-2.862460876081072, -2.0918779403836645`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.7125951720029473`, -2.176508214452238}, \
{-2.7125951720029473`, -2.085544943493963}}], 
         LineBox[{{-2.7125951720029473`, -2.085544943493963}, \
{-2.7125951720029473`, -1.9945816725356882`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.5628941347488823`, -2.1731646768652766`}, \
{-2.5628941347488823`, -2.08972077573492}}], 
         LineBox[{{-2.5628941347488823`, -2.08972077573492}, \
{-2.5628941347488823`, -2.0062768746045636`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.4374531416380223`, -2.2126968740921074`}, \
{-2.4374531416380223`, -2.0797367547735974`}}], 
         LineBox[{{-2.4374531416380223`, -2.0797367547735974`}, \
{-2.4374531416380223`, -1.9467766354550875`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.2835391839395207`, -2.330135642073628}, \
{-2.2835391839395207`, -2.116417581198147}}], 
         LineBox[{{-2.2835391839395207`, -2.116417581198147}, \
{-2.2835391839395207`, -1.9026995203226664`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.1070731189940104`, -2.791523307907384}, \
{-2.1070731189940104`, -2.3825058015469307`}}], 
         LineBox[{{-2.1070731189940104`, -2.3825058015469307`}, \
{-2.1070731189940104`, -1.9734882951864776`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.9611061853143137`, -2.865577296863431}, \
{-1.9611061853143137`, -2.4717248099801705`}}], 
         LineBox[{{-1.9611061853143137`, -2.4717248099801705`}, \
{-1.9611061853143137`, -2.07787232309691}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.812888834502452, -2.96832270422021}, \
{-1.812888834502452, -2.595794031802355}}], 
         LineBox[{{-1.812888834502452, -2.595794031802355}, \
{-1.812888834502452, -2.2232653593845004`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.6618737176539318`, -3.1437355289364457`}, \
{-1.6618737176539318`, -2.7774890160655747`}}], 
         LineBox[{{-1.6618737176539318`, -2.7774890160655747`}, \
{-1.6618737176539318`, -2.411242503194704}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.5118069569724821`, -3.369734719594767}, \
{-1.5118069569724821`, -3.0014914808120676`}}], 
         LineBox[{{-1.5118069569724821`, -3.0014914808120676`}, \
{-1.5118069569724821`, -2.633248242029368}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.3626516648234666`, -3.610865543986424}, \
{-1.3626516648234666`, -3.2445173527933693`}}], 
         LineBox[{{-1.3626516648234666`, -3.2445173527933693`}, \
{-1.3626516648234666`, -2.8781691616003147`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.2121056374941521`, -3.830422715476747}, \
{-1.2121056374941521`, -3.471393411803903}}], 
         LineBox[{{-1.2121056374941521`, -3.471393411803903}, \
{-1.2121056374941521`, -3.1123641081310587`}}]}},
       Antialiasing->False]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.666434935624927, -0.12485684580511103`}, 
            Offset[{3, 
             0}, {-4.666434935624927, -0.12485684580511103`}]}, \
{{-4.666434935624927, -0.12485684580511103`}, 
            Offset[{-3, 
             0}, {-4.666434935624927, -0.12485684580511103`}]}, \
{{-4.666434935624927, -0.16074152965638644`}, 
            Offset[{3, 
             0}, {-4.666434935624927, -0.16074152965638644`}]}, \
{{-4.666434935624927, -0.16074152965638644`}, 
            Offset[{-3, 
             0}, {-4.666434935624927, -0.16074152965638644`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.512862916193583, -0.165127481768607}, 
            Offset[{3, 
             0}, {-4.512862916193583, -0.165127481768607}]}, \
{{-4.512862916193583, -0.165127481768607}, 
            Offset[{-3, 
             0}, {-4.512862916193583, -0.165127481768607}]}, \
{{-4.512862916193583, -0.21082813131634534`}, 
            Offset[{3, 
             0}, {-4.512862916193583, -0.21082813131634534`}]}, \
{{-4.512862916193583, -0.21082813131634534`}, 
            Offset[{-3, 
             0}, {-4.512862916193583, -0.21082813131634534`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.365237434279209, -0.20579502769381744`}, 
            Offset[{3, 
             0}, {-4.365237434279209, -0.20579502769381744`}]}, \
{{-4.365237434279209, -0.20579502769381744`}, 
            Offset[{-3, 
             0}, {-4.365237434279209, -0.20579502769381744`}]}, \
{{-4.365237434279209, -0.2632989669493056}, 
            Offset[{3, 
             0}, {-4.365237434279209, -0.2632989669493056}]}, \
{{-4.365237434279209, -0.2632989669493056}, 
            Offset[{-3, 0}, {-4.365237434279209, -0.2632989669493056}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.216687967910003, -0.28613984820419003`}, 
            Offset[{3, 
             0}, {-4.216687967910003, -0.28613984820419003`}]}, \
{{-4.216687967910003, -0.28613984820419003`}, 
            Offset[{-3, 
             0}, {-4.216687967910003, -0.28613984820419003`}]}, \
{{-4.216687967910003, -0.3566572631690621}, 
            Offset[{3, 
             0}, {-4.216687967910003, -0.3566572631690621}]}, \
{{-4.216687967910003, -0.3566572631690621}, 
            Offset[{-3, 0}, {-4.216687967910003, -0.3566572631690621}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.06536105292994, -0.38093305332350913`}, 
            Offset[{3, 
             0}, {-4.06536105292994, -0.38093305332350913`}]}, \
{{-4.06536105292994, -0.38093305332350913`}, 
            Offset[{-3, 
             0}, {-4.06536105292994, -0.38093305332350913`}]}, \
{{-4.06536105292994, -0.46745747972557694`}, 
            Offset[{3, 
             0}, {-4.06536105292994, -0.46745747972557694`}]}, \
{{-4.06536105292994, -0.46745747972557694`}, 
            Offset[{-3, 
             0}, {-4.06536105292994, -0.46745747972557694`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.914122845331035, -0.46045370960368315`}, 
            Offset[{3, 
             0}, {-3.914122845331035, -0.46045370960368315`}]}, \
{{-3.914122845331035, -0.46045370960368315`}, 
            Offset[{-3, 
             0}, {-3.914122845331035, -0.46045370960368315`}]}, \
{{-3.914122845331035, -0.5689431008730088}, 
            Offset[{3, 
             0}, {-3.914122845331035, -0.5689431008730088}]}, \
{{-3.914122845331035, -0.5689431008730088}, 
            Offset[{-3, 0}, {-3.914122845331035, -0.5689431008730088}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.7635736923549876`, -0.7301344233256053}, 
            Offset[{3, 
             0}, {-3.7635736923549876`, -0.7301344233256053}]}, \
{{-3.7635736923549876`, -0.7301344233256053}, 
            Offset[{-3, 
             0}, {-3.7635736923549876`, -0.7301344233256053}]}, \
{{-3.7635736923549876`, -0.8626701091711091}, 
            Offset[{3, 
             0}, {-3.7635736923549876`, -0.8626701091711091}]}, \
{{-3.7635736923549876`, -0.8626701091711091}, 
            Offset[{-3, 
             0}, {-3.7635736923549876`, -0.8626701091711091}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.6135326438036355`, -0.9958945229441039}, 
            Offset[{3, 
             0}, {-3.6135326438036355`, -0.9958945229441039}]}, \
{{-3.6135326438036355`, -0.9958945229441039}, 
            Offset[{-3, 
             0}, {-3.6135326438036355`, -0.9958945229441039}]}, \
{{-3.6135326438036355`, -1.1525510185344587`}, 
            Offset[{3, 
             0}, {-3.6135326438036355`, -1.1525510185344587`}]}, \
{{-3.6135326438036355`, -1.1525510185344587`}, 
            Offset[{-3, 
             0}, {-3.6135326438036355`, -1.1525510185344587`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.4632407195546566`, -1.3183931034761445`}, 
            Offset[{3, 
             0}, {-3.4632407195546566`, -1.3183931034761445`}]}, \
{{-3.4632407195546566`, -1.3183931034761445`}, 
            Offset[{-3, 
             0}, {-3.4632407195546566`, -1.3183931034761445`}]}, \
{{-3.4632407195546566`, -1.5017152248825756`}, 
            Offset[{3, 
             0}, {-3.4632407195546566`, -1.5017152248825756`}]}, \
{{-3.4632407195546566`, -1.5017152248825756`}, 
            Offset[{-3, 
             0}, {-3.4632407195546566`, -1.5017152248825756`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.312392087877392, -1.6760659242556686`}, 
            Offset[{3, 
             0}, {-3.312392087877392, -1.6760659242556686`}]}, \
{{-3.312392087877392, -1.6760659242556686`}, 
            Offset[{-3, 
             0}, {-3.312392087877392, -1.6760659242556686`}]}, \
{{-3.312392087877392, -1.8856521240526958`}, 
            Offset[{3, 
             0}, {-3.312392087877392, -1.8856521240526958`}]}, \
{{-3.312392087877392, -1.8856521240526958`}, 
            Offset[{-3, 
             0}, {-3.312392087877392, -1.8856521240526958`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.1619421961108927`, -1.9931874996340848`}, 
            Offset[{3, 
             0}, {-3.1619421961108927`, -1.9931874996340848`}]}, \
{{-3.1619421961108927`, -1.9931874996340848`}, 
            Offset[{-3, 
             0}, {-3.1619421961108927`, -1.9931874996340848`}]}, \
{{-3.1619421961108927`, -2.22332528319037}, 
            Offset[{3, 
             0}, {-3.1619421961108927`, -2.22332528319037}]}, \
{{-3.1619421961108927`, -2.22332528319037}, 
            Offset[{-3, 0}, {-3.1619421961108927`, -2.22332528319037}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.0122836128141244`, -2.132345891135161}, 
            Offset[{3, 
             0}, {-3.0122836128141244`, -2.132345891135161}]}, \
{{-3.0122836128141244`, -2.132345891135161}, 
            Offset[{-3, 
             0}, {-3.0122836128141244`, -2.132345891135161}]}, \
{{-3.0122836128141244`, -2.3598890593824633`}, 
            Offset[{3, 
             0}, {-3.0122836128141244`, -2.3598890593824633`}]}, \
{{-3.0122836128141244`, -2.3598890593824633`}, 
            Offset[{-3, 
             0}, {-3.0122836128141244`, -2.3598890593824633`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.862460876081072, -2.0918779403836645`}, 
            Offset[{3, 
             0}, {-2.862460876081072, -2.0918779403836645`}]}, \
{{-2.862460876081072, -2.0918779403836645`}, 
            Offset[{-3, 
             0}, {-2.862460876081072, -2.0918779403836645`}]}, \
{{-2.862460876081072, -2.2956902614127905`}, 
            Offset[{3, 
             0}, {-2.862460876081072, -2.2956902614127905`}]}, \
{{-2.862460876081072, -2.2956902614127905`}, 
            Offset[{-3, 
             0}, {-2.862460876081072, -2.2956902614127905`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.7125951720029473`, -1.9945816725356882`}, 
            Offset[{3, 
             0}, {-2.7125951720029473`, -1.9945816725356882`}]}, \
{{-2.7125951720029473`, -1.9945816725356882`}, 
            Offset[{-3, 
             0}, {-2.7125951720029473`, -1.9945816725356882`}]}, \
{{-2.7125951720029473`, -2.176508214452238}, 
            Offset[{3, 
             0}, {-2.7125951720029473`, -2.176508214452238}]}, \
{{-2.7125951720029473`, -2.176508214452238}, 
            Offset[{-3, 
             0}, {-2.7125951720029473`, -2.176508214452238}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.5628941347488823`, -2.0062768746045636`}, 
            Offset[{3, 
             0}, {-2.5628941347488823`, -2.0062768746045636`}]}, \
{{-2.5628941347488823`, -2.0062768746045636`}, 
            Offset[{-3, 
             0}, {-2.5628941347488823`, -2.0062768746045636`}]}, \
{{-2.5628941347488823`, -2.1731646768652766`}, 
            Offset[{3, 
             0}, {-2.5628941347488823`, -2.1731646768652766`}]}, \
{{-2.5628941347488823`, -2.1731646768652766`}, 
            Offset[{-3, 
             0}, {-2.5628941347488823`, -2.1731646768652766`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.4374531416380223`, -1.9467766354550875`}, 
            Offset[{3, 
             0}, {-2.4374531416380223`, -1.9467766354550875`}]}, \
{{-2.4374531416380223`, -1.9467766354550875`}, 
            Offset[{-3, 
             0}, {-2.4374531416380223`, -1.9467766354550875`}]}, \
{{-2.4374531416380223`, -2.2126968740921074`}, 
            Offset[{3, 
             0}, {-2.4374531416380223`, -2.2126968740921074`}]}, \
{{-2.4374531416380223`, -2.2126968740921074`}, 
            Offset[{-3, 
             0}, {-2.4374531416380223`, -2.2126968740921074`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.2835391839395207`, -1.9026995203226664`}, 
            Offset[{3, 
             0}, {-2.2835391839395207`, -1.9026995203226664`}]}, \
{{-2.2835391839395207`, -1.9026995203226664`}, 
            Offset[{-3, 
             0}, {-2.2835391839395207`, -1.9026995203226664`}]}, \
{{-2.2835391839395207`, -2.330135642073628}, 
            Offset[{3, 
             0}, {-2.2835391839395207`, -2.330135642073628}]}, \
{{-2.2835391839395207`, -2.330135642073628}, 
            Offset[{-3, 
             0}, {-2.2835391839395207`, -2.330135642073628}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.1070731189940104`, -1.9734882951864776`}, 
            Offset[{3, 
             0}, {-2.1070731189940104`, -1.9734882951864776`}]}, \
{{-2.1070731189940104`, -1.9734882951864776`}, 
            Offset[{-3, 
             0}, {-2.1070731189940104`, -1.9734882951864776`}]}, \
{{-2.1070731189940104`, -2.791523307907384}, 
            Offset[{3, 
             0}, {-2.1070731189940104`, -2.791523307907384}]}, \
{{-2.1070731189940104`, -2.791523307907384}, 
            Offset[{-3, 
             0}, {-2.1070731189940104`, -2.791523307907384}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.9611061853143137`, -2.07787232309691}, 
            Offset[{3, 
             0}, {-1.9611061853143137`, -2.07787232309691}]}, \
{{-1.9611061853143137`, -2.07787232309691}, 
            Offset[{-3, 
             0}, {-1.9611061853143137`, -2.07787232309691}]}, \
{{-1.9611061853143137`, -2.865577296863431}, 
            Offset[{3, 
             0}, {-1.9611061853143137`, -2.865577296863431}]}, \
{{-1.9611061853143137`, -2.865577296863431}, 
            Offset[{-3, 
             0}, {-1.9611061853143137`, -2.865577296863431}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.812888834502452, -2.2232653593845004`}, 
            Offset[{3, 
             0}, {-1.812888834502452, -2.2232653593845004`}]}, \
{{-1.812888834502452, -2.2232653593845004`}, 
            Offset[{-3, 
             0}, {-1.812888834502452, -2.2232653593845004`}]}, \
{{-1.812888834502452, -2.96832270422021}, 
            Offset[{3, 
             0}, {-1.812888834502452, -2.96832270422021}]}, \
{{-1.812888834502452, -2.96832270422021}, 
            Offset[{-3, 0}, {-1.812888834502452, -2.96832270422021}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.6618737176539318`, -2.411242503194704}, 
            Offset[{3, 
             0}, {-1.6618737176539318`, -2.411242503194704}]}, \
{{-1.6618737176539318`, -2.411242503194704}, 
            Offset[{-3, 
             0}, {-1.6618737176539318`, -2.411242503194704}]}, \
{{-1.6618737176539318`, -3.1437355289364457`}, 
            Offset[{3, 
             0}, {-1.6618737176539318`, -3.1437355289364457`}]}, \
{{-1.6618737176539318`, -3.1437355289364457`}, 
            Offset[{-3, 
             0}, {-1.6618737176539318`, -3.1437355289364457`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.5118069569724821`, -2.633248242029368}, 
            Offset[{3, 
             0}, {-1.5118069569724821`, -2.633248242029368}]}, \
{{-1.5118069569724821`, -2.633248242029368}, 
            Offset[{-3, 
             0}, {-1.5118069569724821`, -2.633248242029368}]}, \
{{-1.5118069569724821`, -3.369734719594767}, 
            Offset[{3, 
             0}, {-1.5118069569724821`, -3.369734719594767}]}, \
{{-1.5118069569724821`, -3.369734719594767}, 
            Offset[{-3, 
             0}, {-1.5118069569724821`, -3.369734719594767}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.3626516648234666`, -2.8781691616003147`}, 
            Offset[{3, 
             0}, {-1.3626516648234666`, -2.8781691616003147`}]}, \
{{-1.3626516648234666`, -2.8781691616003147`}, 
            Offset[{-3, 
             0}, {-1.3626516648234666`, -2.8781691616003147`}]}, \
{{-1.3626516648234666`, -3.610865543986424}, 
            Offset[{3, 
             0}, {-1.3626516648234666`, -3.610865543986424}]}, \
{{-1.3626516648234666`, -3.610865543986424}, 
            Offset[{-3, 
             0}, {-1.3626516648234666`, -3.610865543986424}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.2121056374941521`, -3.1123641081310587`}, 
            Offset[{3, 
             0}, {-1.2121056374941521`, -3.1123641081310587`}]}, \
{{-1.2121056374941521`, -3.1123641081310587`}, 
            Offset[{-3, 
             0}, {-1.2121056374941521`, -3.1123641081310587`}]}, \
{{-1.2121056374941521`, -3.830422715476747}, 
            Offset[{3, 
             0}, {-1.2121056374941521`, -3.830422715476747}]}, \
{{-1.2121056374941521`, -3.830422715476747}, 
            Offset[{-3, 
             0}, {-1.2121056374941521`, -3.830422715476747}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAB691622qEsCMdploPkfCv9CHse8r
DRLA16O8IagPyL9ABE7NAHYRwGmAb9GiBc6/znBec+PdEMDj9mk/y5HUv5sQ
AwLuQhDAkdE15wMm2789yWmjH1APwGeqOcpoeOC/TgEmhswbDsBA5/+aIHzp
v/xRgc2D6AzAeRlPNwQw8b9UTeWMt7QLwM7Si/SUj/a/UbNHbMd/CsCAdTgI
Zn78vxAcoVmoSwnAg5blhrXdAMDTgZomKBkIwH2vWXAM+AHAHshG41HmBsDA
vb6t3owBwDxS+BhlswXAbSj1LzKvAMB02t6jzoAEwAVtrIa/twDALfHGbud/
A8CNVRAGTaMAwPg8ETGwRALAW2c/V2zuAMBD4cImSdsAwAlloTNfDwPAXoge
4bBg/7/5nDyoF8YDwKCL97iXAf2/3vFNqS/EBMA8fTblCJf6v8QBSClMOAbA
Uv7gfVww+L/Jeyr3DQMIwJ4bBNVrzfW/h2qMg8X0CcCVWoXhyGTzvyL7uehp
xQvATzPDQQ==
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.6931471805599453}, {-8., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      15.954589770191003`, RotateLabel -> 0], 
     Automatic}, {{{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-5.298317366548036, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.005\"", ShowStringCharacters -> False], 
          0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.010\"", ShowStringCharacters -> False], 
          0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.050\"", ShowStringCharacters -> False], 
          0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.100\"", ShowStringCharacters -> False], 
          0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.500\"", ShowStringCharacters -> False], 
          0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, 
     Automatic}]]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.9023903536971464`*^9, 3.902391708520395*^9, 3.9023918583339834`*^9, 
   3.9023928550143104`*^9, {3.9024807638164606`*^9, 3.9024807846615047`*^9}, 
   3.902481760755008*^9, 3.902482151458632*^9, 3.9024825968741984`*^9, 
   3.903581043434984*^9, 3.903581613089927*^9, 3.903584877634364*^9, 
   3.904017686409768*^9, {3.9040179209552827`*^9, 3.904017927915824*^9}, {
   3.9040182666966515`*^9, 3.904018282902144*^9}, 3.9040185733991456`*^9, 
   3.9040193473792596`*^9, 3.904019584995344*^9, 3.9040198119984665`*^9, 
   3.9040198913588333`*^9, 3.907745115959936*^9, 3.9138008551415415`*^9, 
   3.915272690155954*^9, 3.9155254984069705`*^9},
 CellLabel->
  "Out[508]=",ExpressionUUID->"c0e1f18b-f1bc-4346-8c36-f30c0204dd0a"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\Slopes.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.9023903536971464`*^9, 3.902391708520395*^9, 3.9023918583339834`*^9, 
   3.9023928550143104`*^9, {3.9024807638164606`*^9, 3.9024807846615047`*^9}, 
   3.902481760755008*^9, 3.902482151458632*^9, 3.9024825968741984`*^9, 
   3.903581043434984*^9, 3.903581613089927*^9, 3.903584877634364*^9, 
   3.904017686409768*^9, {3.9040179209552827`*^9, 3.904017927915824*^9}, {
   3.9040182666966515`*^9, 3.904018282902144*^9}, 3.9040185733991456`*^9, 
   3.9040193473792596`*^9, 3.904019584995344*^9, 3.9040198119984665`*^9, 
   3.9040198913588333`*^9, 3.907745115959936*^9, 3.9138008551415415`*^9, 
   3.915272690155954*^9, 3.915525498869375*^9},
 CellLabel->
  "Out[509]=",ExpressionUUID->"091a24d5-f5aa-4a23-81c8-fe470b988f23"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.009405741901343087`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.143", "0.018"},
       "Around"],
      Around[-0.14279918773074873`, 0.017942341925637706`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010967017536361975`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.188", "0.023"},
       "Around"],
      Around[-0.18797780654247617`, 0.022850324773869158`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.012711636638629027`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.235", "0.029"},
       "Around"],
      Around[-0.2345469973215615, 0.028751969627744078`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014747407595065404`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.321", "0.035"},
       "Around"],
      Around[-0.32139855568662606`, 0.03525870748243602]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.017156793644581215`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.42", "0.04"},
       "Around"],
      Around[-0.42419526652454304`, 0.04326221320103388]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.019958047264371656`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.51", "0.05"},
       "Around"],
      Around[-0.514698405238346, 0.05424469563466286]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.023200679954517325`", ",", 
     InterpretationBox[
      TemplateBox[{"-0.80", "0.07"},
       "Around"],
      Around[-0.7964022662483572, 0.06626784292275192]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.026956450926287737`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.07", "0.08"},
       "Around"],
      Around[-1.0742227707392813`, 0.07832824779517748]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0313280718376732`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.41", "0.09"},
       "Around"],
      Around[-1.41005416417936, 0.09166106070321554]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03642892824823555`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.78", "0.10"},
       "Around"],
      Around[-1.7808590241541822`, 0.10479309989851357`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04234342193701976`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.11", "0.12"},
       "Around"],
      Around[-2.1082563914122274`, 0.11506889177814253`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04917924407871624`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.25", "0.11"},
       "Around"],
      Around[-2.2461174752588122`, 0.11377158412365089`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05712800220824038`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.19", "0.10"},
       "Around"],
      Around[-2.1937841008982275`, 0.10190616051456317`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06636435612332495`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.09", "0.09"},
       "Around"],
      Around[-2.085544943493963, 0.09096327095827472]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07708133354849644`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.09", "0.08"},
       "Around"],
      Around[-2.08972077573492, 0.08344390113035664]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08738312072938993`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.08", "0.13"},
       "Around"],
      Around[-2.0797367547735974`, 0.13296011931850985`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.10192284393573363`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.12", "0.21"},
       "Around"],
      Around[-2.116417581198147, 0.21371806087548065`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.121593335342102`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.4"},
       "Around"],
      Around[-2.3825058015469307`, 0.40901750636045314`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.14070269155307444`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.5", "0.4"},
       "Around"],
      Around[-2.4717248099801705`, 0.3938524868832605]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1631820493054763`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.6", "0.4"},
       "Around"],
      Around[-2.595794031802355, 0.3725286724178549]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.18978304690109907`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.8", "0.4"},
       "Around"],
      Around[-2.7774890160655747`, 0.36624651287087107`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.22051116356315448`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.0", "0.4"},
       "Around"],
      Around[-3.0014914808120676`, 0.36824323878269966`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.25598110013555175`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.2", "0.4"},
       "Around"],
      Around[-3.2445173527933693`, 0.36634819119305473`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2975700446539446`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.5", "0.4"},
       "Around"],
      Around[-3.471393411803903, 0.35902930367284436`]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.9023903536971464`*^9, 3.902391708520395*^9, 3.9023918583339834`*^9, 
   3.9023928550143104`*^9, {3.9024807638164606`*^9, 3.9024807846615047`*^9}, 
   3.902481760755008*^9, 3.902482151458632*^9, 3.9024825968741984`*^9, 
   3.903581043434984*^9, 3.903581613089927*^9, 3.903584877634364*^9, 
   3.904017686409768*^9, {3.9040179209552827`*^9, 3.904017927915824*^9}, {
   3.9040182666966515`*^9, 3.904018282902144*^9}, 3.9040185733991456`*^9, 
   3.9040193473792596`*^9, 3.904019584995344*^9, 3.9040198119984665`*^9, 
   3.9040198913588333`*^9, 3.907745115959936*^9, 3.9138008551415415`*^9, 
   3.915272690155954*^9, 3.915525498889593*^9},
 CellLabel->
  "Out[510]=",ExpressionUUID->"e54fca62-be44-414a-9018-74380efda5e0"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\Sample playground \
LH-ESRF-E27 SAXS slopes.csv\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.9023903536971464`*^9, 3.902391708520395*^9, 3.9023918583339834`*^9, 
   3.9023928550143104`*^9, {3.9024807638164606`*^9, 3.9024807846615047`*^9}, 
   3.902481760755008*^9, 3.902482151458632*^9, 3.9024825968741984`*^9, 
   3.903581043434984*^9, 3.903581613089927*^9, 3.903584877634364*^9, 
   3.904017686409768*^9, {3.9040179209552827`*^9, 3.904017927915824*^9}, {
   3.9040182666966515`*^9, 3.904018282902144*^9}, 3.9040185733991456`*^9, 
   3.9040193473792596`*^9, 3.904019584995344*^9, 3.9040198119984665`*^9, 
   3.9040198913588333`*^9, 3.907745115959936*^9, 3.9138008551415415`*^9, 
   3.915272690155954*^9, 3.915525498922455*^9},
 CellLabel->
  "Out[512]=",ExpressionUUID->"b030a265-d7ad-4ecb-b325-7a677c0d27ec"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\E27 gibbsite - number\\\\Sample playground \
LH-ESRF-E27.nb\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.892613730066387*^9, {3.8926137664245377`*^9, 3.8926137937077703`*^9}, {
   3.8926142852401514`*^9, 3.8926143002994194`*^9}, {3.892614340901927*^9, 
   3.892614358607253*^9}, 3.892614471834504*^9, 3.892696073832374*^9, 
   3.90203711736994*^9, 3.9020422080653267`*^9, 3.9020422780029826`*^9, {
   3.902042309103794*^9, 3.902042338473694*^9}, 3.9022934677601023`*^9, 
   3.902293500826844*^9, 3.902293816575324*^9, 3.9022962202790785`*^9, 
   3.902296689468522*^9, 3.9022975455583563`*^9, 3.9022976074891615`*^9, 
   3.902298382383033*^9, {3.9023894179597816`*^9, 3.9023894398366013`*^9}, 
   3.9023903536971464`*^9, 3.902391708520395*^9, 3.9023918583339834`*^9, 
   3.9023928550143104`*^9, {3.9024807638164606`*^9, 3.9024807846615047`*^9}, 
   3.902481760755008*^9, 3.902482151458632*^9, 3.9024825968741984`*^9, 
   3.903581043434984*^9, 3.903581613089927*^9, 3.903584877634364*^9, 
   3.904017686409768*^9, {3.9040179209552827`*^9, 3.904017927915824*^9}, {
   3.9040182666966515`*^9, 3.904018282902144*^9}, 3.9040185733991456`*^9, 
   3.9040193473792596`*^9, 3.904019584995344*^9, 3.9040198119984665`*^9, 
   3.9040198913588333`*^9, 3.907745115959936*^9, 3.9138008551415415`*^9, 
   3.915272690155954*^9, 3.9155254989453707`*^9},
 CellLabel->
  "Out[513]=",ExpressionUUID->"7359b59b-89de-4ca7-a817-8841666b143d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fitting slopes using L + R (thickness + radius)", "Subsubsection",
 CellChangeTimes->{{3.8890831159415197`*^9, 3.889083129907494*^9}, {
  3.8895043397252035`*^9, 
  3.889504346042064*^9}},ExpressionUUID->"c264222d-eedd-4632-bf2a-\
25682c9a5ec9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fitSlopeLRResult", "=", 
  RowBox[{"fitSlopeLR", "[", 
   RowBox[{
   "datamerged", ",", " ", "1.7", ",", " ", "0.4", ",", " ", "4", ",", " ", 
    "0.2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8890831508560247`*^9, 3.889083186178582*^9}, {
  3.889083221328817*^9, 3.889083280853166*^9}, {3.890210231443339*^9, 
  3.8902102343651667`*^9}, {3.903581167649135*^9, 3.9035811875141273`*^9}, {
  3.904017969584984*^9, 3.9040179705381403`*^9}, {3.9040189239216633`*^9, 
  3.904018930518894*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"245caa09-fb84-4947-ab47-dd7c0b5b4707"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.7605018769626213`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.5026126449242925`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.034680000991692`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.24209877913188488`"}],
  SequenceForm[
  "\[Mu]l = ", 1.7605018769626213`, " \[Sigma]l = ", 0.5026126449242925, 
   " \[Mu]r = ", 4.034680000991692 " \[Sigma]r = ", 0.24209877913188488`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOokX2vXI6pf3WEQDt
65Lz
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"959ee1a4-35cc-4e1b-9097-dd551f9e9666"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.7938057550822821`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.5565570495196202`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.03745134182324`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.23715309738891116`"}],
  SequenceForm[
  "\[Mu]l = ", 1.7938057550822821`, " \[Sigma]l = ", 0.5565570495196202, 
   " \[Mu]r = ", 4.03745134182324 " \[Sigma]r = ", 0.23715309738891116`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOoiVmL3I5pf3WEQDr
cJKO
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"b3dbd599-b389-4d42-958c-b2e06ff59c11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.825521067071087`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.5572082289449841`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.030109847070812`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.19406446086842144`"}],
  SequenceForm[
  "\[Mu]l = ", 1.825521067071087, " \[Sigma]l = ", 0.5572082289449841, 
   " \[Mu]r = ", 4.030109847070812 " \[Sigma]r = ", 0.19406446086842144`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOoi/vMnc9pf3WEQDv
pJL+
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"d8b90fc0-a092-474c-ad30-23fd15f84f5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.8387740652136872`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.5373503991029126`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.0447609820500565`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.2057286075548086`"}],
  SequenceForm[
  "\[Mu]l = ", 1.8387740652136872`, " \[Sigma]l = ", 0.5373503991029126, 
   " \[Mu]r = ", 4.0447609820500565` " \[Sigma]r = ", 0.2057286075548086],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOoidsPOp6SvutIwDw
oZNA
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"6e98f3b7-a472-4e00-90f3-040b63ca2f54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "1.888976580363233`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.5086108939354352`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.05131034408235`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.2114884911754312`"}],
  SequenceForm[
  "\[Mu]l = ", 1.888976580363233, " \[Sigma]l = ", 0.5086108939354352, 
   " \[Mu]r = ", 4.05131034408235 " \[Sigma]r = ", 0.2114884911754312],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOosN7w91Oab91BADr
TpJ2
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"19398ccc-4e2e-42b7-b11b-c84f07296ebc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.0729538532459433`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.4008022488073892`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.0607007581363765`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.21593208330956118`"}],
  SequenceForm[
  "\[Mu]l = ", 2.0729538532459433`, " \[Sigma]l = ", 0.4008022488073892, 
   " \[Mu]r = ", 4.0607007581363765` " \[Sigma]r = ", 0.21593208330956118`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOos8yPXE7pf3WEQDu
f5Lu
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"cf3e1b1a-b554-4818-bfa8-42b5e3953514"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.035022491481477`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.40728559044643026`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.049423977592369`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.21098446114597386`"}],
  SequenceForm[
  "\[Mu]l = ", 2.035022491481477, " \[Sigma]l = ", 0.40728559044643026`, 
   " \[Mu]r = ", 4.049423977592369 " \[Sigma]r = ", 0.21098446114597386`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOoj10qt1Pab91BADp
DJIr
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"e03eaa1f-bfac-4e05-aa11-bb0623aa6649"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.0597055905072468`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.3990791893544614`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.047834940322127`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.20747891694009885`"}],
  SequenceForm[
  "\[Mu]l = ", 2.0597055905072468`, " \[Sigma]l = ", 0.3990791893544614, 
   " \[Mu]r = ", 4.047834940322127 " \[Sigma]r = ", 0.20747891694009885`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOonWM+T1Oab91BADl
2pGr
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"105845e4-b440-4a1a-a695-f774ef7d8484"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.0627725639001566`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.3970027815276339`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.046917480827503`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.20826968067868715`"}],
  SequenceForm[
  "\[Mu]l = ", 2.0627725639001566`, " \[Sigma]l = ", 0.3970027815276339, 
   " \[Mu]r = ", 4.046917480827503 " \[Sigma]r = ", 0.20826968067868715`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOopUOzPY4pf3WEQDs
rZK6
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"7a30c8d5-aa14-4be2-bb98-8cbdfed22a58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.0620395598950676`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.3975080587945955`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.047314943550727`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.20799785859885822`"}],
  SequenceForm[
  "\[Mu]l = ", 2.0620395598950676`, " \[Sigma]l = ", 0.3975080587945955, 
   " \[Mu]r = ", 4.047314943550727 " \[Sigma]r = ", 0.20799785859885822`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOohes1PU8pf3WEQDt
bZK0
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"8966fbdd-13ad-41f1-874e-49a85d14c2da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.061978253611054`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.3975506780760722`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.047279182169195`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.20801583716577848`"}],
  SequenceForm[
  "\[Mu]l = ", 2.061978253611054, " \[Sigma]l = ", 0.3975506780760722, 
   " \[Mu]r = ", 4.047279182169195 " \[Sigma]r = ", 0.20801583716577848`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOoneYHfI8pf3WEQDu
hpLu
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"95cdc9d9-5ec4-4e72-b8b5-d17317712c69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.0619978786469737`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.39753673567899733`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.047285895160181`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.2080121538298519`"}],
  SequenceForm[
  "\[Mu]l = ", 2.0619978786469737`, " \[Sigma]l = ", 0.39753673567899733`, 
   " \[Mu]r = ", 4.047285895160181 " \[Sigma]r = ", 0.2080121538298519],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOopdZBHud0n7rCADr
b5Jw
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"7e0e8326-f412-42ab-b172-fcaee15e5031"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.0619975988114105`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.3975370175747169`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.047285959647775`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.20801219208694477`"}],
  SequenceForm[
  "\[Mu]l = ", 2.0619975988114105`, " \[Sigma]l = ", 0.3975370175747169, 
   " \[Mu]r = ", 4.047285959647775 " \[Sigma]r = ", 0.20801219208694477`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOoj0aHnid0n7rCADt
xZLn
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"b1dc31d9-ef59-476c-8f92-193548f474f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.0619976162956357`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.3975369992947539`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.047285953863512`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.20801219317848066`"}],
  SequenceForm[
  "\[Mu]l = ", 2.0619976162956357`, " \[Sigma]l = ", 0.3975369992947539, 
   " \[Mu]r = ", 4.047285953863512 " \[Sigma]r = ", 0.20801219317848066`],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+Iz6ZzTy/6+cYxbO2c1iJ7ztHY3iH6smXcIRPtu7Z3u
+e+N45+wez5eQFog6It/IZDeJvnsGoievDQrfBLDW0ePrQtXg+itEmfadoH4
KsKTuoXeOgZKKx7iEH7r6Ka8/iWIbmiWEeMC0RrlASB6v4j7bhC9o87/MIje
c/u2MjeQlim9N9scSHeVLeWxANIxq8+eBNHrXoa4WALp3dwqJilAOoD3/FoQ
3Xn89n0QbZy+WTwVSBtebWmsFX3reGUN43YQfVltQmA9kLZKnXE8SOyt460J
T9+BaIsvnsLBQHrhVn9PEF1X96cYRHPNsZsEoh+J/tkOogWt/nqf0n7rCADq
1pKI
  "],
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"46f9c7fd-c5f5-43fb-a1b3-63b3069e57ef"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 171, 69, 17111369629343451834, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9022978287965794`*^9, 3.9022985253178587`*^9, 
  3.902389693580163*^9, 3.902390537087313*^9, 3.902392488509506*^9, 
  3.9023929707627907`*^9, 3.9024811558948226`*^9, 3.902482005155732*^9, 
  3.9024824829206305`*^9, 3.90248302115705*^9, 3.9035813963796997`*^9, 
  3.903581798560201*^9, 3.9035850619954324`*^9, 3.904018115116209*^9, 
  3.9040184479133687`*^9, 3.90401874552055*^9, 3.9040191262558374`*^9, 
  3.904019474686859*^9, 3.9040197358781166`*^9, 3.90402000360742*^9, 
  3.9152728628417006`*^9},
 CellLabel->
  "During evaluation of \
In[171]:=",ExpressionUUID->"994503c8-c001-40c7-b029-82c7f8cd9036"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]l", "\[Rule]", "2.061997614424162`"}], ",", 
   RowBox[{"\[Sigma]l", "\[Rule]", "0.3975369997864182`"}], ",", 
   RowBox[{"\[Mu]r", "\[Rule]", "4.047285951551103`"}], ",", 
   RowBox[{"\[Sigma]r", "\[Rule]", "0.2080121928938761`"}], ",", 
   RowBox[{"\[Mu]lx", "\[Rule]", "8.508072745291477`"}], ",", 
   RowBox[{"\[Sigma]lx", "\[Rule]", "3.5204094574723044`"}], ",", 
   RowBox[{"\[Mu]rx", "\[Rule]", "58.49378374060468`"}], ",", 
   RowBox[{"\[Sigma]rx", "\[Rule]", "12.30023266865019`"}]}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwA+KIvA9p136+cTz15ls2iBb84MB7HUj/undPesmvN452
xg9jvgDpVWe3F4DoZaK7fv38/cYxZGL80V9A2mrO+ct/gLTH3f3MDH/eOKYF
sWiD6JcvbjSAaKd+jb7Sv28c3xzbfQBEf/qdwFoGpBPvHJ0Aol+sVpoFov+k
K2wH0fxP/faC6AvmRw6BaKPyxeJe/944PnmnuwBEn5NQqy4E0jcYul6D6BSh
xJxJDG8d16wt2Aaia2bcW7cLSE/xvj2vW+it44o9pWc5hN86ZvSs+Qeiv9z7
r8wFpK85VaeDaA9Wib0g2nXdrDsg+t6h1cbcQPqxw7bt5kB6S4qKogWQ/pYm
JGoJpEXeRQaC6DDuxoQUIG3zZOkpEN0nE8+WCqR/LVjmCaIPCfXNqhV96+jw
89IZEP3t1IGUeiAtEJRyI0gM6J7Z/xiDgbSCupE6iBYzPhkGojeZhzeBaD7V
v4tAtFFhyRGwvNid4FPabx0B/rTiwQ==
  "],
 CellLabel->
  "Out[171]=",ExpressionUUID->"bd81d288-6fc6-41da-9faa-0629a3d65350"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
          "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
          "]"}], "/.", "fitSlopeLRResult"}]}], "}"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"Optional", ":", " ", 
        RowBox[{
        "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ", 
         "for", " ", "readibility"}], ":", " ", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "6"}]}], ",", " ", 
           RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
        ",", " ", 
        RowBox[{
        "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
         "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent", 
         " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
         "color"}]}], " ", "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
        ","}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}]}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"slopeFitParams", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "2.22", ",", " ", "0.398", ",", " ", "4.09", ",", " ", "0.208"}], 
      "}"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"slopeFitParams", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "2.06", ",", " ", "0.398", ",", " ", "4.05", ",", " ", "0.208"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"FitToPlot", " ", "=", " ", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{"\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}],
         "]"}], "/.", "fitSlopeLRResult"}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FitToPlot", " ", "=", " ", 
     RowBox[{"calculateIntensitiesLR", "[", 
      RowBox[{
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsA", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", 
            RowBox[{"10", "^", "0"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], ",", " ", 
            RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "False", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Data\>\"", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "}"}]}], ",", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
         ",", " ", 
         RowBox[{
         "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
          "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent",
           " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
          "color"}]}], " ", "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
         ","}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", "  ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsB", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"FitToPlot", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "400"}], "}"}]}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "True", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Fit\>\"", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", "  ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plotIntensityFitPlateletsA", ",", " ", "plotIntensityFitPlateletsB"}], 
     "]"}]}], "\n", 
   RowBox[{"(*", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
         "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
      "plotIntensityFitPlatelets"}], "]"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotIntensityFitPlatelets", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"plotPlateletsFit", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"slope", "[", 
          RowBox[{"datamerged", ",", "0.1"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"slope", "[", 
           RowBox[{
            RowBox[{"calculateIntensitiesLR", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
             "]"}], "/.", "fitSlopeLRResult"}], "]"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"slope", "[", 
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"slopeFitParams", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{"slopeFitParams", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"slopeFitParams", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", 
            RowBox[{"slopeFitParams", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], "]"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<Binned data\>\"", ",", " ", "\"\<Form factor fit\>\""}],
          "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "8"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Black", ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|
             "color" -> RGBColor[
               0.6745098039215687, 0.07450980392156863, 
                0.043137254901960784`]|>,
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", 
         RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitA", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", 
            RowBox[{"10", "^", "0"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "0"}], "}"}]}], "}"}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<Data\>\"", ",", " ", "\"\<Fit\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", "False"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitB", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ",", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}], "]"}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Fit\>\"", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Black", ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.006", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|
             "color" -> RGBColor[
               0.6745098039215687, 0.07450980392156863, 
                0.043137254901960784`]|>,
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", "True", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
         "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
      "plotPlateletsFit"}], "]"}], "*)"}], "\n", 
   RowBox[{"plotPlateletsFit", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"plotPlateletsFitA", ",", "plotPlateletsFitB"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", " ", "cm"}], ",", " ", 
      RowBox[{"7", " ", "cm"}]}], "}"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotPlateletDistributions", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lengths", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{"LogNormalDistribution", "[", 
               RowBox[{
                RowBox[{"slopeFitParams", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                RowBox[{"slopeFitParams", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "lengths"}], 
             "]"}]}]}], "}"}], "\[Transpose]"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Probability", " ", "normalized", " ", "by", " ", "the", " ", 
          "maximum", " ", "probability"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"radii", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{"LogNormalDistribution", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"slopeFitParams", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "+", 
                 RowBox[{"N", "[", 
                  RowBox[{"Log", "[", "2", "]"}], "]"}]}], ",", " ", 
                RowBox[{"slopeFitParams", "[", 
                 RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ",", "radii"}], 
             "]"}]}]}], "}"}], "\[Transpose]"}]}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"+", " ", "Log2"}], " ", "to", " ", "obtain", " ", 
         "diameters", " ", "instead", " ", "of", " ", "radii"}], " ", "*)"}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "->", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Size [nm]\>\"", ",", "\"\<Normalized probability\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Thickness\>\"", ",", " ", "\"\<Diameter\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletFitDistributions.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletDistributions", ",", " ", 
       RowBox[{"ImageSize", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", "cm"}], ",", " ", 
          RowBox[{"5.5", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9047041588130727`*^9, 3.9047041834942837`*^9}, {
   3.904704239239035*^9, 3.904704239555138*^9}, {3.904704277226678*^9, 
   3.9047042774747334`*^9}, {3.904704318065693*^9, 3.9047043228759503`*^9}, {
   3.904708709016622*^9, 3.904708807563364*^9}, {3.9047088470234118`*^9, 
   3.90470885261018*^9}, {3.9047089104527764`*^9, 3.904708919096072*^9}, {
   3.9047089807309246`*^9, 3.9047089808219585`*^9}, 3.9138008819327555`*^9, {
   3.9152734884915113`*^9, 3.9152735031901894`*^9}, {3.9152735930279155`*^9, 
   3.915273618214839*^9}, 3.9152736512548666`*^9, {3.9152736850202513`*^9, 
   3.9152737003693647`*^9}, {3.9152737435263186`*^9, 
   3.9152737623748655`*^9}, {3.9155255141441326`*^9, 
   3.9155255990166407`*^9}, {3.915525781424061*^9, 3.9155257902072496`*^9}, {
   3.918727442696492*^9, 3.918727444184583*^9}},
 CellLabel->
  "In[1380]:=",ExpressionUUID->"85ce006d-ee89-43bb-bf0d-5c3aa03e6f84"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{}, {{{
         Directive[
          AbsoluteThickness[1.6], 
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], 
         PointBox[CompressedData["
1:eJwVlnk4Vm8Tx9Wz7/tDJRWhUnYp0TNZSipRiSKUaCGhlPQLqVRa0UoLIbRQ
UYpyJlEiQoqKFhVK2XfKe96/zvW5Zu65Z/nOOWfKhu0rvMcqKSk5U5SU/v+c
MWtX3ltLCX40pE1Yu0wZXlQ2txvqS/BaNf7aa6cMrmuv+/6YKMH66pnl22yU
wbZiUPcXR4LV/2LLYaEyHDpav2H+kBhvZt1ZqUX6F8YvdvrcIsar6xiFZqT/
9vDq7aW1YvzwJeW9hqUyaLuD49/nYozWLI/cuEAZytihScEPxDihTf1F/zxl
0LDI0zG4LsZrY1aMzpirDCOf8t7OOidGSLh2nWKmDItAcmVLlBgN12t7rjRW
humD9+Mbd4mxxTLXY4G+MvCTj/Wf2yRG4myk3X1dZXhUr9170EWMxt/Hbz6n
pwzRy88131gsRm/zFct2kfzkuoUJY54YV9UHaF/UUYZTl985XZgpxqHooL5E
LWWw3B1c5aYmxhn3TKaoTCX7sS5FsVIoxm7nCRM+aSjDuf0/IXSsGN88NSIq
JiuD0X9JZyp7RKh2xeP2RFVleKhp3LeqWYTtNMP3PuPJ+o7qGdE/iDDOr3Zu
i4Tsh/qfqd9eidDr7IMTiSJlWPh5IOsXIcJdGG5/l+Tw+/ufTcgWoeq1Bgny
lUEofOMSfF2ERb7y49MEyqCz611Q30URth0bPfqdowyxFZcmXjkhwjGTpMZ7
GMrw7H7bNt/9IjyxN/sPUpQBfb5FrAsWIfvvyhH9scrAfbpv744tIlwT/1qD
PyqH0lH76FvrRJjNYX3NHJbDzP0e9YwVIqwaw9V5NigHo8VN9w8uFOHGGdrp
4X1y6JKvXqk+T4TT4hyMjHrkMHBp7shnPRH2+uv6be+QQ4Td5H+Pp4rQkhfH
EbTJ4eaI662H40Qo7P4TU94ih+mmhR7VfBFyHv1VffhDDrY3A3axqCLcUbTe
2/ebHLbWnVm5blCI44JMVwm/y6H8zGyP8jYhPh/vNsT9LAeZI42+5rsQvZRj
5817L4epv7Ufjb4XYv7DH+5/6uTQ285vw9dCTMvTVppVLYcs8WK1S8VCDDq+
g/etQg6Bt+HZ6XwhmlO2nhS8lMOYOQd8rtwV4km12JHx5XLYNb3pSFGaENu0
dbo7n8thmnrjg7FXhCjnMidrP5VD3NHVO13OCLHef21/a4Ec5o3duqo4Wojt
7WaDqflycJ20/qftfiEW3T2r/Jvk++/fY+NuIXoGv4zOyCH7+yIwMtZfiC75
lxe23pHDgnt+T529hTglsSxb67YcLCL2TzB0E6K+aqLI9KYc5vpQDKasFOI2
i7/Bs1PI8ztKU6baCdHe3Nmj7IocTCdNVDVfIMRXmp+2llyVw93q+Pmb5ghR
einKyCheDgYu2g9S9YT4uPSdDSNWDg9m1er2awmRd2R6R8AZsp6M+tWuakJ8
mHJQq+6EHC62BH+qkglxU+Ofh6eOySFy78fda3lCHL7rmrz2sBw0S/Vqe6hC
rCT+DGcekIPTok8bFwwKMOUg5zwrUg7nmjAyv0WAc06d0V7znxwOa/D2OtcJ
MFN3Ufm1UFIvzlOLpCUC3LB1/sj9IDnc2Z5e25UrwIaze0N7tstB9HW9YWea
AH1q3X6Z+JHzTtdaJbggwB/0S6xRbzk8My0klh4RoMvURrbpRjm8Xv1pKD1E
gDMN+HktHnK4Xv/7hMYWAZZeuM7d7SyHBmsx9fEaATZ7cn98dZLDSoGoNdBO
gBO9Rg5sWSWHiSf0elUWCvAq0oPDdsuh55vJG+t5ArQ9rPp0tYMc9gVaLzee
Sdov/SlavVgO+l0zWxQTyXy3vbSssJKDo71v/yFlAa4yySaMt8ihzqhz2Sa+
ANUPaDxttJADTTjKuzHKx93vn341MZPD52PWRYxOPq79skVVc7Yccpo+a478
5KMx6972k2vl4N1ZyY9o5GOS2lHtBgMyXmDxCXENHxPZHNuFs+RQ6LjwW0Ex
H1c7J7RrTpeD1YuZrduf8HF89CLDH0vk8PaCX/bBXD76D045vk+d3F+Yk+KV
wUeLoPKA3ClyaHofuc41gY9Xs57bF4yXw+lY2t53MaT/9b2tL8zlcOFW1xHf
E3x8tK81X1suh/fz26riwvm4aa5JYLhEDluWnf7xJpCPHh9WjLvFl8NYP6UH
mpv4qPOicWfzTDksmXYpSGcjH7UGehu/Mkn9BAVNj1/Nxyibvz9nK5H6APrj
SYv5aN7x5evrERk47ogUrrLgYzsHvoyZSO5bbHVD/jw+ytK/vlw5JAOWRqWV
vy4fJ6X3rojpkcHO074ps6fwUc3GS0ulTQbFg6J7LlI+Bu+qsOrhku+D13tz
pSQz3y21b2mWgUX7nNlMBh9Pva7V+fJNBlQdo4/CIR7STN695HyWQaqF3Qbd
Pzx8feHIJp0PMpj/Okxb5zcPKXq681OHZWA+mnLE8wsPB599qd1VI4Mkqwxu
2hsevmqjKihVMggZ7L495gUPbVzHNXWXyuBqzJhDz4p4eKpstNntlwxUDzvO
Csjjocf9ZPXNT2Wg5/VgaddtMv6hqdWt+TJoNhMVH07i4XJOzNb/cmXwKOfo
ovFXeEgdKDkZWyeDyYva/PXP8vB00M7kMXdlkBe2hvb7CA+FQUv7jt+SgW9b
kn3efzz0ed/pvuu6DETm3TunhfBQ69fhsuHnMjj5TVWcEMDD3O0Nb71Iez8x
SeXkRpKXjNhtuSyDweHB6XEuPFT3KdomvCiD/+a2rm5ewUPvQZvbY+7LgO/U
LrqxlIfWl9LLiuNkEK1tmFANPFSuMgNGjAw+dzbEcE14eHt3Q+BIlAzKD4xe
ctDlofaCTX1TkmUgVOoqdJ5O1nNsotuPcBnUWywdyZ7IwxXeJwIX7JaBv24K
d4qYh317xy20DZCBhn3DEnc2D41FTspcMr4pM+rZFToPzZOti1JJe2n3ss6Z
w1zcccZjxb0tMjjsp7GprJ2L289UFlhukEFZ/8xMdjMXZ011OZu5j6zvaU/f
nu9cDPL668h0lcGbh0E75rznYmbzFJsaJxlE2nHv0Cu4+Oar8pt7y8l5PfTd
6VDExX8eiwxit8rAOfJXxPdCLmZze1aft5XB8t2/86pyudhTfn3nDCsZHF+f
bFRxi4u8U/PXFJqT+Zj92j3jGhfdk2vGypxlkFZq//R9EhfrLUYSOKYyaK2t
M+s5x0WmKyum0VAGBberd088zkUtyCvzmCUDp9YAB6f9XHwsq30VpiWDD4PV
H+MiuDiUnywWkffR5x+5nLCLi+31Uu6aSTLYwome0+HLRSI43OKKsgzU06u7
VqznYoDn8u0tYvK8U3PfYQ8uOtwIyNDWI/N76vvw2Wou/n4V5FrFkYFu2mtX
y6VcvKak0p5MI/XRW/iwYgEX/Y88lDX8k0JMS0TQWAUX++5f3mU3QQYLzpy/
udmUi6rfXe2FA1Lg1k4XCWdxMeStV29YpxT8HjU8L1Lnog1RbSP4JQWNQ2fE
o2pcHPlwIe0QGf+T5qUbUSpkP9ayri37LoUah8p4Jz4XvTMC6gwbpCCe6r3L
gErO89+GtKR3UpB8PvF2zygHt5Z/znjbIYUVeYWq44c4KPyW0SV+LYXbv8q2
CTo4WP14y/qiEil4fPu4WNTEwU8OX1c1PJPC6NT/Wvy/cPAwf1WLpF4KAW+e
xUyq52CMz+L5RQVSeHWtRMusmoOL9ekT1+VKYevDxF+eJRzMOlS9w+iuFHqq
4NKHpxzcH3bqWMxzKcgqAom4Ag4SnQNmb65LYULVm/DqHA6embPmQ2miFP6F
FqlNvMlBl/WBJZvipWBtOPfAo2QO6v986HjzjhTMZ1/fvSOJPH/l4zLTs+R9
jov8357n4KVz+TPghBSMHT42WZ7k4L1fVpk90VIwPbl/NjOKg2sF97+MkPFM
WIPF+Qc5KNfF1aPhUuiruNCh2MvB6N/Nta67yX4mi5e+DuSg3abUuspAKRjt
mpPwbDMHky/J2I4HpeAbolqwheSmM5JTL3ylsHBnyUyBBwd3VvSYDKyXwgnb
A2GEEweNZiv9/uQuBf/j4vjQpRz0th8XnuAihX63u5EtS8j8o1e3T/aXQqd6
nA9YcTDwTmJ41CopsG7sLhOacfBxwro9VYukcLor6k6rPgcnzctwKwNSD18C
VXfqcXBGlD5H11kKSvs//K3U5uCYuR5RZ8ykkCRvSEA1Du6lHM46aiSFsVaL
d+TJOJjxdpbxyhlSGJlqEuol4SCH/K26vUAKgX+1txVwOVi5N5F1Rp3Ux8LX
Qa8oHNwVmZ5OmSwFQeWXbd+H2BjyIImSLJdCop7hQHY/Gw9MPv8ngIy3K8vW
lt7FRr8LqfMrRFJwkZj/NvjJxq5Zk5SiWFIwoMyx3vSFjVP2vZ2uPFYKar4h
PK96NsYenzpli0QKt6Yqzbtey0an9IT65j4J1B++nN9WwUaLBOMpizslMLhn
3V14zkaV35bWib8lMHGQMtn/KRtfmH3XYYxIINS9knHpCRtveT2aT/smAfeT
JTeU7rMRdA3OEB8lcNBiTZT/LTaqylrVWqolkLlqXEv1dTZ2E163z36XwDfv
t1E/ktloMFG5s7JMApEPKy54J7CxZ1vvP9VCCXDOSDPaYtl4ebaxXsMjCTgm
142cPM7GDjU7Z+dXEqhRyk6JiGajoY3DvtBcCZjc6wyZEMlG9+m7TLozJaDO
Wykh9rDxzck87cdpEmCXS2YnBrGRe6zkd3uOBJ4axa33DWTjvvGeh6qvSoAm
T3OcvIWNhbqWX3POSkByOL+qwZON/lf/YzBjJZC/QTuCuoaNR9JmXlt1WQLr
nY0rk13YaJRy3Sc6WgLbdtycF+TAxnDhFVrwIQm00zvGLrZlY1Hv0Pa7eyWw
I4UmmwZsbNx875rFTgkMhQuzHynY+CrDaf5S0t84UGO9YA4bVwwuf2e+TQLa
Ttnv/umxsbSp4MdzLwmo6Dl692mzUSZZv1m+TgJXT31rf6LFxg25x0+cIf1L
uKUjvZPYeDTzv9ePV0ugyWfCib/KbFzb9KV72xIJNHgG0XlCNk7T8l111VoC
h4uLjQV8Nt5+Huj/xEkCq7g6a6YyyfmKbyJ7gQTs77wOtlJiY9ZXlRORphKo
k6gs2zrAwquUFrt0AwmAP/XRzV4WwvLTF4ItJKD1quX1hQ4WFiebfGzTIu2n
YxsrWki7nLX0ySQJDNQ3nOJ+ZaF4xl2rv+MlMP7Ij2cxDSwcvhIkkWmS+jPz
fuz4noX9fbdXP5WQ+njxaM2VKhb+sS7xf86RAH/auTVdL1k4bn5Q29gxElh7
wjGKKGZhwkrBpXC+BB41NdxeVkjG50+q8RgWw+cPl2zv5LHwqDf1iVaPGOAk
XXV8NguDP2RKTreJod6RssMok4U/vmzZMq5PDM5pweOP3WShuU/faGCzGCSr
fWdTUlhI43mcn1gvhoXPTm6IvETW/8X2mt1bMUzsHKxrPcfC+WVGRR9Ie3bk
rRjmWRZaHbtkYPFaDA8YDx6cPcHCFQ86u8cWiWGL6tOi6VEszIiNmNGYL4a4
Nb5mzeEsXFf8zjCNtC9zZWQVhbHwit+yjWYPyXxu/tjss5uFC47Zfxi+J4Y1
BR9/8ANYOHFy+H1muhjsLmpqTd3CwgsvLhbeui2Gwphj4wo2s9Aw9Pbx/mQx
XOp82L9jPQvza+OPMxLEUPTXdqf+WhZqzI+Zw4oRg/3dBQe6V7CwvWcoa+Cw
GFh/d0mSSB5ubC05d1YMNL+XKk+WsFB0pn2x034xUMO0pp+wZuETw5VWpWFk
fvcL0r0sWLi48IAsbacYlKuaM9zMWbhrUsPw3H1iOPtHfhxms7DlgnniQl8x
7E6qfqGhR+pj61vtgxvF4BiW7cCbxkK9gAOfDnmIYa7N3wQnLRbGS5bNVvYm
+zV4YcLfySzsE9cfb1othpnN4RO7x7Ew7muKp+MSMUyVRi5pF5P1pSs3pVqJ
Id3L5WC0kIW9YqMGgb0YHn5+G9/JYWGs5hnPsHliuFJXrjREZaEBUTPe0kQM
dNe6IOY/Ju5zvWrvZygGd4Po2UNDTHz1O+BN7GwxeOmHN6n2M/Hh8+gJx7XF
8EF/k6NpBxOTvO3HT1ETw4Km5RnOP5m4SdjhsFxFDCnxrhuSfzDxRk9SaAFp
v6Mv+b6vkYnNjZSjIUIxxP9O6c/4yMT/ohdfncwWw7p48YePNUzUjLB9dWSM
GLbXxn47WMnEA/rPyjcwxLCKcWC/pIKJCpk8cc2wCJYMmHx3eMHECidOrV+v
CDa/PTAQh0xs/d0sLfolgtzDZVcu5zNx4gTPiB/tIvBzbsipf8TEt0YRu2q+
iGDl7DKBTjYTlXO2hTvVi8D6/Z/RsFtMnBPbv9bnjQhqM/w8f19nYtCc0aZ7
dSJ4w/i7ty6ViblOxve7ykUQeelFqOlVJnrnWkamPhdB1Byj7oQLTNzb8tUy
mBDBxDfB0wNimUh9sLvZ4qkISgbm1dNI1t84vvvVAxEoz+yZGXyMib1xlnHN
mSI4zD5Y//MgWU/IQsP/UkUwsG16o1cYE4WV04M6rogg7lh0rTbJG74q1mfe
EEHxMVOTb7uZuMdcnuoYL4IjWfLyTYFMbDr8oiXhtAiG+qySOrcy0f6Byvlt
USIo8nsZICa55HHhzkdxImjiO2ZEbGRieHSbjU6ECMzVPaul7kxU3XnCyTFU
BLPmzZue6cxEj6Lbro8DRbDNJGys3momji293nJhnwhEPzUSljoykbnD8cNa
XxFYHhue1GHHxFuzVjEWbhLBgsoHWResmTiNvyKy2EMETs8f7//PkonbrM10
B31EcC9kneXC+UwMPPWSbeskAosJ7MoBUya2c+sSGA7kPH/+dLhjwMSUbsWr
tCUiyEqJkg7pMtF/1vHun8tFsDTY/ImfDhPPnS0co20pgh57iXw2yb9K8hcP
TxfB7JCVPF1NJl53NNacbiYCjfjYuT1q5PmeweZBExHo6E0uuD6BnOcXp0dr
SfsEs+1mhApZz8e7fW9nicDdNIB5SkzmH7fq2expIvDNn3XJi8tEkzrquk9q
Iki955S2n8nEup0dty5OFUEl1bHNnM7EzifLFhyTiOC54Zn+8UpM3OqfKdog
EkGSqPDO30EGXow5xZ/FEkGD+N2/o70MNA6eqaQiEEFn833xj24GTg8J84tR
EsEua1d51R8G/i2z4h0YEcLzV7dznjYzMHv3kmazASFM+mn7saCRgfM+JC6T
Dwohh/uo6cFXBtpee94U1CaELQsvpN75yMCyHGWtyu9CmG2161fmWwbqPIhu
q2sQgiJ40v5JlQzc523+9dU3IUg1T2Tefc3A8hzhhX0fhFAxR6v14UsGrixJ
r9pbJYT6kosXi54xsEPv+d5lL4XwvcM+u+YJA8++/La6qVAIYZ/LxDdJPnpo
WX34ayG0q8eGzs9n4NzZvr0Rv4TwMTDf4GcuA/Vd1i+dVCCEsigv/th7DGTk
WW1YkyOEeXnvLSfdIuvVpxZvyRTC0bdFbz1vMtCSdVBekS8Eg8cFJXCdgQUr
mwdibgrhxZynF30SGThD5di2pSlC8Mq6nHU6noEZd2d+V1wUQqvcQwoXGXjM
98vBO6lC+M9OjUqcYSCve5XUKk4IHbnjYzpPMtBO0HRj7Wkh/BkT4jDtKAPz
rHb7SqKEMKg+b4ztYQbaly5KM44RwqbN08y9DjCwj2W4IOSAEJTn6dhf28fA
0sippV77hPAv+3jEj93kefnxCW9ChKBxP61jdzADE47MtPcl7aHV3uUzgxj4
o+V30xh/IVTNrtcN8WPgpSefK//5CGHRvylXX/gw8G552tVWdyHEJy2f99qL
nLeGZm3hFiHcuRqsMmE9A59oHAhe6kr2u2TK2SBXBl6+mX2jYpUQlprtE1Q4
MfCRpJihu1wIGx74qC9bwcC158/WTV0thMtN4TyZIwO3Nt6m7wwTQlP6r/2z
HBio7Gniu85WCI8v1DWdtmPg4F+/ExFW5Lwsns4ZsCbzKU7M3m1G1nskT9gJ
DHTzDdAJsRTCEtcZQV4KBgZYjbznGQqhWT31RPVccl55dTb3dYWQKKs4ZGPM
QO+s1xYfdYQQOdPXIU+PgdrDb7b66glB7/tSp8e6DCx8a6IRNFkIpg41fbOn
M8j3habxmYmkPnjq3vc1GHgonbu9TSaExUW2S9LVGEh9LzzgTdo9Uv/Fm5Jc
pXb47hShENRXW8Q9UWFgRIlR2VYOWU/6S8UiCZmP58YNM5hCaEnbdbuGx8Ao
7TQ/n2EB7Hrw0j+PZMo5x4/FbCFYJ8yv8GYysGJMTsTnVgGY/ad2eWgsA+XE
JU2LPwLY4zdRFveXjsotiQGb6wWgbOsp6hihY+amHYYNbQI4Fb/UQG+Ajurj
/X1CqwTwS+vF74ouOnKyJIz8IgHMZN2zDPpDR9+rB+9KigXgW914x/Y3HSs5
R8O2lghALbfcUpvk3tB4/a1yct965+mOa6HjasMcy4i7pL/15RvPGunoUHjC
RZAogHNvlbMDG+i4cL3K5sgzAph10+nms4908vtf0L3/ugAkQ32WGnV0tH0f
sPJKlAAurznlVFdNR92YBzWu+wWw+MP8ptPldHRqsCwvDhZALCPzP88yOhpP
sb4WeEAARkf8OpaW0DEmaYz9nS0CCN53ZDv3GVnfk/Dfy90EsKOU4/H6CR1z
FtXPD1kigFV+Pclq+XRsPUhNv+tO5useknf2IR2/pST9mGMuAPcOl30e2XQU
BfhorDcRwLwWSJ6ZSd7HrZVrzxIA5/KNo39v0PHVcSLD04KMZ/tK+286HR/G
nzF3mCwA9fNX6VXJdDy58fwbzXECsH25aV76FTqeMvXx/y0QwB0+5o/E03GW
+N92rqoAmnU+PI28SMYfOVsQM8oHveU5Zz3P0LF4/9Ranw4+zOnMv7fgFB2L
JN/OmjTzIc4w3bT/GB1jp2WtCd4oAAdN3YwJJPssdomePciHyT8LpFrRdJxj
//nDuR982CSOy+UdIusJM/Xe+oYPsXPk5wfC6Xghride+JwPzwpWNqzZS0eW
kXR9+Ts+sCi6WU2hdPztHcMrKeSD+dcXw7XBdFwx7rjD0od8+NtXF/IqgI65
NjcW8G+Q97Hc1Yt86ThuQejeyfF88Fig0/SA5JCpvUN7cvngtNW1p8CHjger
QipfnOGDWUv9r8frSX2uXXh8ThQf7j3sHVPgRkcVj4UzDHbxQSPy5jxDkheG
7R56S/pv2YQmhc50XPqIFj2HtF955h75cgUd10Xe/pW6iQ8TKga/vVlGx6rc
q91Cdz58D969p2wpHbedcZs/dycftqU9Xf3Vlo55p1OouQ58cAj7867Tio5Z
Nob174APS8LyPWkKOnqMXSC1MORDto1sYqQFHWcXf3t5bDUfThYEdEwwoyNt
qeXGtQZ86NNfE2liQkdFZuH1o9P5sCrmhXiFPqn3iSrvx4v4oDQ9Y0SZZJfa
G1p6qXwQGwkJJ106atyr+nXIhA/vV8muBOrQcWi5Q1Yjiw+PL16bfEaLjun3
aLeUmXyQKr8792gKHc9o6XGt+3nAujivy2YSHctm/Ql1kfOhljvx71dVOvKK
5tUrWnmgaty6nKdCR9c9jpTSnzzYk5V3bJ6EjgZ9/eOHm3iw42Cc6wohHTUf
lVkNkfEShjm3/fh0HFTb4rntHQ/4X7zvJLLI87zQZe1lPJjh6RRbS6Vj6HWX
yhHkQerZ4aDQMXTcuPqK8rg6Hhjc2rZcpETHpKwzHMo9HlwV235fNkzDFNlw
5ehtHsR3Hlh2oo+Get69D5de5YFIZUrjky4annCcPVyRy4ML6c8Pv+6k4cmT
7pUD53mgE51/SvqHhhasevqawzzoLJdscGuh4cbPyuN3hvHgzr9Ra9XvNBz6
IfoWeoEHTyKjhq9/o+EYuc2j/Tt58C6i0qXnEw1VBqp0aVt5sM0tZ5f1Bxoe
umv9M3oLDzLebk+ZUUfD7uLTQPvDAz2XIcfzb2nYmtTceWAdD0JV7889S3Ll
b8OAJXt4wHUJaP5dScMW1S0ao7Y8kNb8NLJ5RcNA8sf3mQ0PossUxokvaCjZ
a/drkhUPhrNSt08j+cYZHZeJZDzeQ4cffwtpmJEqydtoxIPeCCVr9wIa9quv
WmpmwINX/nOWPX1EwwKB58oBTR7kvNuz9e1DGsZOyXm9zJIHP9Wa/2rdp2Hk
YEwORZ0HxruVVp66Q0Of8x6uZwU8EMTvWzx0k4b14S9XZtF48DsooyHhBg17
ba3ObSH9nT+4fdqURkPaiizR614uxGUl8euu0fDeQaPSBd1csLixqtbuCg1V
/wxSIzu54BMH2/deomHZ4vyNm8aQ8918wAQv0nDPfyk8lUYuzD4KWnPO0nA1
hCc+beDC3eTk6/dOk/1ZEG7HreGC/bGpL3acpGHMfd/q6U1cCJr7MlvvONmf
dVozbZ5x4fKtaruswzRsXnq/mPmQC49TI8T1B2j43lMkTp3Hg3zjps0GJFfO
1LoyP5cLb4SMUwcjaLgjb/qES6+48OONLudBGA2Jdavee2Zygbm0XtcilIb/
SuaGlqRxwbH1QOHzYLKfISFzFl4ieUl3xO0gGnKqas77ZXHh7cLULysCaejF
sVhSFMuFF+Xvdn/1o2GNnbVHzGEu3KtbeyhoMw2VDs08v2o3Fw6VFs5s20jD
BU6OtKJTXFBbGkKnk9xqaPB9fAAXTpwMHUjwoGH6zIPDYZtI/7C7Lsau5Hxq
bKrWeHAhVNG3fKEzDRWJvrHcYC483xw49fVq0l+netDNlQvH/4nX+K2gYZjY
U6G6jAt9S7q7Ofakfh5o4kUFFzpODsTfX0zDKU65OhvWcOFg5o6u2yRv+Gbj
qmvBhVtlg44rbGj47viflMO6XDh2uF0wCOT9mdmnNWZxIXu4cPo1cxpuVxpY
U6bOBbvS58Q8krP37xyXaM4Fln/TpWVzaFjoamhxV0Tmt6jSZ9iIhhcMV2xa
TnJOkGNnoyG5z25qxhUnuBDFHT54U4+GWmAs4VDIeW+mRdTp0jD0fLnfezUu
hDj+6FmnQ8P2jS00WQ8HruaIcsTaNEw0vn7jYAcH9Gvo+FKd1PO5MY0mPzlw
9LHHzmNTaBgR9ajDhYw3duFy+QE1Ui/sxc/NGzmgfGpPzvzxNPyxZmab9TsO
zJ+gcmFERsP9r+G8yksOpIoOrF8lpeF/axoMRWS8F8ZPCx6LyH1X+Xgvr4gD
y0b4WuE88n7f9ckzCA4keF4ts2LRcFFg7/3vORx4uWb5qCGDhibsd0z1Cg4k
y6W32TTyfZXuFPX5HgcOx4hL3ijR0DdjisfRmxx4PGQ1/uoIFe8f79znmMIB
9mYaQ3uIigtCzPZokv6KGU5JfgNUHO18cnd7Age+XOlba95Dxf2Ozyb9PcGB
xF311vwOKr7UMwXYz4FbGa2g/4eK7w6vizt3ngNTNhW4NbZSMW6bLe4J54DB
A+fEh81UdCp7OO7jNg5s4bg5/vtOxQfx7NOHv3PA1XATL+YbFWd9mfvvRAAH
fjSFLLP/QsX6d8khav+R9epkJfl+pqK82fqF1IcD4/1619p+pOIbi703Jc4c
GGNAMdWupeJ83vohQ1cOjB262h/xhoqdDbPjCjzJ+BqpRkySHQ8G22TZc0Dg
eNO+tYKK8+jRwi12HGjR/HmospSK4hg/F405HPBPrPj74jkVNZjrE3UWc+D2
RpPaXJItXx1Nv2jEgRWTt0JSIRW37bpa8XAqWd/9jcTxAireKZXpXRjHgXWF
tBWheWS++d3RdCkH9kZkTNIgedwxmmGGHgdG1Q36tjyg4syNsT/ZXA6UNJdn
uN6jopv7eR0WhQMBDs+3Ls+k4t6rL/Vu/2PDQ/kindjbVGx+ZOx+ioxnX8ww
tblBRS3rD/YBw2zoqIzkWlyn4qtvW0qvtbOhbpzOz9nXqMgN+byt7TsbxgSy
SqRJVAz9uTgMB9lg7NZfaniFin8kDMt779hw3+trln48FZ/injUf3rJhSQtt
U89FKmblrZ84DGQ/aE1n9c9RMcdr2tPccjYcObTx+Y0zVBxveOFdwGc2PB9H
22sYS8XHpXfcsp6xIXjXgnWzT1Jxcpey0PE+G063JJqZR1NR98NKQ/M7bLh3
7uSvlUeouJZ1OC+5iA2ZujNF1lFUvLLaW/YviQ2s7rZPyyLJfi8yKZ2QyAYs
7k9aE0bFu70bJnddZENSU+Wg4D8qpv0z+1dwiw0TlF1cNoWSevQOC+mMY8M3
g6lKu3dRMf7ys91/T7Gh2GTH+SNBVCxMN/hQfJgNesPuLz5tJ/USs9BkB+lf
JPJQveRPxd3vy240B5H9DqOeuLuVivmth7Zt9mXDp8HI5hIfcj9mrHM/tYkN
T2OKldCLnI+uV8GnvWzwJ0amN26gotXmpsQdrmywKj634q87FVv+Htrx3o0N
sfdDPMa7UvFzWpjjwqVs+PzZcW+2MxWNTnZsvryBDTd+vrKfS/J6z3BTIzs2
EBtRbe1KKn76W7XdzpoNX4okR2IcqfjMbqXUMoUNJRWR5f8tJ/eRPcd2mzkb
7E+vUXq0hIo17/Nuf1zEBp/tC9ckkXxHsFX/zDw21EwDfLGIikmHxAEFU9jQ
FJSm1GFFRSXuJ0mvKhvGr36gMh6o6H9eXkxXZoO+v9baSgW5j6c11Yv02JDm
k0FfaE5FyUrV2iVMkgmiZMccKu751QS32WxQ/DNbl2xMReXRJRW1oyw4lLjd
c9CIiqcOpWdkyMh6zT0Ka/Sp+O1Ghn9qGwsi+Tv6GLNIvYaytB+2s2BsKNFv
Pp2KTMrVk96NLKhzWvjcaBoVSzxUXpiPsCCg91TRDk2y/n7vhYerWbBvvaHr
rSlUnOb6d+rcKhb8ofY/appIRdVxpoRJJQsiWsE7XJWKMvcufd53FvCO6H9W
H09Fs2+TDpU+ZwF0GL30lFMxRMc3r/0xC04kuOxKFFNxeUdbceU90r/KklMv
pKLmrQ8NhaUsmGs+8P0rn9yXpR+67G6x4LnMximNQ8WD2o6LdnLYEFjjL9Ek
Obn0hpCZwoK+u+OVtjLI+yzKKh4ksCDtD/PwYhq5X4m/5q7OZsH7LW4ZdyhU
pB2Vly6JZcH8mnO8wVEKensueWxyjAUzmHo6ViMULEt00C/ZzYKE0cU5LwYp
mF5FxPdeZMFa5+NKpwYoGFcw3tM5nAVadirH63souN3i4yeDKBb4JMx/pdNJ
QdvPLSfoO1lQv4+zZHUbBTtfHDv3JIIF2423Ef/9oWBsZZ1O4DYW0KdLN77+
SUHnoFJX5U0s8M9OfajRRMbTcNgT5c6C8Jw703obKajEv7nYbysLduqfy99D
8vKHipvznFgQPcHNt+oTBS3ebs/bYMOC7+yA5zM+UnDT0d1GOsCCuM8zJ6XU
UvCFQSezdCXZj5tLyw6RfCDy9VITfRaMK/APaXxDwWUrCNOuaSz4LHJ6BZVk
PjW2sp8zWaCIjChOfEXBbQW7HvRPZ8GNMyZjvEhODnu9wtSMBb5dOzaMfUnB
jFpxVbwGC87znRncEgq6no88KSH7V784J8m7mILUuIJJS8QsyAgo2V/6lEJ+
m47dyOeT9bAFmQYk+7HTcgumsKBjydwxBgVk/06Kr7xgkHrJi1G7mEfB+6Xr
bXxHmaDMuvxqbC6Zj+qveTYDTHDbadIoeEDBW2/nbh9ik/NbHjTFP5uCk1+d
1BvbyYSHOz8KPmaR85IWGlR+ZQJngu+5xbco+M7w4ZcV35gQeWhb2N8bFFSp
hSFpFxNCyu5nP0qnYPXURqOCT0wY7Xb00Ukl52ecQzAbmPD7W+2tK0kUnL34
QfHEaiZ0fFrqMnSVgrX4KelJPRMOlXw9JLlCwbkctfPs1+T9GZyOo/GkfizV
hsTPmfDBp/vnmPMUvJj7rGpyNhOErsoL6WcpqE3TzfQpZoJ39pygvXEUDHYM
0d2XwYSnkn2H+05RcNJI2PzGFCZIP3hN23GcgvnDCXLBNSZMS543Y0o0BaeG
LnHzuE32RyN2ZecRCv5rWDkx6CoTgnxS6i5GUTDMbuBQZzMTeqszGYGHKPjy
9/Ze1RgmzIzdYNW1n4IaNTwVhxNM+PJpfrFdOAUnNF2uZ59jwr5SZ1pwGAUz
A4281x5mQl2y2dLBUApqDd+Iqw9lgvOYR/Lw3RT0qbR+77SRjPfw51DkTgra
mHw8eTqMCRZhkV50klcvoizf4cWE4a22BqcCKHjbfcVJB5LNSp+EjdtGwfiR
wtL7LkzYUC1NebmFgqHb3b43bGJC+7Lzdqkk791yLrl2OROCVx2LM/Qh57u+
zfWNPRPSfzi6PN1AQd8d1+PCrcn53kk57+hBwZJGahXFkgn0nSbxaiSrqggl
LQ5M6KEpHL65UvBnbNrsvcZMePKhIWKXCwWjtwdqXpxO5kcopnGcKLhBuPnz
MXUmXFq0Nnf/Kgo+1vTJ85vDhEeNU22SHClI+7zcUHk8EwqYy9/NsSf1ZJ+m
7idiwpsT+z9U2VFQYmWylUvyj9RlX7sWU3CW/77Smsnk/Nbvd/BbREGjXUFm
YWwmDBoIo3RJvn3dYuKoGxMWjJWZMq1JvfRlWbwYy4QJ4dQTqUBBHqvd8mg/
A6qU2+oDFRR0/CXqnccl9REwztHagoKLLDrdzvUxQHlQLfL7XApeSqvpmdzF
AH38qhY1m4IObg9/vG5jQME/05h/xhTUdKk8pN/DgLxOPa3pRmT8W+Pkhz8x
YK/Z+3PlehS0YldEldUx4Flx5vYdMynYcWQ1y7SaAX5ExIcLMyhY/LwtobOB
AT1mB7LGTyf19N/I3s5yBozmzXB6pknBu8TJpIMvGNDXEOqxTZ3sT6vg+7Kn
DDCckH4WJlOQ3fmpgFbCgLN37MpVJlFQsNh/YW0OAz7eDbpcPIGCYw+Mr9Z9
wIDEylcVO1QoqJum4nktnQHFTt03emUUfFLdZrH3DgNmbzH21CA54rTz1D8Z
DOBYRTnUiCho5tXaIE9iwIqTiVei+OS+zWmIZJ9mwKTmg425HAo2Ko/m5F9g
QNbXDYvNSN572PiK7BgDahKZ326wKLhD9sdcXMMAc5rdvq7ysbhuWofvzuUM
iHbKWdYaNxYV2V7bxrymg3UWa+c+17EY+CnH9+MKOoSvqBmOnToWNZYwt9S+
o8GtQmqGcvsYHKyp+nhhLQ0+6I8vG8gbg/73HDfzv1Lh2suPMs0jY7B2ApZ/
9KPC+Fdvwo6vHoOKfPqnLcMUcLv4WW2y1hh8rPMrLz6aAvc/WylX9ynh+7Op
8mgVCji1lu45W6KEJx6taS3KGAu5jid03BOUMLZaebmPxVgoVXwYnLxdCXtc
clfufjMGrui3GryxUsLBZbf1FL5jQMsxnuE7Tgkdvxx/Y0sZA3FjV6sUfB4l
4v7JMkIvKYHBFaXZy06OElJ9m5D3pkogGezICpo/ShyN8e7zyhhV5KZON5rU
8Y+45m7RrdTyT5G3/vdHq+R/xPf5Sl12s/4pJizNpr5x/kfEn3kfFbX7r0L6
8psrwftHrK5tbpj7eEShput+e6ToL2HWfXCp+uCwoqYnbWz4vr/ELfcFvncU
wwqJjsqmeaZ/iaseEyNDjw0p5gb7ibS7RojUhVcs39cNKlY7ZajPyRwhbm2I
neKsM6j4VWZat9F3hJjW3hEu2Teg0HFNsEmZPkJo1jw2OVDVr9DJcj75p2WY
iIrb9+6wZr9i7EBK/JyMYWJtjtVk6719igxaiMu+rcNEc7zl+mfVvYqVget9
c2YOEzbbPFpLpvcq/E9P2/mufYiQpPoc0DjQo3hQRnlcnz1EOFZoy1M/dSua
39tGYsgQsX4w98rlud0KF71ZyXvnDxHcmYIfyee6FGa/VVsZtCHitFJvjlNv
p8Kqw+CRx6tBwmzzz770VZ2Kip2vnfedGSSm3G8oqc/uUDis/Bvvum6QePxd
J2KVrEOxp6HDoldrkOit2Wc+o61N8WN/yD6bzgHijNPBsO4HfxQz9mqELno8
QHhWEp71Eb8VNq4tFX2HB4in3yq17y1pVRS0pPTbrxogHKU1ApryL8WCFdO+
L5kyQET6eK71/NGi6IWyDT/b+ol051s5cL9ZUX6ZekfjST9xM4O44na0SaFy
5/P3vmP9RGJn2jSZ2w/Fq0g44OHaT+y33xBhqfNdMX94bMsanX7C2vmjSJP+
TXHGVPGscbiPWNAz2Hn+81dFnPvo175XfcRo7jGlsCdfFI+OXxqOvdJH2MSN
SnPMPismMlU0cwL6iAMtOpdGhuoVBRfPLHG26iNUMUKcefOD4po/58EeeR/R
tpx2dcitTkE9VxOp8quXmLg2fUOa6jtF+S+2skFBL6F+060ouf2NQq3IYgRj
e4nALZVp9wqqFJmj/J3Fm3oJ3f8mHB2a8lqxy1DbwNyil+AGL57wM7dUsaZn
1gd1SS8x91kC18ftueJAV47N7p89xDPatGiflqeKXe86xppiD7F+Sv8SQ7V8
RdLGRRzP8z3EAmlClOqVewqLv+F2Hf49hHOM+ObkxSmKx00+dT8W9hCP7pzr
5HD2KtTX20bNn9RDHEh+tsi4JJ74w047OtDfTfy9q9QvUc4keg7MZomrugle
mKnG/H25RHKZ+6qjN7qJU7Z+1oLnBOHlPC7Y7WA3sc37Md1PWEQ8Nlpec9S9
m3CneP3zMykh5iksygRzuwmbrADvKSavCD3eSN1vSTdRmNH6QmlCJbHTdOuc
Se1dxJHnue7lk6uJP3dTwlJLu4iLxlH0ykk1xD7vcP2w611EdnLMPar6O2LG
Z8O+tMgu4nbq+vnlKnVEagbTZIpHF3Hf627SY+kHwu3nqvSWeV3EqoTge5O5
9QQ3M3doRKWLmGQxp2AW7RPBfcMfcOvrJGJPCb3f//5MlNonzWDUdBJsm41W
Jzu+ED1G/f5DdzsJ63NPN9xv+kokGyaeNjndSTg4vPLfV99IJGw/FJrr30mo
BtncfFL5jbh127k2bFknodLmcGtR3neilx2fGD2zk9hdbN2xJO0HYTH1bsF7
Tidhkv5fyOuYJiLFLtPUt7WDmLU8TLMytJkI2FpabVHWQeR+Toq649lCWEzq
uOZws4Mw9NR/0WT1k6jrrM+4doxkg4/l12b+IjKnTG839OsgzFdOXWokaiVe
3bQ8p7Ssg3CS3AzO7mglTn3bcYit20FMDazNoL37TayU6rYuF3QQoqPh3x0f
/CGWGu55efVrOzHYOPV61dE24u2lppWS1HaCZUCvpnm3E0NuOdsGNrcT93Mq
T01Q6yBaLyvHL5vVTpjNrs03ie4gxlKmmom62oj8U6Pzp/R0EMsoqV8X5LYR
OqusE1zcO4lr8wKyGv5rI+JvjVsZ/7KTyDd9bPvNso04dCzE0l+vi4jSbdB3
ZLUR47JXvnI+30UI9QsmaFX+Iba6T1w4RqmbCNveZOd5/g/BTlTc2ePdTfSd
rd7/z/0PsclkYzy+7Cb+B+YTMeU=
          "]]}}}, {{}, {}}}, {{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          PointSize[0.04], 
          Thickness[0.006]], 
         LineBox[CompressedData["
1:eJw1Vgk4lWkbPnGyL8fZvnOO9dgjLVrmN79630aTZDKUEFFJaaJ9tGiRdi3U
xBShVBOZEdOUCL1PqZSUGtkj7UWKg1CW//u/7+tc17nOdV/ved73ee/nvu/v
U4aunrNUjcfj3aO///89PZyQfCDDGGwd12xd8pnCiwIcIkPXGUP5jmn9s2ls
8fetqd+7GUNddF3oZBo/015oJBQbw+d9/XtMaHwqtP/l+1cK+Hx1kwOPxguL
juXfuKKALV1E+LyHwubiMXHJexUwfrvH1+s0bo68G7TWXwFJ5/RTkmmcfjt0
jIe9AtoDX6StoXGI2SBP2S+H6VH3c9xobLbxeFXfPTnAsMtyIY2bKseff5Qi
hzaFS+jTbgqn2VdsyoqQQ/GJvbYZNA6JXea5w1UORZFJExfR2LSBZxagL4cJ
VRuHZTRucj7ZMbZZBq0tFz+Ud9H1ByeVaubK4GbP0zlRNA5+VZn0LEYGO70D
NlE0Np2yYvlVbxk8hZSjeSoKP03i/zdBKYOlTgcJonHqx3T9cBUF5n5p+rc6
KbzA3aVlaikFinelq11pbHK66pI0kYLUk+Mgs4PCjX0r93wMo+DIP03FfBqf
9NEKuDOJAlF5I3/OJwoHZZ9xSNegYHtoiCT+I4WN1acMRtVKodA1dsbVdgo3
BNVWzs6Swt5npOz+BwqnXF57xmazFCYiWeq9NgoH6utFDXpI4fX9R0kXWyms
WHbevVohBdfD9T6b3lO4/jpW5LRJoHYacbZ+R+FkqvHD7mIJjLpuG5T7hsLz
10SRBYclUDjiTqb0NYVl9wx/mxgigc7syiy/lxSuU2aH6Y2VwOiUWykRz+n6
6OnfvRoWQ9WV9BCfZxQOqGrWLn4kBuemGWvVmygsH7356bEMMYwd7/5iawOF
a3eLciPWicG254JHQS2FTzTlxLq5icEjsrs49wmF/SfP9DUWiyHGfXTpgsf0
+QkvbLteiUCwvdq94AFd/3Zrf/kVEZRUVR+6do/CxzFVcWYvjd86GAfdpuuT
/06P9hfBy10LLx0BClMqz7Vz7EWQIs+Z7FNE4ZpZb9wc+oWwSetq2tErFP79
7A6pWrkQUpIe1v+YS2G/AcX7+hQhxB/NK12URWHJvCtFf0cI4XRZntqT0xSu
zvk5Ps5VCDYlnl0JJyicpNG6aLG+EOqDTQ/tSqDwvIW7J7g0G8GppW7TUvdQ
WFxgpmGUawR3Jk95czuawk8EhXXvYuh1rV/iW1dROPGXuX+CtxG8+Nc7UrWY
wr4327edUBrBMmujvNK5dL3xfu81KgG07vth6Q/T6fr1llYzSwUQ/arb23sC
hY9VFPeYJwrg2JZtjyosKDzXxv9ub5gAOn2l1xL1KCza3plSOUkAGyek4p2f
pbiq5uDKTA0BGEYqnkY2S7HNwp92DF00hOBSL5dRt6T4nCDW5qK3Iah5vHOO
y5Ri65tXyoNVBuA1Z0Rd0H4pPru+dbV+ogH0zZyye+UyKbayMZeUTDKAnUsM
DPdPk+IzNXOvRdbqQ9qGAdl6uRRb7t+/0GSzPuQWzo/pbpfgMy4l/AqFPny3
+xzv8XUJtmzrvLClWA8WqBpNHxyU4IxU258dQ/Qg84qT+0VfCVZ6BXU3DOuC
z/CSMFe5BLN5pQs1Rqpyt3oxl0+6cK6q4J/jiWIuj3TggGY0lniKufzRge3L
ixSZAyIub3Sg/4DdBY8LIi5ftGHO93Y3DX1EXJ5og9O5vnS7biE2YfJDG1o3
ik89+02IU5m80AKfT0722U5CLh+0wPxVb4b5bSMuDzQhY/M798H5Rpz/NcHt
94bV5u0Czu+asDporeWGGAHnbw34moCyu4wEnJ81QLtu0swPsww5/2pAWNC6
6uAoA86vI6Fi1c4bsnP6WM74cyQ4nS9L96vVwycYP/JhwFjlnmWghynGf3z4
I0QWr+uhi48zfuPDUNbNItkeHc5f6hAaHHpo6g1tzk/qUNmMpLwBLc4/6jA3
ccw++4lanF/UoObP60VtyzU5f6iBbE+Y76dkDc4PaqDKH2x0LRuJJYz+R4Dd
DEu5ZSef0/sIyEQWZloyPhYx+ubBAVmbr6erOqdnHkQNfWkxDVHj9MsDvep0
y+htI7A1o9dhcjvvu7c2KTxsxehziGy/GRK3K3wYKRk9DpH2iNaQa8cGkQWj
v0HyY/fUdsOCr8iC0dsAKcl16i+o6kfmjL6+klKjGxvU3/QiU0ZPX0mXw4Sd
Xh97kCmjny9kRfX3cYNtXciY0Us/ORtRPnFlcycyZ/TRT/iL53o3xn1CZowe
+kjY5YhTu6e0IVNm/r1kQQ8/YVbNG2TCzPszmTSZf/v4nBfImJnvZ3LH6NDh
7MWNSMHMs4cMnem71NL8GMmY+XWTn2RTMrdOAMTOq4uEPyr9j4fuKcLOp4tU
aS92Sdh7l7DzUJH4S04aR1tqCJs/ncSMClFEvm4hLN8dRCfzyN3B2DdEyPDb
QUoD1kDWjA+E5fMjcf99HO+5vJMoGf7ayfjn4hPJ1t3EjOGrjUSt13cZ79ZL
TBh+WokoMDhHN+oLUTB8vCd/jQ15OaZwkMiY+78lIQNe6op9PKCY+74hl1IU
d01c1EDE3O8VGW6stYrsVAchc5+XpD19Xn/8xZEgYPp/Tr6caYm/u0oT9Jl+
W0hVysNai3HaIGf6ayLVl48V/NqhAzZMPw0ksNZHPSFHDyyY82tJu9e+dR5L
DcCEOe8JSY/bFVuvIwAFs/9jsurqirSTzQKwZ/Z7QEZenhW2KMcILJn6MhJg
Y9r3boMQKOb/N4gDyp/q/l8RWDHrV8kBmfJgwxcR2DA4k/x8+YZyer4YeNyn
Lja813eVBGzZdXR4xTZ5r5UUlGw9QjGSTkmd9Nv+yGZbUc3+gxS3fxnqWFIy
pIZk4Mj2h9RPNqXpdMm+9Y+6KtP39GbKwZS9H1rRGdbQG6z4dn9kOWi3QSYx
/sYPCgz3W+T1wBhGsfyhfmt5VMxeE6BYfpG2KvXXOGwKcpZ/pBmmedr9qykY
s/NBS7ovex/PNwMzdn7okHPRsaB15mDOzhfdNmk5iSgLjr+3yPXzfRQdZQFy
Vh/oB7894voqC+D0g/I9qrG/sxJYP7ahcD9ny/YjSuD0hzxn4az4T0qwZPWJ
Aj/OD3T0sgQ2HzrQWNV727y/aMzqG1mIVFt0dK2A0z9Kmr3poeMvViBl/YHO
2kuL9cqsgPMPGpXnOynX2ho4f6HnduFh5jutgX1/6UbuR68p1z+zBs6fKPjC
obIyVxvg/Iv41oPuU1NozPob6X48XNLTawOc/1F1fffMkX62wOUDKim9VbDh
si1w+YHKf7xZ6SayAws2XxC/7162/zo7ULL5g6bsgvOJj+3Aks0n5Dp7xvam
cfZgxeYXSk3y/dfsiD1Ys/mGHuWH35n3yR5s2PxDxak9Hke9RoEtm4+oIiup
sj1nFMfnEErd93rXYX0H4PIVZTz3XHBkpQOw+cDDi/943Wnw0AG4fMZ2szYu
kY91BPb9hId9R/JXFh5xBC7fsXq+5fEelSPH/wg8cbRaaNW80cA9H3BshM8K
/8LR3DzU8E/qh1t3mTrB/wCUsu54
          "]]}}}, {{}, {}}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-5.298317366548025, -6.907755278982122}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000], 32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000], 73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000000000], 82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000000000000000], 87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         